/****************************************************************************
** $Id: qwmatrix.h,v 2.0 1996/09/24 10:16:05 agulbra Exp $
**
** Definition of QWMatrix class
**
** Created : 941020
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QWMATRIX_H
#define QWMATRIX_H

#include "qwindefs.h"
#include "qpntarry.h"
#include "qrect.h"


class QWMatrix					// 2D transform matrix
{
public:
    QWMatrix();
    QWMatrix( float m11, float m12, float m21, float m22,
	      float dx,	 float dy );

    void	setMatrix( float m11, float m12, float m21, float m22,
			   float dx,  float dy );

    float	m11() const { return _m11; }
    float	m12() const { return _m12; }
    float	m21() const { return _m21; }
    float	m22() const { return _m22; }
    float	dx()  const { return _dx; }
    float	dy()  const { return _dy; }

    void	map( int x, int y, int *tx, int *ty )	      const;
    void	map( float x, float y, float *tx, float *ty ) const;
    QPoint	map( const QPoint & )	const;
    QRect	map( const QRect & )	const;
    QPointArray map( const QPointArray & ) const;

    void	reset();

    QWMatrix   &translate( float dx, float dy );
    QWMatrix   &scale( float sx, float sy );
    QWMatrix   &shear( float sh, float sv );
    QWMatrix   &rotate( float a );

    QWMatrix	invert( bool * = 0 ) const;

    bool	operator==( const QWMatrix & ) const;
    bool	operator!=( const QWMatrix & ) const;
    QWMatrix   &operator*=( const QWMatrix & );

private:
    QWMatrix   &bmul( const QWMatrix & );
    float	_m11, _m12;
    float	_m21, _m22;
    float	_dx,  _dy;
};


QWMatrix operator*( const QWMatrix &, const QWMatrix & );


/*****************************************************************************
  QWMatrix stream functions
 *****************************************************************************/

QDataStream &operator<<( QDataStream &, const QWMatrix & );
QDataStream &operator>>( QDataStream &, QWMatrix & );


#endif // QWMATRIX_H
