partition_disk () {
	sync
	local status=0
	local disk="`select_drive`"
	if [ $? -ne 0 -o -z "$disk" ]; then return 1; fi
	local mounts="`match_list $disk \"\`mounted_partitions\`\"`"
	local swap_disk="`match_list $disk $Swap`"
	local dialog=""
	if [ ! -z "$mounts" ]; then
		dialog=\
"You have mounted
$mounts from disk $disk
If you choose to go ahead and re-partition $disk,
the filesystem(s) will be un-mounted, and you can re-mount
when you have finished partitioning the disk. If you change
a previously existing filesystem, you will have to re-initialize
that filesystem before you mount again, and any data you
installed it will be erased.

"
	fi
	if [ ! -z "$swap_disk" ]; then
		dialog="$dialog""You have activated a swap partition on $Swap.
If you choose to go ahead and re-partition $disk,
your swap partition will be de-activated, and you
will have to re-initialize and/or re-activate the swap
partition after you have re-partitioned $disk.

"
	fi
	if [ ! -z "$mounts" -o ! -z "$swap_disk" ]; then
		dialog="$dialog""Re-partition the disk?"
		yesNoBox "$dialog" "Re-Partition the Disk?"
		if [ $? -ne 0 ]; then return 1; fi
	fi
	if [ ! -z "$mounts" ]; then
		for m in $mounts; do
			unmount_partition $m
			if [ $? -ne 0 ]; then return 1; fi
		done
	fi
	if [ ! -z "$swap_disk" ]; then
		swapoff $Swap
		Swap=""
	fi
	cfdisk $disk
	return $?
}
