changequote(<<, >>)dnl
'\" e
.\" -*- nroff -*-
.\" `gf256.3' -- Routines to do arithmetic in the Galois Field (2^8).
.\"
.\" Copyright (C) 1996 Free Software Foundation, Inc.
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2, or (at your option)
.\" any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" Developed by Paul Flaherty (paulf@stanford.edu).
.\" Munged for speed by Fung-Chai Lim (fclim@acm.org).
.\"
.\" This file is part of GNU ecc.
.EQ
delim $$
.EN
.TH gf256 3 "2 Jan 1996" "Free Software Foundation" "GNU Library"
.SH NAME
.\" gf256_log_2, gf256_antilog_2, gf256_power_of_2, gf256_add, gf256_minus, gf256_subtract, gf256_mul, gf256_inv, gf256_div, gf256_product, gf256_exp, gf256_term, gfmul, gfadd, gfinv, gfexp \- Routines to do arithmetic in the Galois Field ($2 sup 8$).
gf256_log_2, gf256_antilog_2, gf256_power_of_2, gf256_add, gf256_minus, gf256_subtract, gf256_mul, gf256_inv, gf256_div, gf256_product, gf256_exp, gf256_term, gfmul, gfadd, gfinv, gfexp \- Routines to do arithmetic in the Galois Field GF(256).
.SH SYNOPSIS
.nf
.LP
.B #include <gf256.h>
.LP
.B cc ... -lecc
.LP
.BI "GF256 " x ;
.LP
.IB r "= gf256_log_2 (" x )
.BI "GF256 " r ", " x ;
.LP
.BI "GF256 gf256_antilog_2 (" x )
.BI "GF256 " x ;
.LP
.BI "GF256 gf256_power_of_2 (" n )
.BI "GF256 " n ;
.LP
.BI "GF256 gf255_add (" a ", " b )
.BI "GF256 " a ", " b ;
.LP
.IB r "= gf256_minus (" a )
.BI "GF256 " r ", " a ;
.LP
.BI "GF256 gf256_subtract (" a ", " b )
.BI "GF256 " a ", " b ;
.LP
.BI "GF256 gf256_mul (" x ", " y )
.BI "GF256 " x ", " y ;
.LP
.IB r "= gf256_inv (" x )
.BI "GF256 " r ", " x ;
.LP
.BI "GF256 gf256_div (" x ", " y )
.BI "GF256 " x ", " y ;
.LP
.BI "GF256 gf256_product (" x ", " y ", " z )
.BI "GF256 " x ", " y ", " z ;
.LP
.BI "GF256 gf256_exp (" a ", " n )
.BI "GF256 " a ;
.BI "int " n ;
.LP
.BI "GF256 gf256_term (" c ", " i ", " n )
.BI "GF256 " c ;
.BI "int " i ", " n ;
.LP
.BI "unsigned char gfmul (" x ", " y )
.BI "unsigned char " x ", " y ;
.LP
.BI "unsigned char gfadd (" a ", " b )
.BI "unsigned char " a ", " b ;
.LP
.IB r "= gfinv (" x )
.BI "unsigned char " r ", " x ;
.LP
.BI "unsigned char gfexp (" a ", " n )
.BI "unsigned char " a ", " n ;
.SH DESCRIPTION
This manual page documents the GNU ecc library \- routines to do arithmetic in
the Galois Field GF($2 sup 8$).
.LP
The representation of GF($2 sup 8$) used in this library is isomorphic to
$GF(2)[X] ~ modulo ~ P (x)$ where
.RS .5i
.EQ
P (x) = x sup 8 + x sup 4 + x sup 3 + x sup 2 + 1
.EN
.RE
.LP
which is a primitive polynomial.  The polynomials chosen are
.RS .5i
.EQ
f sub 1 ( x ) = 1
.EN
.br
.EQ
f sub 2 ( x ) = x cdot f sub 1 ( x ) ~ modulo ~ P ( x )
.EN
.br
.EQ
f sub 3 ( x ) = x cdot f sub 2 ( x ) ~ modulo ~ P ( x )
.EN
.br
.EQ
...
.EN
.br
.EQ
f sub n ( x ) = x cdot f sub {n-1} ( x ) ~ modulo ~ P ( x )
.EN
.RE
where the modulo is done in $GF(2)[X]$.
.LP
A Discrete Antilogrithm table is formed by evaluating these polynomials at
$x = 2$ which is a cyclic element of GF($2 sup 8$).  This representation can
be found in many textbooks; see, for instance,
.I ``Theory and Practice of Error Control Codes''
by Richard Blahut.
.LP
.B gf256_log_2()
returns the discrete logarithm of
.I x
such that $2 sup r = x$ for non-zero value of $x$.
.LP
.B gf256_antilog_2()
returns the discrete antilogrithm of
.I x
such that
.br
.RS .5i
.BI "gf256_antilog_2 (gf256_log_2 (" a ")) $==$ " a
.br
.BI "gf256_log_2 (gf256_antilog_2 (" a ")) $==$ " a
.RE
for all non-zero $a$ in GF($2 sup 8$).
.LP
.B gf256_power_of_2()
returns the $2 sup n$.  The range of
.I n
is restricted to
.BR GF256 .
.LP
.B gf256_add()
and
.B gfadd()
return the sum of their arguments.
.LP
.B gf256_minus()
returns the additive inverse of its argument.  That is, $a + r = 0$.
.LP
.B gf256_subtract()
returns $a - b$.
.LP
.B gf256_mul()
and
.B gfmul()
return the product of their arguments.
.LP
.B gf256_inv()
and
.B gfinv()
return the multiplicative inverse of their argument, which must have non-zero
value.  That is, $x cdot r = 1$.
.LP
.B gf256_div()
returns $x / y$ for non-zero value of $y$.
.LP
.B gf256_product()
returns the products of the 3 arguments.
.LP
.B gf256_exp()
and
.B gfexp()
return $a sup n$.
.LP
.B gf256_term()
returns the value of the $x sup n$ term which has coefficient $c$ in the evaluation of a
polynomial at $x = 2 sup i$.  In short, it returns $c cdot 2 sup {i cdot n}$.
.SH CAVEATS
Note that most of the functions are C-preprocessor macros.  Please, do not
have side-effects in the arguments.  Avoid functional compositions, instead
use temporary variables.  For instance, instead of
.RS .5i
y = gf256_add (gf256_mul (s2, s4), gf256_mul (s3, s3));
.RE
write
.RS .5i
y = gf256_mul (s2, s4);
.br
p = gf256_mul (s3, s3);
.br
y = gf256_add (y, p);
.RE
.LP
ifdef(<<CAREFUL_WITH_THAT_X>>, <<dnl
Any invalid argument value to
.BR gf256_log_2() ,
.BR gf256_inv() ,
and
.B gf256_div()
will cause the program to print a message and dump core.
>>, <<dnl
The values of
.BR gf256_log_2() ,
.BR gf256_inv() ,
and
.B gf256_div()
are undefined for invalid argument values; programs may continue to run,
but the results may be wrong.
>>)dnl
.SH WARNING
The 4 functions
.BR gfmul() ,
.BR gfadd() ,
.BR gfinv() ,
and
.B gfexp()
are included in the library for backward-compatibility to earlier versions
of this library.  They may be removed in future releases.
.SH SEE ALSO
rsff-f9(3)
