
/* The standard Maelstrom colormap */

typedef struct {
	unsigned short red;
	unsigned short green;
	unsigned short blue;
	} Color;

Color full_colors[256] = {
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xcccc, 0xcccc, 0xcccc },  /* Pixel 43 */
		{ 0xcccc, 0xcccc, 0x9999 },  /* Pixel 44 */
		{ 0xcccc, 0xcccc, 0x6666 },  /* Pixel 45 */
		{ 0xcccc, 0xcccc, 0x3333 },  /* Pixel 46 */
		{ 0xcccc, 0xcccc, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xcccc, 0x9999, 0xcccc },  /* Pixel 49 */
		{ 0xcccc, 0x9999, 0x9999 },  /* Pixel 50 */
		{ 0xcccc, 0x9999, 0x6666 },  /* Pixel 51 */
		{ 0xcccc, 0x9999, 0x3333 },  /* Pixel 52 */
		{ 0xcccc, 0x9999, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xcccc, 0x6666, 0xcccc },  /* Pixel 55 */
		{ 0xcccc, 0x6666, 0x9999 },  /* Pixel 56 */
		{ 0xcccc, 0x6666, 0x6666 },  /* Pixel 57 */
		{ 0xcccc, 0x6666, 0x3333 },  /* Pixel 58 */
		{ 0xcccc, 0x6666, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xcccc, 0x3333, 0xcccc },  /* Pixel 61 */
		{ 0xcccc, 0x3333, 0x9999 },  /* Pixel 62 */
		{ 0xcccc, 0x3333, 0x6666 },  /* Pixel 63 */
		{ 0xcccc, 0x3333, 0x3333 },  /* Pixel 64 */
		{ 0xcccc, 0x3333, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xcccc, 0x0000, 0xcccc },  /* Pixel 67 */
		{ 0xcccc, 0x0000, 0x9999 },  /* Pixel 68 */
		{ 0xcccc, 0x0000, 0x6666 },  /* Pixel 69 */
		{ 0xcccc, 0x0000, 0x3333 },  /* Pixel 70 */
		{ 0xcccc, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0x9999, 0xcccc, 0xcccc },  /* Pixel 79 */
		{ 0x9999, 0xcccc, 0x9999 },  /* Pixel 80 */
		{ 0x9999, 0xcccc, 0x6666 },  /* Pixel 81 */
		{ 0x9999, 0xcccc, 0x3333 },  /* Pixel 82 */
		{ 0x9999, 0xcccc, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0x9999, 0x9999, 0xcccc },  /* Pixel 85 */
		{ 0x9999, 0x9999, 0x9999 },  /* Pixel 86 */
		{ 0x9999, 0x9999, 0x6666 },  /* Pixel 87 */
		{ 0x9999, 0x9999, 0x3333 },  /* Pixel 88 */
		{ 0x9999, 0x9999, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0x9999, 0x6666, 0xcccc },  /* Pixel 91 */
		{ 0x9999, 0x6666, 0x9999 },  /* Pixel 92 */
		{ 0x9999, 0x6666, 0x6666 },  /* Pixel 93 */
		{ 0x9999, 0x6666, 0x3333 },  /* Pixel 94 */
		{ 0x9999, 0x6666, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0x9999, 0x3333, 0xcccc },  /* Pixel 97 */
		{ 0x9999, 0x3333, 0x9999 },  /* Pixel 98 */
		{ 0x9999, 0x3333, 0x6666 },  /* Pixel 99 */
		{ 0x9999, 0x3333, 0x3333 },  /* Pixel 100 */
		{ 0x9999, 0x3333, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0x9999, 0x0000, 0xcccc },  /* Pixel 103 */
		{ 0x9999, 0x0000, 0x9999 },  /* Pixel 104 */
		{ 0x9999, 0x0000, 0x6666 },  /* Pixel 105 */
		{ 0x9999, 0x0000, 0x3333 },  /* Pixel 106 */
		{ 0x9999, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x6666, 0xcccc, 0xcccc },  /* Pixel 115 */
		{ 0x6666, 0xcccc, 0x9999 },  /* Pixel 116 */
		{ 0x6666, 0xcccc, 0x6666 },  /* Pixel 117 */
		{ 0x6666, 0xcccc, 0x3333 },  /* Pixel 118 */
		{ 0x6666, 0xcccc, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x6666, 0x9999, 0xcccc },  /* Pixel 121 */
		{ 0x6666, 0x9999, 0x9999 },  /* Pixel 122 */
		{ 0x6666, 0x9999, 0x6666 },  /* Pixel 123 */
		{ 0x6666, 0x9999, 0x3333 },  /* Pixel 124 */
		{ 0x6666, 0x9999, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x6666, 0x6666, 0xcccc },  /* Pixel 127 */
		{ 0x6666, 0x6666, 0x9999 },  /* Pixel 128 */
		{ 0x6666, 0x6666, 0x6666 },  /* Pixel 129 */
		{ 0x6666, 0x6666, 0x3333 },  /* Pixel 130 */
		{ 0x6666, 0x6666, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x6666, 0x3333, 0xcccc },  /* Pixel 133 */
		{ 0x6666, 0x3333, 0x9999 },  /* Pixel 134 */
		{ 0x6666, 0x3333, 0x6666 },  /* Pixel 135 */
		{ 0x6666, 0x3333, 0x3333 },  /* Pixel 136 */
		{ 0x6666, 0x3333, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x6666, 0x0000, 0xcccc },  /* Pixel 139 */
		{ 0x6666, 0x0000, 0x9999 },  /* Pixel 140 */
		{ 0x6666, 0x0000, 0x6666 },  /* Pixel 141 */
		{ 0x6666, 0x0000, 0x3333 },  /* Pixel 142 */
		{ 0x6666, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3333, 0xcccc, 0xcccc },  /* Pixel 151 */
		{ 0x3333, 0xcccc, 0x9999 },  /* Pixel 152 */
		{ 0x3333, 0xcccc, 0x6666 },  /* Pixel 153 */
		{ 0x3333, 0xcccc, 0x3333 },  /* Pixel 154 */
		{ 0x3333, 0xcccc, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3333, 0x9999, 0xcccc },  /* Pixel 157 */
		{ 0x3333, 0x9999, 0x9999 },  /* Pixel 158 */
		{ 0x3333, 0x9999, 0x6666 },  /* Pixel 159 */
		{ 0x3333, 0x9999, 0x3333 },  /* Pixel 160 */
		{ 0x3333, 0x9999, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3333, 0x6666, 0xcccc },  /* Pixel 163 */
		{ 0x3333, 0x6666, 0x9999 },  /* Pixel 164 */
		{ 0x3333, 0x6666, 0x6666 },  /* Pixel 165 */
		{ 0x3333, 0x6666, 0x3333 },  /* Pixel 166 */
		{ 0x3333, 0x6666, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3333, 0x3333, 0xcccc },  /* Pixel 169 */
		{ 0x3333, 0x3333, 0x9999 },  /* Pixel 170 */
		{ 0x3333, 0x3333, 0x6666 },  /* Pixel 171 */
		{ 0x3333, 0x3333, 0x3333 },  /* Pixel 172 */
		{ 0x3333, 0x3333, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3333, 0x0000, 0xcccc },  /* Pixel 175 */
		{ 0x3333, 0x0000, 0x9999 },  /* Pixel 176 */
		{ 0x3333, 0x0000, 0x6666 },  /* Pixel 177 */
		{ 0x3333, 0x0000, 0x3333 },  /* Pixel 178 */
		{ 0x3333, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xcccc, 0xcccc },  /* Pixel 187 */
		{ 0x0000, 0xcccc, 0x9999 },  /* Pixel 188 */
		{ 0x0000, 0xcccc, 0x6666 },  /* Pixel 189 */
		{ 0x0000, 0xcccc, 0x3333 },  /* Pixel 190 */
		{ 0x0000, 0xcccc, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0x9999, 0xcccc },  /* Pixel 193 */
		{ 0x0000, 0x9999, 0x9999 },  /* Pixel 194 */
		{ 0x0000, 0x9999, 0x6666 },  /* Pixel 195 */
		{ 0x0000, 0x9999, 0x3333 },  /* Pixel 196 */
		{ 0x0000, 0x9999, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x6666, 0xcccc },  /* Pixel 199 */
		{ 0x0000, 0x6666, 0x9999 },  /* Pixel 200 */
		{ 0x0000, 0x6666, 0x6666 },  /* Pixel 201 */
		{ 0x0000, 0x6666, 0x3333 },  /* Pixel 202 */
		{ 0x0000, 0x6666, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3333, 0xcccc },  /* Pixel 205 */
		{ 0x0000, 0x3333, 0x9999 },  /* Pixel 206 */
		{ 0x0000, 0x3333, 0x6666 },  /* Pixel 207 */
		{ 0x0000, 0x3333, 0x3333 },  /* Pixel 208 */
		{ 0x0000, 0x3333, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xcccc },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0x9999 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0x6666 },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x3333 },  /* Pixel 214 */
		{ 0xeeee, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xdddd, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xbbbb, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xaaaa, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0x8888, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0x7777, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x5555, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x4444, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x2222, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x1111, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xeeee, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xdddd, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xbbbb, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xaaaa, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0x8888, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0x7777, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x5555, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x4444, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x2222, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x1111, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xeeee },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xdddd },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xbbbb },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xaaaa },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0x8888 },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0x7777 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x5555 },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x4444 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x2222 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x1111 },  /* Pixel 244 */
		{ 0xeeee, 0xeeee, 0xeeee },  /* Pixel 245 */
		{ 0xdddd, 0xdddd, 0xdddd },  /* Pixel 246 */
		{ 0xbbbb, 0xbbbb, 0xbbbb },  /* Pixel 247 */
		{ 0xaaaa, 0xaaaa, 0xaaaa },  /* Pixel 248 */
		{ 0x8888, 0x8888, 0x8888 },  /* Pixel 249 */
		{ 0x7777, 0x7777, 0x7777 },  /* Pixel 250 */
		{ 0x5555, 0x5555, 0x5555 },  /* Pixel 251 */
		{ 0x4444, 0x4444, 0x4444 },  /* Pixel 252 */
		{ 0x2222, 0x2222, 0x2222 },  /* Pixel 253 */
		{ 0x1111, 0x1111, 0x1111 },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
};
