#include "config.h"
#include <stdio.h>
#include <ctype.h>

#include "most.h"
#include "keym.h"
#include "display.h"
#include "window.h"
#include "search.h"
#include "edit.h"
#include "sysdep.h"
#include "file.h"

#ifdef USE_SLANG
#include "slang.h"
#include "keyparse.h"
#else
static void ctrl_k_map_cmd (void);
static void ctrl_x_map_cmd (void);
static void ctrl_w_map_cmd (void);
static void esc_map_cmd (void);
static void dec_extended_map_cmd (void);
static void pf1_map_cmd (void);
static void pf1_esc_map_cmd (void);
static void O_map_cmd (void);
#endif



int *Most_Digit_Arg;
static char Last_Char;
static int Edt_Direction = 1;

static void digit_arg_cmd(void);

static void page_down_cmd (void)
{
   int n = 1;
   
   if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
   if (n < 0) n = 1;
   n = Most_C_Line + n * (Most_Win->bot - Most_Win->top + 1);
   while ((Most_Buf->fd != -1) && (Most_Num_Lines < n + 50)) most_read_file_dsc(1);
   most_update_windows(n);
}

static void page_up_cmd (void)
{
    int n = 1;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
    most_update_windows(Most_C_Line - n * (Most_Win->bot - Most_Win->top + 1));
}

static void page_right_cmd (void)
{
    int n = 1;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
    Most_Column = Most_Column + n * 59;
    most_update_windows(Most_C_Line);
}

static void page_left_cmd(void)
{
    int n = 1;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
    Most_Column = Most_Column - n * 59;
    most_update_windows(Most_C_Line);
}

static void column_right_cmd (void)
{
   int n = 1;
   if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
   Most_Column = Most_Column + n;
   most_update_windows(Most_C_Line);
}


static void column_left_cmd(void)
{
   int n = 1;
   if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
   Most_Column = Most_Column - n;
   most_update_windows(Most_C_Line);
}
 
static void next_line_cmd(void)
{
    int n = 1;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
   
   while ((Most_Buf->fd != -1) && (Most_Num_Lines < Most_C_Line + n + 50)) most_read_file_dsc(1);
   most_update_windows(Most_C_Line + n);
}

static void previous_line_cmd(void)
{
   int n = 1;
   if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
   
    most_update_windows(Most_C_Line - n);
}


static void top_of_buffer_cmd(void)
{
    most_update_windows(1);
}

static void end_of_buffer_cmd(void)
{
   while (Most_Buf->fd != -1) most_read_file_dsc(-1);
   most_update_windows(Most_Num_Lines);
}
#ifdef unix
#include <signal.h>
#endif
static void sys_spawn_cmd(void)
{
    int update = 0;
   
   if (Most_Secure_Mode || Most_Captive_Mode) 
     {
	most_message ("Operation not permitted by this account.", 1);
	return;
     }
    most_reset_tty();
    most_reset_display();
    fflush(stdout);
#ifdef VMS
    if (Last_Char == '\032') exit(0);
    if (most_do_shell_command()) update = 1; /* scroll region reset by message facility */
#else                          
   kill(0, SIGTSTP);
   update = 1;
#endif
   most_init_tty();
   most_init_display ();
   if (update) most_redraw_display();
}

static void redraw_cmd(void)
{
    most_redraw_display();
}

static void goto_line_cmd(void)
{
    int n = Most_C_Line;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
    else
      {
          Most_Mini_Buf[0] = 0;
	 if (!most_read_from_minibuffer("Goto Line: ", (char *) Most_Mini_Buf)) return;
          sscanf((char *) Most_Mini_Buf,"%d",&n);
          Most_Mini_Buf[0] = 0;
      }
    most_update_windows(n);
}

static void goto_percent_cmd(void)
{
    unsigned char *pos;
    int n;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
    else
      {
          Most_Mini_Buf[0] = 0;
	 if (!most_read_from_minibuffer("Goto Percent: ", (char *) Most_Mini_Buf)) return;
          sscanf((char *) Most_Mini_Buf,"%d",&n);
          Most_Mini_Buf[0] = 0;
      }
    if (n < 0) n = 0; else if (n > 100) n = 100;
   if (Most_Buf->fd != -1) most_read_file_dsc(-1);
   pos = Most_Beg + (n * (Most_Eob - Most_Beg))/100;
   n = most_what_line(pos);
   most_update_windows(n);
}



static void set_mark_cmd(void)
{
    Most_Buf->mark = Most_C_Line;
    most_message("Mark Set.",0);
}

static void goto_mark_cmd(void)
{
    int mark = Most_Buf->mark;
    Most_Buf->mark = Most_C_Line;
    most_update_window(mark);
    most_message("Mark Set.",0);
}

static void one_window_cmd(void)
{
    most_one_window();
}

static void two_window_cmd(void)
{
    most_two_windows();
}

static void del_window_cmd(void)
{
    most_delete_window();
}

static void other_window_cmd(void)
{
    int n = 1;
    if (Most_Digit_Arg != (int *) NULL) n = *Most_Digit_Arg;
    most_other_window(n);
}


static void find_next_cmd(void)
{
   int col, line, n = 1;
   int ofs;
    
    if (Most_Digit_Arg != NULL) n = *Most_Digit_Arg;
    line = most_search(Most_Curs_Pos + Most_Search_Dir, n, &col);
    if (line < 1) return;
   
   /* note that only offsets are meaningful!! (version 4) */
    ofs = Most_Curs_Pos - Most_Beg;
    if ((line < Most_Win->beg_line) || (line > Most_Win->beg_line + Most_Win->bot - Most_Win->top))
      most_update_window(line);
    Most_Curs_Pos = Most_Beg + ofs;
   
    Most_Curs_Row = line - Most_C_Line + 1;
    Most_Curs_Col = col;
}

static void search_cmd(void)
{
   Most_Search_Dir = 1;
   if (most_read_from_minibuffer(
#ifdef SLANG_REGEXP
				 "Regexp Search: ",
#else
				 "Search: ",
#endif
				 Most_Search_Str) == -1) return;
   Most_Curs_Pos = Most_C_Pos;
   find_next_cmd();
}

static void search_back_cmd(void)
{
    Most_Search_Dir = -1;
   if (most_read_from_minibuffer(
#ifdef SLANG_REGEXP
				 "Regexp Search Backwards: ",
#else
				 "Search Backwards: ",
#endif
				 Most_Search_Str) == -1) return;
    find_next_cmd();
}

static void help_cmd(void)
{
    most_do_help_command();
}

static void find_file_cmd(void)
{
    most_user_get_file();
}

static void time_cmd(void)
{
    most_message(most_get_time(),0);
}

    
static void toggle_width_cmd(void)
{
    if (Most_Screen_Width == 80)
      {
          if (!Most_Restore_Width_To) Most_Restore_Width_To = 80;
          most_set_width(132, 1);
      }          
    else if (Most_Screen_Width == 132)
      {
          if (!Most_Restore_Width_To) Most_Restore_Width_To = 132;
          most_set_width(80, 1);
      }          
}

static void edt_forward_cmd(void)
{
    Edt_Direction = 1;
}

static void edt_back_cmd(void)
{
    Edt_Direction = 0;
}

static void edt_page_cmd(void)
{
    if (Edt_Direction == 0)
	{
	    page_up_cmd();
	}
    else
	{
	    page_down_cmd();
	}
}

static void edt_line_cmd(void)
{
    if (Edt_Direction == 0)
	{
	    previous_line_cmd();
	}
    else
	{
	    next_line_cmd();
	}
}

static void edt_find_cmd(void)
{
    if (Edt_Direction == 0)
	{
	    search_back_cmd();
	}
    else
	{
	    search_cmd();
	}
}

static void edt_find_next_cmd(void)
{
    if (Edt_Direction == 0)
	{
	    Most_Search_Dir = -1;
	}
    else
	{
	    Most_Search_Dir = 1;
	}
    find_next_cmd();
}


#ifdef USE_SLANG
#define A_KEY(s, f)  {s, (int (*)(void)) f}
SLKeymap_Function_Type Most_Functions [] =
{
   A_KEY("edit", most_edit_cmd),
   A_KEY("suspend", sys_spawn_cmd),
   A_KEY("next_file", most_next_file),
   A_KEY("toggle_options", most_toggle_options),
   A_KEY("toggle_lock", most_toggle_lock),
   A_KEY("extended_key", most_extended_key_cmd),
   A_KEY("toggle_case", most_toggle_case),
   A_KEY("delete_file", most_delete_file_cmd),
   A_KEY("bob", top_of_buffer_cmd),
   A_KEY("delete_window", del_window_cmd),
   A_KEY("digit_arg", digit_arg_cmd),
   A_KEY("down", next_line_cmd),
   A_KEY("edt_backward", edt_back_cmd),
   A_KEY("edt_find", edt_find_cmd),
   A_KEY("edt_find_next", edt_find_next_cmd),
   A_KEY("edt_forward", edt_forward_cmd),
   A_KEY("edt_line", edt_line_cmd),
   A_KEY("edt_page", edt_page_cmd),
   A_KEY("eob", end_of_buffer_cmd),
   A_KEY("exit", most_exit_most),
   A_KEY("find_file", find_file_cmd),
   A_KEY("find_next", find_next_cmd),
   A_KEY("goto_line", goto_line_cmd),
   A_KEY("goto_mark", goto_mark_cmd),
   A_KEY("goto_percent", goto_percent_cmd),
   A_KEY("help", help_cmd),
   A_KEY("one_window", one_window_cmd),
   A_KEY("other_window", other_window_cmd),
   A_KEY("page_down", page_down_cmd ),
   A_KEY("page_left", page_left_cmd),
   A_KEY("page_right", page_right_cmd ),
   A_KEY("page_up", page_up_cmd ),
   A_KEY("column_left", column_left_cmd ),
   A_KEY("column_right", column_right_cmd ),
   A_KEY("redraw", redraw_cmd),
   A_KEY("search_backward", search_back_cmd),
   A_KEY("search_forward", search_cmd),
   A_KEY("set_mark", set_mark_cmd),
   A_KEY("show_time", time_cmd),
   A_KEY("toggle_width", toggle_width_cmd),
   A_KEY("two_windows", two_window_cmd),
   A_KEY("up", previous_line_cmd),
   {(char *) NULL, NULL}
};

SLKeyMap_List_Type *Most_Keymap;

#endif

void most_init_keymaps (void)
{
#ifdef USE_SLANG
   char  *err = "Unable to create keymaps!";
   char esc[3], gold[5], dig[2];
   int i;
   
   if (NULL == (Most_Keymap = SLang_create_keymap ("Most", NULL)))
     most_exit_error (err);
   
   Most_Keymap->functions = Most_Functions;   
   
   esc[0] = 27; esc[2] = 0;
   gold[0] = 27; gold[1] = 'O'; gold[2] = 'P'; gold[4] = 0;
   dig[1] = 0;
   
   for (i = '0'; i <= '9'; i++)
     {
	dig[0] = (char) i;
	esc[1] = (char) i;
	gold[3] = (char) i;
	SLang_define_key1 (dig, (VOID *) digit_arg_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
	SLang_define_key1 (esc, (VOID *) digit_arg_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
	SLang_define_key1 (gold, (VOID *) digit_arg_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
     }
   
   dig[0] = '-'; esc[1] = '-'; gold[3] = '-';
   SLang_define_key1 (dig, (VOID *) digit_arg_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 (esc, (VOID *) digit_arg_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 (gold, (VOID *) digit_arg_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   
   SLang_define_key1 (" ", (VOID *) page_down_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("$", (VOID *) sys_spawn_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("%", (VOID *) goto_percent_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 (",", (VOID *) goto_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("/", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 (":", (VOID *) most_extended_key_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("<", (VOID *) page_left_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 (">", (VOID *) page_right_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("?", (VOID *) search_back_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("B", (VOID *) end_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("D", (VOID *) page_down_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("E", (VOID *) most_edit_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("F", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("G", (VOID *) goto_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("H", (VOID *) help_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("J", (VOID *) goto_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("L", (VOID *) most_toggle_lock, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("M", (VOID *) set_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("N", (VOID *) find_next_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("O", (VOID *) other_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("Q", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("R", (VOID *) redraw_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("S", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("T", (VOID *) top_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("U", (VOID *) page_up_cmd , SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("V", (VOID *) next_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("W", (VOID *) toggle_width_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("X", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033$", (VOID *) sys_spawn_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033<", (VOID *) top_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033>", (VOID *) end_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OA", (VOID *) previous_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OB", (VOID *) next_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OC", (VOID *) page_right_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OD", (VOID *) page_left_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OPE", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OPO", (VOID *) one_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OPQ", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OPS", (VOID *) sys_spawn_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OPV", (VOID *) del_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OPX", (VOID *) two_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033OR", (VOID *) edt_find_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033On", (VOID *) goto_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033Ot", (VOID *) end_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033Ou", (VOID *) top_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033[A", (VOID *) other_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033[B", (VOID *) other_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033[C", (VOID *) page_right_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OP\033[D", (VOID *) page_left_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OQ", (VOID *) help_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033OR", (VOID *) edt_find_next_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033On", (VOID *) set_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033Op", (VOID *) edt_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033Ot", (VOID *) edt_forward_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033Ou", (VOID *) edt_back_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033Ox", (VOID *) edt_page_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033V", (VOID *) page_up_cmd , SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[1~", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[2~", (VOID *) goto_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[28~", (VOID *) help_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[4~", (VOID *) set_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[5~", (VOID *) page_up_cmd , SLKEY_F_INTRINSIC, Most_Keymap);   
   SLang_define_key1 ("\033[6~", (VOID *) page_down_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[A", (VOID *) previous_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[B", (VOID *) next_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[C", (VOID *) page_right_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\033[D", (VOID *) page_left_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("\t", (VOID *) page_right_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^", (VOID *) previous_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^?", (VOID *) page_up_cmd , SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^@", (VOID *) set_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^D", (VOID *) page_down_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^F", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^H", (VOID *) help_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^KE", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^KG", (VOID *) find_file_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^K^B", (VOID *) set_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^K^J", (VOID *) goto_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^K^M", (VOID *) goto_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^L", (VOID *) redraw_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^M", (VOID *) next_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^N", (VOID *) next_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^P", (VOID *) previous_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^R", (VOID *) redraw_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^T", (VOID *) time_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^U", (VOID *) page_up_cmd , SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^V", (VOID *) page_down_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^W0", (VOID *) del_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^W1", (VOID *) one_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^W2", (VOID *) two_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^WO", (VOID *) other_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^X0", (VOID *) del_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^X1", (VOID *) one_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^X2", (VOID *) two_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^XO", (VOID *) other_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^X^C", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^X^F", (VOID *) find_file_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("^Z", (VOID *) sys_spawn_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("b", (VOID *) end_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("d", (VOID *) page_down_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("e", (VOID *) most_edit_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("f", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("g", (VOID *) goto_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("j", (VOID *) goto_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("l", (VOID *) most_toggle_lock, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("m", (VOID *) set_mark_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("n", (VOID *) find_next_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("o", (VOID *) other_window_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("q", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("r", (VOID *) redraw_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("s", (VOID *) search_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("t", (VOID *) top_of_buffer_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("v", (VOID *) next_line_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("w", (VOID *) toggle_width_cmd, SLKEY_F_INTRINSIC, Most_Keymap);
   SLang_define_key1 ("x", (VOID *) most_exit_most, SLKEY_F_INTRINSIC, Most_Keymap);
   if (SLang_Error) most_exit_error (err);
   
   most_load_user_keymaps ();
#endif
}

#ifndef USE_SLANG
#include "mostmap.c"
#endif


#ifdef USE_SLANG
static void sldo_key (void)
{
   SLang_Key_Type *key;
   
   key = SLang_do_key (Most_Keymap, (int (*)(void)) SLang_getkey);
   SLang_Error = SLKeyBoard_Quit = 0;
   Last_Char = SLang_Last_Key_Char;
   
   if ((key == NULL) || (key->f == NULL) || (key->type != SLKEY_F_INTRINSIC))
     {
	most_beep ();
     }
   else (((void (*)(void))(key->f)) ());
}
#endif

static void digit_arg_cmd(void)
{
   char num[15], ch;
   int j = 0;
   static int digits;
    
   num[j++] = Last_Char;
   ch = most_getkey();
   while ((ch >= '0') && (ch <= '9'))
     {
	num[j++] = ch;
	ch = most_getkey();
     }
    
   if (((j == 1) && (Last_Char != '-')) || (j > 1))
     {
	num[j] = '\0';
	sscanf(num,"%d",&digits);
	Most_Digit_Arg = &digits;
     }
   Last_Char = ch;
#ifdef USE_SLANG
   SLang_ungetkey (ch);
   sldo_key ();
#else
   (*root_map[ (int) ch ])();
#endif
}


void most_execute_key (void)
{
   int r,c;
   
   if (Most_Want_Exit) return;
   most_check_minibuffer();
   c = Most_Curs_Col - Most_Column + 1;
   r = Most_Curs_Row;
   if (Most_Mini_Buf[0] != '\0') most_put_message();
   if (r < 1) r = 1;
   else if (r > (Most_Win->bot - Most_Win->top + 1))
     r = Most_Win->bot - Most_Win->top + 1;
   if (c > Most_Screen_Width) c = Most_Screen_Width;
   else if (c < 1) c = 1;
   most_goto_rc(r + Most_Win->top - 1,c);
   fflush(stdout);
   Most_Digit_Arg = (int *) NULL;
   
#ifdef USE_SLANG
   sldo_key ();
#else
   Last_Char = most_getkey();
   (*root_map[ (int) Last_Char ]) ();
#endif
}
