/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * static char copyright[] = "Copyright (c) 1990 Regents of the University of California.\nAll rights reserved.\n";
 * static char SccsId[] = "@(#)@(#)popper.h	2.2  2.2 4/2/91";
 *
 */

/*  LINTLIBRARY */

/* 
 *  Header file for the POP programs
 */

#ifdef POPSCO
# include <sys/syslog.h>
#else
# include <syslog.h>
#endif
#include <sys/socket.h>
#include "version.h"

#ifdef		HAVE_PARAM_H
#include <sys/param.h>
# if (defined(BSD) && (BSD >= 199103))
#  define	HAVE_UNISTD_H
#  define	HAVE_VSPRINTF
#  define	BIND43
# endif
#endif

#define NULLCP          ((char *) 0)
#define SPACE           32
#define TAB             9
#define TRUE            1
#define FALSE           0
#define NEWLINE         '\n'

#define MAXUSERNAMELEN  65
#define MAXDROPLEN      64
#define MAXLINELEN      1024
#define MAXMSGLINELEN   MAXLINELEN
#define MAXCMDLEN       4
#define MAXPARMCOUNT    5
#define MAXPARMLEN      10
#define ALLOC_MSGS  20

#ifndef OSF1
# define POP_FACILITY    LOG_LOCAL0
#else
# define POP_FACILITY    LOG_MAIL
#endif
#define POP_PRIORITY    LOG_NOTICE
#define POP_DEBUG       LOG_DEBUG
#define POP_LOGOPTS     LOG_PID

#ifdef POPSCO
# define L_SET  0
# define L_XTND 2
#endif

			/* ^A */
#define	MMDF_SEP_CHAR	'\001'

/* For performance reasons large sites should change the pop tempdrop
 * location to another directory other than the mail spool location.
 * The more files referenced in a directory, the slower the access is
 */

#if defined(OSF1)
# define POP_MAILDIR     "/var/spool/mail"
# define POP_DROP        POP_MAILDIR "/.%s.pop"
# define POP_TMPDROP     POP_MAILDIR "/tmpXXXXXX"
# define POP_TMPXMIT     POP_MAILDIR "/xmitXXXXXX"
# define MAIL_COMMAND	 "/usr/sbin/sendmail"
# define OSDONE
#endif

#if defined(SYSV) && !defined(POPSCO) && !defined(LINUX)
# define POP_MAILDIR     "/usr/mail"
# define POP_DROP        "/usr/mail/.%s.pop"
# define POP_TMPDROP     "/usr/mail/tmpXXXXXX"
# if defined(AUX) || defined(AIX)
#  define POP_TMPXMIT     "/tmp/xmitXXXXXX"
# else
#  define POP_TMPXMIT     "/usr/mail/xmitXXXXXX"
# endif
# define MAIL_COMMAND	 "/usr/lib/sendmail"
# define OSDONE
#endif

#if (defined(BSD) && ((BSD) >= 199103))
# define POP_MAILDIR     "/var/mail"
# define POP_DROP        "/var/mail/.%s.pop"
# define POP_TMPDROP     "/var/mail/tmpXXXXXX"
# define POP_TMPXMIT     "/var/mail/xmitXXXXXX"
# define MAIL_COMMAND	 "/usr/sbin/sendmail"
# define OSDONE
#endif

#if defined(LINUX)
# define POP_MAILDIR     "/var/spool/mail"
# define POP_DROP        "/var/spool/pop/%s.pop"
# define POP_TMPDROP     "/var/spool/pop/tmpXXXXXX"
# define POP_TMPXMIT     "/var/spool/pop/xmitXXXXXX"
# define MAIL_COMMAND	 "/usr/sbin/sendmail"
# define OSDONE
#endif

#ifndef OSDONE
# ifdef HOMEDIRMAIL
#  define POP_MAILDIR     "%s/.mail"
# else
#  define POP_MAILDIR     "/usr/spool/mail"
# endif
# define POP_DROP        "/usr/spool/mail/.%s.pop"
# define POP_TMPDROP     "/usr/spool/mail/tmpXXXXXX"
# define POP_TMPXMIT     "/usr/spool/mail/xmitXXXXXX"
# define MAIL_COMMAND	 "/usr/lib/sendmail"
#endif

/* Define his path to default the bulletin dir.
 *	-DBULLDIR= "/usr/mail/bulletins"
 * in the make file works well or you can define BULLDIR before the #ifdef.
 */

#ifndef BULLDIR
#define BULLDIR		NULL
#endif

			/* Defines the minimum number of bulletins a new user
			   receives */
#define NEWBULLCNT	1

/* POP_TMPSIZE needs to be big enough to hold the string
 * defined by POP_TMPDROP.  POP_DROP and POP_TMPDROP
 * must be in the same filesystem.
 */
#define POP_TMPSIZE	256
#define POP_OK          "+OK"
#define POP_ERR         "-ERR"
#define POP_SUCCESS     1
#define POP_FAILURE     0
#define POP_TERMINATE   '.'
#define POP_TIMEOUT	120	/* timeout connection after this many secs */

		    /* UID's <= this value are not allowed to access email */
#define BLOCK_UID	10

#define	MSGUIDL		"X-UIDL:"
#define	CONTLEN		"Content-Length:"
#define	CONTSIZ		15
#ifdef SOLARIS2
#define	CONTENT_LENGTH	TRUE
#else
#define	CONTENT_LENGTH	FALSE
#endif

		/* False means that the popper will not recognize lines
		   that start with "From " as valid message separators. */
#define	SIMPLE_FROM	FALSE

		/* Set these to the types your OS returns if they are not
		   already typedefed for you */
#define OFF_T		off_t
#define PID_T		pid_t
#define UID_T		uid_t
#define GID_T		gid_t

extern int              errno;

#if !(defined(BSD) && (BSD >= 199306))
extern int              sys_nerr;
extern char         *   sys_errlist[];
#ifndef __linux__
extern char         *   sys_siglist[];
#endif
#endif

extern int		pop_timeout;

extern int		hangup;

#define pop_command         pop_parm[0]     /*  POP command is first token */
#define pop_subcommand      pop_parm[1]     /*  POP XTND subcommand is the 
                                                second token */

typedef enum {                              /*  POP processing states */
    auth1,                                  /*  Authorization: waiting for 
                                                USER command */
    auth2,                                  /*  Authorization: waiting for 
                                                PASS command */
    trans,                                  /*  Transaction */
    update,                                 /*  Update:  session ended, 
                                                process maildrop changes */
    halt,                                   /*  (Halt):  stop processing 
                                                and exit */
    error                                   /*  (Error): something really 
                                                bad happened */
} state;

typedef struct {                                /*  State information for 
                                                    each POP command */
    state       ValidCurrentState;              /*  The operating state of 
                                                    the command */
    char   *    command;                        /*  The POP command */
    int         min_parms;                      /*  Minimum number of parms 
                                                    for the command */
    int         max_parms;                      /*  Maximum number of parms 
                                                    for the command */
    int         (*function) ();                 /*  The function that process 
                                                    the command */
    state       result[2];                      /*  The resulting state after 
                                                    command processing */
#define success_state   result[0]               /*  State when a command 
                                                    succeeds */
} state_table;

typedef struct {                                /*  Table of extensions */
    char   *    subcommand;                     /*  The POP XTND subcommand */
    int         min_parms;                      /*  Minimum number of parms for
                                                    the subcommand */
    int         max_parms;                      /*  Maximum number of parms for
                                                    the subcommand */
    int         (*function) ();                 /*  The function that processes 
                                                    the subcommand */
} xtnd_table;

typedef struct {                                /*  Message information */
    int         number;                         /*  Message number relative to 
                                                    the beginning of list */
    long        length;                         /*  Length of message in 
                                                    bytes */
    int         lines;                          /*  Number of (null-terminated)
						    lines in the message */
    int         body_lines;			/*  Number of (null-terminated)
   						    lines in the body */
    OFF_T       offset;                         /*  Offset from beginning of 
                                                    file */
    int         del_flag;                       /*  Flag indicating if message 
                                                    is marked for deletion */
    int         retr_flag;                      /*  Flag indicating if message 
                                                    was retrieved */
    char	*uidl_str;			/*  Cache of the UIDL str for
						    faster access */
} MsgInfoList;

typedef struct  {                               /*  POP parameter block */
    int                 debug;                  /*  Debugging requested */
    int                 stats;                  /*  Stats requested */
    int			uidl_seq;		/*  Unique Ident sequence */
    int			popdrop_dirty;		/*  New status or UIDL? */
    time_t	        session_time;		/*  Used for UIDL IDs */
    char            *   myname;                 /*  The name of this POP 
                                                    daemon program */
    char            *   myhost;                 /*  The name of our host 
                                                    computer */
    char            *   client;                 /*  Canonical name of client 
                                                    computer */
    char            *   ipaddr;                 /*  Dotted-notation format of 
                                                    client IP address */
    unsigned short      ipport;                 /*  Client port for privileged 
                                                    operations */
    char                user[MAXUSERNAMELEN];   /*  Name of the POP user */
    state               CurrentState;           /*  The current POP operational                                                     state */
    MsgInfoList     *   mlp;                    /*  Message information list */
    int                 msg_count;              /*  Number of messages in 
                                                    the maildrop */
    int                 msgs_deleted;           /*  Number of messages flagged 
                                                    for deletion */
    int                 last_msg;               /*  Last message touched by 
                                                    the user */
    long                bytes_deleted;          /*  Number of maildrop bytes 
                                                    flagged for deletion */
    char                drop_name[MAXDROPLEN];  /*  The name of the user's 
                                                    maildrop */
    char                temp_drop[MAXDROPLEN];  /*  The name of the user's 
                                                    temporary maildrop */
    long                drop_size;              /*  Size of the maildrop in
                                                    bytes */
    FILE            *   drop;                   /*  (Temporary) mail drop */
    FILE            *   input;                  /*  Input TCP/IP communication 
                                                    stream */
    FILE            *   output;                 /*  Output TCP/IP communication                                                     stream */
    FILE            *   trace;                  /*  Debugging trace file */
    char            *   pop_parm[MAXPARMCOUNT]; /*  Parse POP parameter list */
    int                 parm_count;             /*  Number of parameters in 
                                                    parsed list */
    char            *   bulldir;                /*  Bulletin directory */
    char	    *	mmdf_separator;		/*  string between messages */
} POP;

#ifdef KERBEROS
#ifdef SOLARIS2
#include <kerberos/krb.h>
#else
#include <krb.h>
#endif
extern AUTH_DAT kdata;
#endif /* KERBEROS */

#if defined(AUTHFILE) || defined(NONAUTHFILE)
extern int  checkauthfile();
#endif

extern int  pop_dele();
extern int  pop_last();
extern int  pop_list();
extern int  pop_pass();
extern int  pop_rpop();
extern int  pop_quit();
extern int  pop_rset();
extern int  pop_send();
extern int  pop_stat();
extern int  pop_updt();
extern int  pop_user();
extern int  pop_xtnd();
extern int  pop_xmit();
extern int  pop_xlst();
extern int  pop_uidl();
extern int  isfromline();

