// -*- C++ -*-
/*
 *  Combox: A combination of two objects (a button and a browser) is
 *          encapsulated to get a combobox-like object. All XForms 
 *          functions are hidden.         
 * 
 *  GNU Copyleft (C) 1996 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 *                        and the LyX Team.
 * 
 *  Dependencies:  Only XForms, but created to be used with LyX.
 * 
 */ 

/* Change log:
 *  
 *  2/06/1996,   Alejandro Aguilar Sierra 
 *    Created and tested.
 *  
 *  4/06/1996,   Alejandro Aguilar Sierra 
 *    Added droplist mode (a button with a black down arrow at right)
 *    and support for middle and right buttons, as XForms choice object.
 * 
 */ 

#include "combox.h"


Combox::Combox(combox_type t): type(t)
{
   browser = button = NULL;
   callback = NULL;
   _pre = NULL;
   _post = NULL;
   sel = 0;
}


Combox::~Combox()
{
   remove();
}


void Combox::clear()
{
   if (browser) fl_clear_browser(browser);   
   sel = 0;
}


void Combox::remove()
{
   if (button) {
      fl_delete_object(button);
      fl_free_object(button); 
   }
   
   if (label && label!=button) {
      fl_delete_object(label);
      fl_free_object(label); 
   }
   
   if (browser) {
      fl_delete_object(browser);
      fl_free_object(browser);
   }
   button = NULL; 
   browser = NULL; 
   label = NULL;
   sel = 0;
}


void Combox::addline(const char* text)
{
   if (browser) {
      fl_add_browser_line(browser, text);
      
      // By default the first item is selected
      if (!sel) {
	 sel = 1;
	 if (type == FL_COMBOX_INPUT)
		 fl_set_input(label, text);
	 else
		 fl_set_object_label(label, text); 
      }
   }
}


void Combox::select(int i)
{
   if (browser && button) {
      if (i>0 && i<=fl_get_browser_maxline(browser)) sel = i; 
      fl_deactivate_object(button);
      
      if (type == FL_COMBOX_INPUT)
	      fl_set_input(label, fl_get_browser_line(browser, sel));
      else
	      fl_set_object_label(label, fl_get_browser_line(browser, sel)); 

      fl_set_browser_topline(browser, sel);
      fl_select_browser_line(browser, sel);
      fl_activate_object(button); 
   }
   // let's try this first. I got a loop since calback used select.
   //if (callback) 
   //  callback(sel);    
}


void Combox::add(int x, int y, int w, int hmin, int hmax)
{  
	FL_OBJECT *obj;

	switch(type) {
	case FL_COMBOX_DROPLIST:
	{
		button = obj = fl_add_button(FL_NORMAL_BUTTON,
					     x+w-22,y,22,hmin,"@2->");
		fl_set_object_callback(obj,combo_cb,0);
		label = obj = fl_add_text(FL_NORMAL_TEXT,x,y,w-22,hmin,"");
		fl_set_object_boxtype(obj,FL_DOWN_BOX);
		fl_set_object_color(obj,FL_MCOL,FL_BLACK);
		fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
		break;
	}
	case FL_COMBOX_NORMAL:
	{
		button = obj = fl_add_button(FL_NORMAL_BUTTON,x,y,w,hmin,"");
		fl_set_object_boxtype(obj,FL_DOWN_BOX);
		fl_set_object_callback(obj,combo_cb,0);
		fl_set_object_color(obj,FL_MCOL,FL_BLACK);
		label = button;
		break;
	}
	case FL_COMBOX_INPUT:
	{
		button = obj = fl_add_button(FL_NORMAL_BUTTON,
					     x+w-22,y,22,hmin,"@2->");
		fl_set_object_callback(obj,combo_cb,0);
		label = obj = fl_add_input(FL_NORMAL_INPUT,x,y,w-22,hmin,"");
		fl_set_object_boxtype(obj,FL_DOWN_BOX);
		fl_set_object_return(obj, FL_RETURN_END_CHANGED);
		fl_set_object_callback(obj,input_cb,0);
		//fl_set_object_color(obj,FL_MCOL,FL_BLACK);
		//fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
		break;
	}
	} // end of switch
   
   browser = obj = fl_add_browser(FL_HOLD_BROWSER,x,y+hmin+4,
				  w+20,hmax-hmin-12,"");
     fl_set_object_boxtype(obj,FL_UP_BOX);
     fl_set_object_callback(obj,combo_cb,2);

   label->u_vdata = (void*)this;
   button->u_vdata = (void*)this;
   browser->u_vdata = (void*)this;
   fl_hide_object(browser);
}


void Combox::Show()
{
	if (_pre) _pre();
	
	if (browser && button) {
		//fl_deactivate_object(button);
		button->argument = 3;
		fl_show_object(browser);
		fl_redraw_object(browser);
	}
}


void Combox::Hide(int who)
{  
	if (browser && button && !who) {
		sel = fl_get_browser(browser);

		if (type == FL_COMBOX_INPUT)
			fl_set_input(label, fl_get_browser_line(browser, sel));
		else
			fl_set_object_label(label,
					    fl_get_browser_line(browser, sel));
	}
	if (browser && button) {
		fl_hide_object(browser);
		button->argument = 0;
	}
   
	if (_post) _post();
		
	if (callback) callback(sel);
}


void Combox::input_cb(FL_OBJECT *ob, long)
{
	Combox *combo = (Combox*)ob->u_vdata;

	const char *text = fl_get_input(ob);
	fprintf(stderr, "input: %s\n", text);

	combo->addto(text);
	
}


void Combox::combo_cb(FL_OBJECT *ob, long data)
{
	Combox *combo = (Combox*)ob->u_vdata;
	fprintf(stderr, "Running combo_cb\n");
   switch (data) {
    case 0:
    {  
       int i = combo->get();
       switch (fl_get_button_numb(ob)) {
	case 1: combo->Show(); break;
	case 2: combo->select(--i); break;
	case 3: combo->select(++i); break;
       }
       break;
    }
    case 2:
      combo->Hide();
      break;
   case 3:
	   combo->Hide(2);
	   break;
   }
}


#ifdef TESTCOMBO
typedef struct {
	FL_FORM *test;
	FL_OBJECT *bar;
	void *vdata;
	long ldata;
} FD_test;

//Combox combo(FL_COMBOX_DROPLIST);
Combox combo(FL_COMBOX_INPUT);

FD_test *fd_test;
   
FD_test *create_form_test(void)
{
   FL_OBJECT *obj;
   FD_test *fdui = (FD_test *) fl_calloc(1, sizeof(*fdui));
   
   fdui->test = fl_bgn_form(FL_NO_BOX, 320, 190);
   obj = fl_add_box(FL_UP_BOX,0,0,320,190,"");
   obj = fl_add_box(FL_DOWN_BOX,10,50,300,110,"");
   obj = fl_add_button(FL_NORMAL_BUTTON,250,10,50,30,"Done");
   combo.add(10,15,120,25,135); 
   fl_end_form();

  return fdui;
}

void combo_cb(int i)
{
   fprintf(stderr, "selected %d:%s\n", i, combo.getline());
}

int main(int argc, char *argv[])
{
	//int n1;
   
   // Same defaults as in lyx 
   FL_IOPT cntl;
   cntl.buttonFontSize = FL_MEDIUM_SIZE;
   cntl.browserFontSize = FL_MEDIUM_SIZE;
   cntl.labelFontSize = FL_MEDIUM_SIZE;
   cntl.choiceFontSize = FL_MEDIUM_SIZE;
   cntl.inputFontSize = FL_MEDIUM_SIZE;
   cntl.borderWidth = -2;
   fl_set_defaults(FL_PDButtonFontSize, &cntl);  
   fl_set_defaults(FL_PDBrowserFontSize, &cntl);  
   fl_set_defaults(FL_PDLabelFontSize, &cntl);  
   fl_set_defaults(FL_PDChoiceFontSize, &cntl);  
   fl_set_defaults(FL_PDInputFontSize, &cntl);  
   fl_set_defaults(FL_PDBorderWidth, &cntl);
   fl_initialize(&argc, argv, 0, 0, 0);
   
   fd_test = create_form_test();

   /* fill-in form initialization code */
   combo.addline("Title");
   combo.addline("Author");
   combo.addline("Date");
   combo.addline("Abstract");
   combo.addline("Chapter");
   combo.addline("Section");
   combo.addline("Subsection");
   combo.addline("List");
   combo.addline("Description");
   combo.addline("Verse");
   combo.addline("Verbatim");
   combo.setcallback(combo_cb);
//   combo.select(4);
   
   /* show the first form */
   fl_show_form(fd_test->test,FL_PLACE_CENTER,FL_FULLBORDER,"test");
   fl_do_forms();
   return 0;
}

#endif

