#!/usr/local/bin/perl

#
# Handle arguments
#

if (@ARGV != 1) {
    print "usage: make-encoding.pl encfile\n";
    exit(1);
}

$file = shift(@ARGV);

open(FP, $file) || die "couldn't open input file `$file': $!\n";

# Find the start of the table.
$found = 0;
while (<FP>) {
    if ($_ =~ /^-+$/) {
	$found = 1;
	last;
    }
}

if (!$found) {
    die "file `$file' is not a valid encoding file: couldn't find table\n";
}

$file =~ s/\.txt$//g;
$file =~ s/.*\///g;

# Print header.

print <<"EOF";
/* 
 * AFM $file encoding.
 * Copyright (c) 1995 Markku Rossi.
 *
 * Author: Markku Rossi <mtr\@iki.fi>
 */

/*
 * This file is part of the AFM library.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

EOF

print "#include \"afmint.h\"\n\n";

printf("AFMEncodingTable afm_%s_encoding[] =\n{\n",
       $file);

# Process file.
while (<FP>) {
    @cols = split;
    if ($_ =~ /^\s*$/) {
	next;
    } elsif ($_ =~ /non-printable/) {
	print "  {@cols[1], AFM_ENC_NONE},\n";
    } elsif (@cols[2] =~ /-/) {
	print "  {@cols[1], AFM_ENC_NON_EXISTENT},\n";
    } else {
	$name = @cols[2];
	$name =~ s/\///g;
	print "  {@cols[1], \"$name\"},\n";
    }
}

# Print trailer.

printf("  {-1,   NULL},\n};\n");

close(FP);


