#!/bin/sh

tstfile=genscript-test-output.ps

echo Testing genscript...

if test -f $tstfile; then
  rm $tstfile
fi

echo "* printing all files in current directory"
./genscript -v -G2r -p$tstfile *
ls -l $tstfile
rm $tstfile

echo "* printing all files in current directory with Times-Roman7 font"
./genscript -v -G2r -p$tstfile -fTimes-Roman7 *
ls -l $tstfile
rm $tstfile

echo "* encodings"

for i in ibmpc latin1 mac vms; do
  echo "  $i"
  ./genscript -G2r --quiet --encoding=$i -p$tstfile $i.txt
done

rm $tstfile
echo Tests completed.
