//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  The code which finds the serial port status was based upon
//  Jeff Tranter's (Jeff_Tranter@Mitel.COM) statserial prgram.
//
//  This file may be distributed under terms of the GPL
//

#include "serialmeter.h"
#include "xosview.h"
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>


SerialMeter::SerialMeter( XOSView *parent, int x, int y, int width, int height,
			  const char *device,
			  const char *title, const char *legend, int dolegends,
			  int dousedlegends )
: BitMeter( parent, x, y, width, height, title, 
	    "FG/TxD/RxD/RTS/CTS/DSR/GND/DCD/DTR/RI", 10, 
	    dolegends, dousedlegends ) {
  parent_->addResource( "serialOnColor", NULL, "red" );
  parent_->addResource( "serialOffColor", NULL, "blue" );

  priority_ = 5;

  if ( (fd_ = open( device, O_RDONLY )) == -1 ){
    cerr <<"can not open : " <<device <<endl;
    ok_ = 0;
    return;
  }

  ok_ = 1;
}

SerialMeter::~SerialMeter( void ){
}

void SerialMeter::checkevent( void ){
  if ( fd_ == -1 )
    return;

  getserial();
  BitMeter::checkevent();
}

void SerialMeter::checkResources( void ){
  BitMeter::checkResources();
  onColor_  = parent_->allocColor( parent_->getResource( "serialOnColor" ) );
  offColor_ = parent_->allocColor( parent_->getResource( "serialOffColor" ) );
}

void SerialMeter::getserial( void ){
  if ( !ok_ )
    return;

  unsigned int arg;
  if ( ioctl( fd_, TIOCMGET, &arg ) != 0 ){
    cerr <<"SerialMeter::getserial() : TIOCMGET failed : "
         <<strerror( errno ) <<endl;
    ok_ = 0;
    return;
  }

                                   // FG   Frame Ground
                                   // TxD  Transmit Data
                                   // RxD  Receive  Data
  bits_[3] = !!(arg & TIOCM_RTS);  // RTS  Request to Send
  bits_[4] = !!(arg & TIOCM_CTS);  // CTS  Clear to Send
  bits_[5] = !!(arg & TIOCM_DSR);  // DSR  Data Set Ready
                                   // GND  Signal Ground
  bits_[7] = !!(arg & TIOCM_CAR);  // DCD  Data Carrier Detect
  bits_[8] = !!(arg & TIOCM_DTR);  // DTR  Data Terminal Ready
  bits_[9] = !!(arg & TIOCM_RNG);  // RI   Ring Indicator
}
