/* 
   PXKFont.m

   NSFont for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: February 1997
   A completely rewritten version of the original source by Scott Christley.
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <Foundation/NSDictionary.h>
#include <Foundation/NSPathUtilities.h>

#include <AppKit/NSFontManager.h>
#include <gnustep/xdps/PXKFont.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include "fonts.h"
#include "AFMFileFontInfo.h"

/* The `be_font_reserved' ivar is a pointer to a AFMFileFontInfo instance that
   describes the font. */

/* TODO: support for composite fonts */

@implementation PXKFont

/* Class variables */

/* A dictionary of font name -> file name which contains the AFM description of
   the font. */
static NSMutableDictionary* knownFonts = nil;

+ (void)initialize
{
  static BOOL initialized = NO;

  if (!initialized) {
    initialized = YES;
    knownFonts = [NSMutableDictionary new];
  }
}

+ (void)makeKnownFontName:(NSString*)name fileName:(NSString*)fileName
{
  [knownFonts setObject:fileName forKey:name];
}

+ (NSFont*)fontWithName:(NSString*)name 
		 matrix:(const float*)fontMatrix
{
  PXKFont* font;
  NSString* afmFileName;

  /* If the font name is not known by the system return nil */
  if (!(afmFileName = [knownFonts objectForKey:name]))
    return nil;

  [super fontWithName:name matrix:fontMatrix];
  font = [[self new] autorelease];

  /* First set the attributes we already know */
  font->fontName = [name copy];
  memcpy (font->matrix, fontMatrix, sizeof (font->matrix));

  /* Request the font info from the AFMFileFontInfo class. */
  font->be_font_reserved
      = [[AFMFileFontInfo fontInfoForFont:font afmFilename:afmFileName]
	      retain];

  return font;
}

- (void)dealloc
{
  [((AFMFileFontInfo*)be_font_reserved) release];
  [super dealloc];
}

- (void)set
{
  PSWSetFont ([fontName cString], matrix);
}

- (NSString*)afmFileContents
{
  NSString* afmFileName = [knownFonts objectForKey:fontName];
  NSString* afmFileContent = [NSString stringWithContentsOfFile:afmFileName];

  return afmFileContent;
}

/* Computing font metrics attributes */
- (float)widthOfString:(NSString*)string
{
  return [((AFMFileFontInfo*)be_font_reserved) widthOfString:string];
}

/* The screen and printer fonts are the same since DGS does not support yet
   screen fonts. */
- (NSFont*)printerFont			{ return self; }
- (NSFont*)screenFont			{ return self; }

- (NSString*)familyName
{
  return [((AFMFileFontInfo*)be_font_reserved) familyName];
}

- (NSRect)boundingRectForFont
{
  return [((AFMFileFontInfo*)be_font_reserved) boundingRectForFont];
}

- (NSString *)encodingScheme
{
  return [((AFMFileFontInfo*)be_font_reserved) encodingScheme];
}

- (BOOL)isFixedPitch
{
  return [((AFMFileFontInfo*)be_font_reserved) isFixedPitch];
}

- (BOOL)isBaseFont
{
  return [((AFMFileFontInfo*)be_font_reserved) isBaseFont];
}

- (NSDictionary*)afmDictionary
{
  return [((AFMFileFontInfo*)be_font_reserved) afmDictionary];
}

- (float)ascender
{
  return [((AFMFileFontInfo*)be_font_reserved) ascender];
}

- (float)descender
{
  return [((AFMFileFontInfo*)be_font_reserved) descender];
}

- (float)capHeight
{
  return [((AFMFileFontInfo*)be_font_reserved) capHeight];
}

- (float)italicAngle
{
  return [((AFMFileFontInfo*)be_font_reserved) italicAngle];
}

- (NSSize)maximumAdvancement
{
  return [((AFMFileFontInfo*)be_font_reserved) maximumAdvancement];
}

- (NSSize)minimumAdvancement
{
  return [((AFMFileFontInfo*)be_font_reserved) minimumAdvancement];
}

- (float)underlinePosition
{
  return [((AFMFileFontInfo*)be_font_reserved) underlinePosition];
}

- (float)underlineThickness
{
  return [((AFMFileFontInfo*)be_font_reserved) underlineThickness];
}

- (float)xHeight
{
  return [((AFMFileFontInfo*)be_font_reserved) xHeight];
}

- (float*)widths
{
  return [((AFMFileFontInfo*)be_font_reserved) widths];
}

- (NSSize)advancementForGlyph:(NSGlyph)glyph
{
  return [((AFMFileFontInfo*)be_font_reserved) advancementForGlyph:glyph];
}

- (NSRect)boundingRectForGlyph:(NSGlyph)glyph
{
  return [((AFMFileFontInfo*)be_font_reserved) boundingRectForGlyph:glyph];
}

- (BOOL)glyphIsEncoded:(NSGlyph)glyph
{
  return [((AFMFileFontInfo*)be_font_reserved) glyphIsEncoded:glyph];
}

- (NSGlyph)glyphWithName:(NSString*)glyphName
{
  return [((AFMFileFontInfo*)be_font_reserved) glyphWithName:glyphName];
}

- (NSPoint)positionOfGlyph:(NSGlyph)curGlyph
	   precededByGlyph:(NSGlyph)prevGlyph
		 isNominal:(BOOL *)nominal
{
  return [((AFMFileFontInfo*)be_font_reserved) positionOfGlyph:curGlyph
					   precededByGlyph:prevGlyph
					   isNominal:nominal];
}

@end
