// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
// GifDecoder by Markus Demleitner
// msdemlei@relay.ari.uni-heidelberg.de
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _GifDecoder_h_
#define _GifDecoder_h_

#include "ImageDecoder.h"
#include <qimage.h>

class LZWDecoder{
    QImage *im;
    QImage *tmask;
    int *pttab;       //table of indices into chtab, so that pttab[chtab[a]]
                      //points to the successor of a in a given string.
    unsigned char *chtab;   //table with chars to be output
    unsigned char *outstr;  //The output string
    unsigned int clrcd;     //LZW clear code
    unsigned int endcd;     //LZW end code
    int currentCodeSize;
    unsigned int mask;      //1<<(currentCodeSize+1)-1, only here for 
                            //performance reasons
    unsigned char *curlin;  //pointer to current scanline
    unsigned char *nextPix; //pointer to next pixel drawn
    unsigned int fifo;      //Fifo pipe int LZWdecode
    int inFifo;	            //valid bits in fifo
    unsigned int firstFree; //First entry free in pttab and chtab
    unsigned int maxCode;   //Maximal code allowed by current code size
    unsigned int ocd;       //Last LZW character handled
    bool deferredClear;     //TRUE if I am handling a deferred clear
    bool afterClear;        //TRUE until the char following a clear code has
                            //been read
    int LZWsize;            //GIF LZW minimum code size
    int intlIncrement;      //Increment for interlaced images
    int tInd;               //Index of transparent color
    unsigned char pixbuf;   //
    int inpixbuf;           //- Used for setting pixels in masks.
    unsigned char *pixpt;   ///
    int width;
    int height;
    int curScanline;        //scanline currently processed

    void mktab(void);
    int LZWdecomp ( unsigned int c );
    void setPixelsni ( unsigned char *c, unsigned char *base );
    void setPixelsi ( unsigned char *c, unsigned char *base );
    void setPixelsnit ( unsigned char *c, unsigned char *base );
    void setPixelsit ( unsigned char *c, unsigned char *base );
//    void (LZWDecoder::*setPixels)( unsigned char *c, unsigned char *base );
    enum SetPixelFunc {
        GIF_SetPixelSNI,
        GIF_SetPixelSI,
        GIF_SetPixelSNIT,
        GIF_SetPixelSIT
    };
    SetPixelFunc setPixelFunc;

public:
    bool done;              //TRUE as soon as end code is received
    int LZWdecode ( unsigned char c );
    LZWDecoder ( unsigned char c, QImage* pic, QImage* mask, int transColor, 
                 bool IntlFlag=FALSE );
    int getCurScanline()
        { return curScanline; }
    ~LZWDecoder ( );
};

class GifDecoder : public ImageDecoder {
    Q_OBJECT
    QImage *im;
    QImage *mask;

    // Info from GIF header
    int height;
    int width; //Global
    int ihei;
    int iwid;    //Local
    int bitsPerPixel;
    int numColors;
    int numLocalColors;
    bool isGif89;
    bool hasGlobalColorTable;
    bool hasLocalColorTable;
    bool interlaced;
    int transColor;   //-1 if no transparent color
                      //I'm ignoring background and aspect ratio
		      //Can't do (or don't want to) much about it anyway.

    // Data
    unsigned char header[13];  //This is Gif header plus logical screen desc.
    unsigned char buf[1024];   //buffer for data that we process in full

    int headerBytes;  //Bytes of header already read.
    int bufPtr;       //Next byte of buffer to be filled
    int bytesLeft;    //When reading block data, this is the number of
                      //bytes yet to be read for this block

    LZWDecoder *curDecoder;

    // state flags
    bool lookingForNextBlock;
    bool readingColorTable;
    bool readingImageDescriptor;
    bool readingImageData;
    bool readingExtension;
    bool readingImageBlock;
    bool skippingDataBlocks;
    bool gotOneIm;     //For now, I'm just reading one image, if I'm done
                       //with this, gotOneIm get TRUE
    bool canDraw;
    int drawnToLine;   //That many scanlines are already on screen
    int lastUpdate;    //Time of last redraw

    void getGifColorTable( unsigned char *table, int numColors );
    void readGCE( void );
    void renderProgressive( void );
    
public:
    int broken;       //nonzero if something is wrong with the GIF

    GifDecoder( Renderer* renderer );

    ~GifDecoder();
public slots:
    void data( const char* bytes, int length );

    void endOfData();
};

#endif
