// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _RadioRenderer_h_
#define _RadioRenderer_h_

#include "FormObjectRenderer.h"

class QRadioButton;

//: The RadioRenderer class provides a QRadioButton that can be embedded in an HTML form.
class RadioRenderer : public FormObjectRenderer {
    Q_OBJECT
    QRadioButton* _radio;
    QString       _value;
    bool          _checked;
public:
    RadioRenderer( bool           checked,
                   const QString* value,
                   Canvas*        canvas,
                   int            clipWidth=0,
                   QObject*       parent=0,
                   const char*    name=0 );

    //. A value is returned only if the radio button has a name, and it is
    //. checked.  Otherwise, an empty string is returned.
    QString value();

    void reset();

    //. Do nothing.
    bool redraw();
public slots:
    //. Do nothing.
    void endOfData();
};

#endif
