/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: dir_tree.cpp,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include "dir_tree.h"


/*---------------------------------------------------------------------------*/
DirTreeWidget::DirTreeWidget(QWidget         *parent,
                             const char      *name,
                             UpDownScroll    *ud,
                             LeftRightScroll *lr,
                             VFSL_Class      *temp_class,
                             OptionsPopup    *temp_pr,
                             OperationPopup  *temp_op):QWidget(parent, name)
{
	tree_top = NULL;
	tree_node = NULL;

	scroll_ud = ud;
	scroll_lr = lr;

	y_off_left = 0;

	dnd_active = FALSE;
	//multiple_select = FALSE;
	select_active = 0;
	has_focus = FALSE;
	x_new = 0;
	y_new = 0;
	x_start = 0;
	y_start = 0;
	x_old = 0;
	y_old = 0;

	still_dragging_on = FALSE;

	mouse_popup =temp_pr;
	op_popup    =temp_op;

	io_class = temp_class;
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::remove_focus (void)
{
 has_focus=FALSE;
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::set_focus (void)
{
 has_focus=TRUE;
}
/*---------------------------------------------------------------------------*/
char DirTreeWidget::get_focus (void)
{
 return (has_focus);
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::drag_and_drop(bool yes_or_no)
{
 dnd_active=yes_or_no;
}
/*---------------------------------------------------------------------------*/
int DirTreeWidget::count_selection()
{
 int i=0;

 FileTreeNode *temp_list=tree_top;

 while (temp_list!=NULL)
 {
  if (temp_list->node_selected ()==TRUE)
    i++;

  temp_list=temp_list->get_next();
 }

 return (i);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *DirTreeWidget::get_target()
{
  return (tree_top->get_target ());
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::update_pane()
{
	update();
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::update_uds(int new_val)
{
	y_off_left = new_val;
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::deselect()
{
	if (tree_top != NULL)
		tree_top->deselect_nodes();
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::redraw()
{
	update();
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::set_root_node(FileTreeNode * new_root)
{
	tree_top = new_root;
	tree_node = new_root;
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::selection_removed()
{
   select_active = 1;
   repaint (FALSE);
   select_active = 0;

   deselect();
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::compose_directory(FileTreeNode * selected_node)
{
	compose_dir[0] = 0;

	selected_node->set_target(TRUE);
	tree_top->compose_directory();
	selected_node->set_target(FALSE);
}
/*---------------------------------------------------------------------------*/
/*  WARNING, this function should get a locking mechanism !!!!               */
/*---------------------------------------------------------------------------*/
void DirTreeWidget::reread_dir (const char *target_dir)
{
 printf ("target_dir '%s' has changed\n", target_dir);

 /*
 FileTreeNode *the_parent;
 FileTreeNode *target_node;

 //target_node=search_for_dir (target_dir);

    the_parent=target_node->get_parent ();

    the_parent->remove_tree ();
 
    io_class->vfsl_read_directory (the_parent,
                                   (char *) target_dir); 

    set_root_node (the_parent->get_tree_top ());

    update ();
 */
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::change_dir(FileTreeNode * selected_node)
{
	FileTreeNode *parent = selected_node->get_parent();

	if (!selected_node || !parent)
		return;

	if (selected_node->has_access() == TRUE)
	{
		if (!tree_top)
			return;

		if (
			   (parent->get_tree_top() == NULL) &&
			   (parent->is_expanded() == FALSE)
				)
		{
			setCursor(waitCursor);
			parent->set_target(TRUE);

			compose_dir[0] = 0;
			tree_top->compose_directory();
			io_class->vfsl_read_directory(parent,
										  compose_dir);

			parent->set_target(FALSE);
			setCursor(arrowCursor);

		}

		if (selected_node->get_tree_top() == NULL)
		{
			setCursor(waitCursor);
			selected_node->set_target(TRUE);

			compose_dir[0] = 0;
			tree_top->compose_directory();
			io_class->vfsl_read_directory(selected_node,
										  compose_dir);

			selected_node->set_target(FALSE);
			setCursor(arrowCursor);
		}

		parent->set_expanded(TRUE);
		selected_node->set_expanded(TRUE);
	}

	deselect();

	emit    set_dir_info(compose_dir);
	emit    update_root_node(selected_node->get_tree_top());

	selected_node->select_node(TRUE);

	update();
}
/*---------------------------------------------------------------------------*/
FileTreeNode *DirTreeWidget::search_for_dir(FileTreeNode * a_node, const char *to_dir)
{
	while (a_node != NULL)
	{
		if (strcmp(a_node->get_node_name(), to_dir) == 0)
			return (a_node);

		a_node = a_node->get_next();
	}

	return (a_node);
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::goto_dir(const char *to_dir)
{
	FileTreeNode *a_node = tree_top;	// always start at the top

	int     i,
	        current_start;

	// printf ("Jumping to Directory: [%s]\n",to_dir);

	if (to_dir[0] != '/')		// must start in the root dir
		return;

	if (to_dir[1] == 0)			// in other words we want to go to the root dir

	{
		change_dir(a_node);		// might be wrong, but I don't care right now :)
		return;
	}

	i = 1;
	current_start = 1;			// skip the first '/'

	do
	{
		if ((to_dir[i] == '/') || (to_dir[i] == 0))
		{
			i++;

			tempo_stringo[0] = 0;
			strncpy(tempo_stringo, to_dir + current_start, i - current_start);
			tempo_stringo[i - current_start - 1] = 0;

			// printf ("To: [%s]\n",tempo_stringo);

			if (a_node->get_tree_top() == NULL)		// it seems that directory has not been read

			{

				if (a_node->has_access() == FALSE)
					return;

				if (a_node->get_next() != NULL)
				{
					// printf ("Wait!\n");
				}

				setCursor(waitCursor);
				a_node->set_target(TRUE);

				compose_dir[0] = 0;
				tree_top->compose_directory();
				io_class->vfsl_read_directory(a_node,
											  compose_dir);

				a_node->set_target(FALSE);
				setCursor(arrowCursor);
			}

			a_node = search_for_dir(a_node->get_tree_top(), tempo_stringo);
			if (a_node == NULL)
				return;
			else
				change_dir(a_node);

			current_start = i;
		}

		i++;
	}
	while (to_dir[i] != 0);		// search the string sequentially

	if (to_dir[i - 1] != '/')
	{
		tempo_stringo[0] = 0;
		strncpy(tempo_stringo, to_dir + current_start, i - current_start);
		tempo_stringo[i - current_start] = 0;

		// printf ("To: [%s]\n",tempo_stringo);

		if (a_node->get_tree_top() == NULL)		// it seems that directory has not been read

		{
			if (a_node->has_access() == FALSE)
				return;

			if (a_node->get_next() != NULL)
				printf("Wait!\n");

			setCursor(waitCursor);
			a_node->set_target(TRUE);

			compose_dir[0] = 0;
			tree_top->compose_directory();
			io_class->vfsl_read_directory(a_node,
										  compose_dir);

			a_node->set_target(FALSE);
			setCursor(arrowCursor);
		}

		a_node = search_for_dir(a_node->get_tree_top(), tempo_stringo);
		if (a_node == NULL)
			return;
		else
			change_dir(a_node);
	}
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::un_mount(const char * /*  mount_point unused */ )
{
	// in other words refresh

}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::paintEvent(QPaintEvent * e)
{
	int     y_diff;

	// >------- if we have a tree then let it draw itself

	if (multiple_select == FALSE)
	{
		if (select_active == 0)
		{
			if ((tree_top != NULL) && (isVisible()))
			{
				y_wide = 0;
				x_offset = X_BORDER;	// reset all icons 

				y_offset = Y_BORDER;	// reset all icons 

				if (dnd_active==TRUE)
					tree_top->show_node_tree_target (e, this, height());
				else
					tree_top->show_node_tree(e, this, height(), get_focus ());

				y_wide += Y_BORDER;

				if (y_wide > height())
				{
					y_diff = y_wide - height();
					scroll_ud->setRange(0, y_diff);
					scroll_ud->setSteps(NODE_HEIGHT, height());
				}
				else
					scroll_ud->setRange(0, 0);
			}
		}
		else
		{
			if ((tree_top != NULL) && (isVisible()))
			{
				nr_x_direction = 0;
				x_offset = X_BORDER;	// reset all icons 

				y_offset = Y_BORDER;	// reset all icons 

				if (select_active == 1)
					tree_top->show_node_tree_selected(e, this, height(), TRUE);

				if (select_active == 2)
				{
					tree_top->show_node_tree_selected(e, this, height(), FALSE);
					select_active = 0;
				}
			}
		}
	}
	else
	{
		QPainter paint;

		paint.begin(this);
		paint.setPen(white);
		paint.setBrush(NoBrush);

		paint.setRasterOp(XorROP);

		draw_rect (&paint,
                   x_start,y_start, 
                   x_old  ,y_old);

		draw_rect (&paint,
                   x_start,y_start, 
                   x_new  ,y_new);

		paint.setRasterOp(CopyROP);

		paint.end();
	}
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::resizeEvent(QResizeEvent*)
{

}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::select (QMouseEvent * e)
{
	FileTreeNode *selected_node = NULL;

	// >------ first see if we selected something
	if (tree_top != NULL)
	{
		nr_x_temp = 0;
		selected_node = tree_top->find_selected_node_tree(e->pos().x(),
														  e->pos().y());

		if (selected_node != NULL)
		{
            emit take_focus ();

            select_active = 1;
            repaint (FALSE);

			if (selected_node->has_access() == TRUE)
			{

				compose_directory(selected_node);

				if (
					   (selected_node->get_tree_top() == NULL) &&
					   (selected_node->is_expanded() == FALSE)
                   )
				{
					setCursor(waitCursor);

					io_class->vfsl_read_directory(selected_node,	// node of attachement
												   compose_dir);	// path to node or url/host

					setCursor(arrowCursor);
				}

                emit update_root_node(selected_node->get_tree_top());
                emit set_dir_info(compose_dir);
                emit remove_selection (); 

                deselect(); // this could be 2x deselect in reality
			}
            else
            {
              deselect ();
              emit update_root_node (NULL); // risky business
            }   
  
            selected_node->select_node(TRUE);

            select_active = 2;
            repaint (FALSE);
		}
	}
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::mouseReleaseEvent(QMouseEvent * e)
{
 // FileTreeNode *selected_node = NULL; UNUSED!

 if (e->button() == LeftButton)
 {
   if (mouse_popup!=NULL)
     mouse_popup->hide();
 }

 if (dnd_active==TRUE)
   emit dragging_and_dropping(FALSE);

 if (multiple_select==TRUE)
 {
   x_new=x_start;
   y_new=y_start;
   repaint (FALSE);
 } 

 multiple_select = FALSE;
}
/*---------------------------------------------------------------------------*/
void    DirTreeWidget::mousePressEvent(QMouseEvent * e)
{
 FileTreeNode *selected_node;

 if (mouse_locked == FALSE)
 {
    mouse_locked = TRUE;


    // first calculate some important variables


    // QPoint  new_coors = mapToGlobal(e->pos()); UNUSED!

    nr_x_temp = 0;
    x_offset  = X_BORDER;
    y_offset  = Y_BORDER;


    if (tree_top!=NULL)
      tree_top->recalc_tree();

   
    // check the right mouse button
 

    if ((e->button() == RightButton) && (tree_top != NULL))
    {
        selected_node = NULL;
        selected_node = tree_top->find_selected_node_tree (e->pos().x(),
                                                           e->pos().y());

        if (selected_node != NULL)
        {
            if (selected_node->node_selected() == TRUE)
            {
                compose_directory(selected_node);
 
                if (mouse_popup!=NULL) 
                {
                   // not now please :)
 
                   /*
                   if (count_selection()>1)
                     mouse_popup->set_multiple_entries (TRUE); 
                   else
                     mouse_popup->set_multiple_entries (FALSE);
 
                   mouse_popup->move (new_coors.x(),
                                      new_coors.y());
                   mouse_popup->assign_node(selected_node,
                                            compose_dir);
                   mouse_popup->show();
                   */ 
                }
            }         	
        }
    }


    // now check the left mouse button


    if ((e->button() == LeftButton) && (tree_top != NULL))
    {
       selected_node = NULL;
       selected_node = tree_top->find_selected_node_tree(e->pos().x(),
                                                         e->pos().y());

       if (selected_node==NULL)
       {                 
            nr_x_temp = 0;
            selected_node=tree_top->find_expanding_node(this,
                                                        e->pos().x(),
                                                        e->pos().y());                 
            if (selected_node==NULL) 
            {  
                 x_old = x_start = x_new = e->pos().x();
                 y_old = y_start = y_new = e->pos().y();
  
                 select_active = 1;
                 repaint (FALSE);

                 deselect();

                 select_active = 2;
                 repaint (FALSE);

                 multiple_select = TRUE;
            } 
            else
            {
                 emit take_focus ();
 
                 // always create a directory path for a notify message
                 compose_directory(selected_node);

                 // read directory if it wasn't already read
                 if (
                     (selected_node->get_tree_top() == NULL) &&
                     (selected_node->is_expanded() == FALSE)
                    )
                 {
                   setCursor(waitCursor);
	  				
                   io_class->vfsl_read_directory (selected_node,
                                                  compose_dir);

                   setCursor(arrowCursor);
                 }
 
                 // set expanded flag in node
  
                 if (selected_node->is_expanded() == FALSE)
                 {
                   selected_node->set_expanded(TRUE);
                   //emit check_that_dir (compose_dir); 
                 }
                 else
                   selected_node->set_expanded(FALSE);

                 // update widget 

                 update();
            }
       }
       else
       {
          if ((selected_node->node_selected()==TRUE) && (has_focus==TRUE))
             emit dragging_and_dropping(TRUE);
          else
             select(e);
       }
    }

    mouse_locked = FALSE;
  }
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::mouseDoubleClickEvent(QMouseEvent * e)
{
 FileTreeNode *selected_node = NULL;

 if (mouse_locked == FALSE)
 {
		mouse_locked = TRUE;

        emit take_focus ();

		// QPoint  new_coors = mapToGlobal(e->pos()); UNUSED!!!!

		if ((e->button() == LeftButton) && (tree_top != NULL))
		{
			nr_x_temp = 0;
			x_offset = X_BORDER;
			y_offset = Y_BORDER;

			tree_top->recalc_tree();
            selected_node =NULL;  
			selected_node = tree_top->find_selected_node_tree(e->pos().x(),
															  e->pos().y());

			if (selected_node != NULL)
			{
				if (selected_node->get_expandable() == TRUE)
				{
					if (
						   (selected_node->get_tree_top() == NULL) &&
						   (selected_node->is_expanded() == FALSE)
							)
					{
						setCursor(waitCursor);
						selected_node->set_target(TRUE);

						compose_dir[0] = 0;
						tree_top->compose_directory();
						io_class->vfsl_read_directory(selected_node,
													  compose_dir);

						selected_node->set_target(FALSE);
						setCursor(arrowCursor);
					}

					if (selected_node->is_expanded() == FALSE)
						selected_node->set_expanded(TRUE);
					else
						selected_node->set_expanded(FALSE);

					emit    update_root_node(selected_node->get_tree_top ());

					update();
				}
			}
		}

		mouse_locked    = FALSE;
		multiple_select = FALSE; // this one is not necessary but who cares
  }
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::mouseMoveEvent(QMouseEvent * /* e unused */ )
{
	/*
   int x1,
	   y1,
	   x2,
	   y2; UNUSED*/

	if (mouse_locked == FALSE)
	{
		mouse_locked = TRUE;
       
		// >-------- only valid if we are dragging and dropping
        /*

		if ((multiple_select == TRUE) && (still_dragging_on == FALSE))
		{
			still_dragging_on = TRUE;

			x_new = e->pos().x();
			y_new = e->pos().y();

			repaint(FALSE);

			if (tree_top != NULL)
			{
				multiple_select = FALSE;
				select_active = 1;
				repaint (FALSE);

				// >-------------- make sure x2 is larger than x1

				if (x_new < x_start)
				{
					x1 = x_new;
					x2 = x_start;
				}
				else
				{
					x1 = x_start;
					x2 = x_new;
				}

				// >-------------- make sure y2 is larger than y1

				if (y_new < y_start)
				{
					y1 = y_new;
					y2 = y_start;
				}
				else
				{
					y1 = y_start;
					y2 = y_new;
				}

				// >-------------- now see if we can stir some nodes

				tree_top->find_selected_node_tree_m(x1, y1, x2, y2);

				select_active = 2;
				repaint (FALSE);
				multiple_select = TRUE;
			}

			x_old = x_new;
			y_old = y_new;

			still_dragging_on = FALSE;
		}

        */

		mouse_locked = FALSE;
	}
}
/*---------------------------------------------------------------------------*/
/* This function (SLOT) is a workaround an effect in Qt wich disables any    */
/* for widgets outside the current focused Widget                            */
/*---------------------------------------------------------------------------*/
void DirTreeWidget::remoteMoveEvent (QPoint &position)
{
 QPoint new_pos;
 FileTreeNode *selected_node = NULL;

 if ((dnd_active==TRUE) && (tree_top!=NULL))
 {
   new_pos=mapFromGlobal (position); 

   nr_x_temp = 0;
   x_offset = X_BORDER;
   y_offset = Y_BORDER;

   tree_top->recalc_tree();

   // search for affected files
   selected_node = tree_top->find_selected_node_tree(new_pos.x(),
                                                     new_pos.y());   
   if (selected_node!=NULL)
   {
    tree_top->remove_targets ();

    //printf ("Found : [%s]\n",selected_node->get_node_name ());
    selected_node->set_op_target (TRUE);
 
	repaint (FALSE);   
   }
 }   
}
/*---------------------------------------------------------------------------*/
void DirTreeWidget::closeEvent(QCloseEvent*)
{
 // delete(this); // ??? hmmm
}
/*---------------------------------------------------------------------------*/





/*---------------------------------------------------------------------------*/
DirTreeContainer::DirTreeContainer (QWidget        *parent,
                                    const char     *name,
                                    VFSL_Class     *temp_class,
                                    OptionsPopup   *temp_op,
                                    OperationPopup *temp_pr):QFrame(parent,
                                                                    name)
{

	setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

	fill_btn1 = new QPushButton(" ", this, "Dummy");

	scroll_ud = new UpDownScroll(this, &y_off_left);
	scroll_lr = new LeftRightScroll(this, &y_off_left);

	child_widget = new DirTreeWidget(this,
									 "dircontainer",
									 scroll_ud,
									 scroll_lr,
									 temp_class,
                                     temp_op,
                                     temp_pr);
	scroll_ud->set_parent(child_widget);
	scroll_lr->set_parent(child_widget);
}
/*---------------------------------------------------------------------------*/
DirTreeWidget *DirTreeContainer::get_child(void)
{
	return (child_widget);
}
/*---------------------------------------------------------------------------*/
void DirTreeContainer::resizeEvent(QResizeEvent * /* e unused */)
{
	child_widget->setGeometry(2,
							  2,
							  width() - 4 - 14,
							  height() - 4 - 14);

	fill_btn1->setGeometry(width() - 16,
						   height() - 16,
						   14, 14);

	scroll_ud->setGeometry(width() - 16, 2, 14, height() - 18);
	scroll_lr->setGeometry(2, height() - 16, width() - 18, 14);
}
/*---------------------------------------------------------------------------*/
