/////////////////// QProgressCtrl widget class //////////////////////
// 
// for making Win95-style progress bars, as well as options for
// blocked/solid bar style, vertical/horizontal alignment, 
// bar/background colors
// 
// Copyright (C) 1996 Tim D. Gilman
// This version of the class is the first release.  Please
// send comments/suggestions/bug reports to <tdgilman@best.com>
// 
// This class was written using Qt 1.0 (http://www.troll.no)
// 
// you may freely use this source code without permission for 
// non-commercial development.

#ifndef _PROGRESS_H
#define _PROGRESS_H

#include <qframe.h>
#include <qcolor.h>

typedef enum
{
	horizBar,
	vertBar
}
ProgressOrient;

typedef enum
{
	blockedBar,
	solidBar
}
ProgressStyle;

class   QProgressCtrl:public QFrame
{
	Q_OBJECT
		
	public:
	
	QProgressCtrl(QWidget * parent = 0,
				  ProgressStyle style = blockedBar,
				  const QColor & barColor = darkBlue,
				  const QColor & backColor = lightGray,
				  ProgressOrient orient = horizBar,
				  const char *name = 0);

	void    setRange(int nLower = 0, int nUpper = 100);
	int     setPos(int nPos);
	int     offsetPos(int nPos);
	int     setStep(int nStep = 10);
	int     stepIt();

	protected:

	void    resizeEvent(QResizeEvent *);

	private:
	
	void    paintEvent(QPaintEvent *);
	void    init();
	int     calcSolidBarLen(int nPos);
	int     calcBlockLen();
	int     calcNumBlocks(int nPos);
	void    paintSolidBar(int nOldLen, int nLen);
	void    paintBlockedBars(int nOldNumBlocks, int nNumBlocks);

	int     m_nLower,
	        m_nUpper,
	        m_nStep,
	        m_nPos,
	        m_nSolidLen,
	        m_nBlockWidth,
	        m_nNumBlocks;
	QColor *m_barColor;
	ProgressOrient m_orient;
	ProgressStyle m_style;

	private:
	
	QProgressCtrl(const QProgressCtrl &)
	{
	}
	
	QProgressCtrl &operator=(const QProgressCtrl&)
	{
		return *this;
	}
};

#endif	 // _PROGRESS_H
