#!	/bin/sh

# Install the kernel modules and modconf tool from this boot floppy onto
# the root filesystem. The commands used by this script are limited to
# the ones available on the root floppy.
set -e
umask 022

if [ ! -f install.sh ]; then
	echo "Error: Change directory to the floppy before running this script." 1>&2
	exit -1
fi
FLOPPY=`pwd`

if [ $# -gt 0 ]; then
	DDIR=$1
fi
(cd ${DDIR}/; zcat < ${FLOPPY}/modules.tgz|star)
mkdir -p ${DDIR}/usr/sbin 
cp ${FLOPPY}/modconf ${DDIR}/usr/sbin/ 
if [ -e ${FLOPPY}/pcmcia.tgz ]; then
	(cd ${DDIR}/; zcat < ${FLOPPY}/pcmcia.tgz |star)
fi
mkdir -p ${DDIR}/usr/lib/module_help
cp ${FLOPPY}/eval ${FLOPPY}/descr.gz ${DDIR}/usr/lib/module_help/

sync
exit 0
