#include "dinstall.h"
#include <newt.h>
#include <stdio.h>
#include "lang.h"

#define _WIDTH  (65)
#define _HEIGHT (18)

int configure_keyboard (void)
{
  int rs,option;
  char msg[]=MSG_SELECT_KEYBOARD_L;
  char title[]=MSG_SELECT_KEYBOARD;

#if #cpu (m68k)
  struct d_choices keymaps_ami[]={
    { "amiga-us",        "U.S. English (amiga)"      , 1},
    { "amiga-de",        "German (amiga)"            , 0}
  };
  int nchoices_ami=2;
  struct d_choices keymaps_ata[]={
    { "atari-us",        "U.S. English (atari)"      , 1},
    { "atari-de",        "German (atari)"            , 0},
    { "atari-se",        "Sweden (atari)"            , 0},
    { "atari-uk-falcon", "English for Atari Falcon"  , 0},
  };
  int nchoices_ata=4;
  struct d_choices keymaps_mac[]={
    { "mac-us-std",      "U.S. English (Mac, 82 keys)", 1},
    { "mac-us-ext",      "U.S. English (Mac, extended kbd)", 0}
  };
  int nchoices_mac=2;
  int nchoices;
#elif #cpu (sparc)
  struct d_choices keymaps[]={
    { "sunkeymap",       "U.S. English (QWERTY)"     , 1},
    { "sunt4-es",        "Spain (Type 4)"            , 0},
    { "sunt5-es",        "Spain (Type 5)"            , 0},
    { "sunt5-de-latin1", "Germany (Type 5)"          , 0},
    { "sunt5-fi-latin1", "Finland (Type 5)"          , 0},
    { "sunt5-fr-latin1", "France (Type 5)"           , 0},
    { "sunt5-ru",        "Russia (Type 5)"           , 0}
  };
  int nchoices=7;
#else
  struct d_choices keymaps[]={
    { "us",			"U.S. English (QWERTY)", 1},
    { "azerty",			"AZERTY", 0 },
    { "be-latin1",		"Belgium", 0 },
    { "bg",			"Bulgarian Cyrillic", 0 },
    { "cf",			"French Canadian", 0 },
    { "cz-lat2",		"Czech", 0 },
    { "de-latin1-nodeadkeys",	"Germany", 0 },
    { "dk-latin1",		"Danish", 0 },
    { "dvorak",			"Dvorak", 0 },
    { "es",			"Spain", 0 },
    { "fi-latin1",		"Finland", 0 },
    { "fr-latin1",		"France", 0 },
    { "gr",			"Greek", 0 },
    { "hebrew",			"Hebrew", 0 },
    { "hu",			"Hungary", 0 },
    { "is-latin1",		"Iceland", 0 },
    { "it",			"Italy", 0 },
    { "jp106",			"Japan", 0 },
    { "no-latin1",		"Norway", 0 },
    { "pl",			"Poland", 0 },
    { "ru",			"Russia", 0 },
    { "se-latin1",		"Sweden", 0 },
    { "slovene",		"Slovene", 0 },
    { "tr_f-latin5",		"Turkish F", 0 },
    { "uk",			"United Kingdom", 0 }
  };
  int nchoices=25;
#endif

    struct d_choices* choices;

#if #cpu (m68k)
    if (strcmp(Arch2, "Atari") == 0) {
	choices = keymaps_ata;
	nchoices = nchoices_ata;
    }
    else if (strcmp(Arch2, "Amiga") == 0) {
	choices = keymaps_ami;
	nchoices = nchoices_ami;
    }
    else if (strcmp(Arch2, "Macintosh") == 0) {
	choices = keymaps_mac;
	nchoices = nchoices_mac;
    }
    else
	return 255;
#else
    choices= keymaps;
#endif
    newtPushHelpLine(MSG_SELECT_KEYBOARD_KEY);
    rs=choice_box(msg,title,_HEIGHT,_WIDTH,choices,nchoices,&option);
    newtPopHelpLine();

    if(rs==DLG_OKAY)
      {
	FILE *kbdconf;
	if (NULL==(kbdconf=fopen("/tmp/kbdconf","w"))){
		problemBox(MSG_CANT_OPEN_KBDCONF,MSG_WRITE_ERROR);
		return 1;
	}
	fprintf(kbdconf,"%s",choices[option].tag);
        fclose(kbdconf);
	sprintf(prtbuf,
		"zcat < /etc/keymaps.tgz | /bin/tarcat %s.bmap | /bin/loadkmap",
		choices[option].tag);
	system(prtbuf);
      }
    else
      {
#ifdef _TESTING_
	printf("Configuration Cancelled\n");
#endif
	rs=255;
      }
  return rs;
}


#ifdef _TESTING_
void main()
{
#if #cpu (m68k)
    Arch2 = "Atari";
#endif
    newtInit();
    newtCls();

    /*    newtSetSuspendCallback(suspend); */
    newtDrawRootText(0, 0, "Newt test program");
    newtOpenWindow(7, 2, 65, 18, "Root Window");
    newtPushHelpLine(NULL);
    configure_keyboard();
    newtPopWindow();
    newtFinished();
}
#endif



