/* IluJava_GCClient.c */
/* Chris Jacobi, August 15, 1997 11:17 am PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluJava_GCClient.c,v 1.12 1997/08/15 21:07:07 jacobi Exp $ */
 
/*
 * C side for GCClient.java
 */
 
#include "IluJava_Includes.h"
#include "IluJava_Common.h"
#include "IluJava_JStubs.h"
#include "xerox_ilu_IluGCClient.h"


JAVAEXPORT(IluGCClient_nativeIsGcClientSet, Jboolean)
    struct Hxerox_ilu_IluGCClient * unused
    ENDJAVAEXPORT 
{
    long isSet = 0;
    if (ilu_IsGcClientSet()) isSet = 1; 
    return isSet;
}


JAVAEXPORT(IluGCClient_finishSpecialGCClass, void)
    struct Hxerox_ilu_IluGCClient * unused,
    struct Hxerox_ilu_IluClassRep * jh_iluClass
    ENDJAVAEXPORT 
{
    ilu_Class cClass = ilu_GetGcCallbackClass();
    PUT_IluClassRep_yIluClass(jh_iluClass, cClass);
    if (_ilujava_definitionsFlag>0) {
        ilu_DebugPrintf("$ GCClient: jh_iluClass=<%x>, cClass=<%x>\n", jh_iluClass, cClass);
    }
}


JAVAEXPORT(IluGCClient_setupSpecialGCObj, void)
    struct Hxerox_ilu_IluGCClient * unused,
    struct Hxerox_ilu_IluOInt * jh_oi
    ENDJAVAEXPORT 
{
    ilu_Object cGCObj = GET_IluOInt_yIluKernelObject(jh_oi);
    if (_ilujava_definitionsFlag>0) {
        ilu_DebugPrintf("$ GCClient: cGCObj =<%x>\n", cGCObj);
    }
    ilu_SetGcClient(cGCObj);
}

/* end */
