# Makefile for omniORB2 and omnithread Examples -- NT / Windows '95
#
# Type NMAKE CFG="HELP" for help.

CONFIG_MAKEFILE=.\CONFIG.win32

!INCLUDE "$(CONFIG_MAKEFILE)"


!IF "$(CFG)" == ""
CFG=ALL
!MESSAGE No configuration specified.  Defaulting to "ALL" (Making all configurations)
!ENDIF 

!IF "$(CFG)" != "echo"\
 && "$(CFG)" != "eg1" && "$(CFG)" != "eg2_impl"\
 && "$(CFG)" != "eg2_clt" && "$(CFG)" !=\
 "eg3_impl" && "$(CFG)" != "eg3_clt" && "$(CFG)"\
 != "thread" && "$(CFG)" != "diner" && "$(CFG)"\
 != "prio" && "$(CFG)" != "prodcons" && "$(CFG)"\
 != "thrspecdata" && "$(CFG)" != "ALL" && "$(CFG)" != "all"
!IF "$(CFG)" != "HELP"
!MESSAGE Invalid configuration "$(CFG)" specified.
!ENDIF
!MESSAGE You can specify a configuration when running NMAKE on this makefile
!MESSAGE by defining the macro CFG on the command line.  For example:
!MESSAGE 
!MESSAGE NMAKE /f "examples.mak" CFG="echo"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "echo" (examples using omniORB2)
!MESSAGE "thread" (examples using omnithread)
!MESSAGE
!MESSAGE "ALL" (default)  (Makes all of the above)
!MESSAGE 
!MESSAGE A build can be cleaned by specifying:
!MESSAGE
!MESSAGE NMAKE /f "examples.mak" CLEAN CFG="<configuration>"
!MESSAGE
!ERROR Please specify one of the above configurations.
!ENDIF 

!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE 
NULL=nul
!ENDIF 

#Location of top-level directory of tree containing example src files
SRCDIR = $(SRCDIR)\examples

#Location of top-level output directory

TOPOUT = $(BASEDIR)\examples


################################################################################
# Begin Project

!IF "$(CFG)" == "ALL" || "$(CFG)" == "all"

ALL: "$(TOPOUT)"
	$(MAKE) /F "examples.mak" CFG="echo"
	$(MAKE) /F "examples.mak" CFG="thread"

CLEAN:
	$(MAKE) /F "examples.mak" CLEAN CFG="echo"
	$(MAKE) /F "examples.mak" CLEAN CFG="thread"

"$(TOPOUT)":
	if not exist "$(TOPOUT)/$(NULL)" mkdir "$(TOPOUT)"


!ELSEIF  "$(CFG)" == "echo"


OUTDIR=$(TOPOUT)\echo
INTDIR=$(TOPOUT)\echo

ALL : "eg3_clt" "eg3_impl"\
 "eg2_clt" "eg2_impl" "eg1" 

CLEAN : 
	$(MAKE) /F "examples.mak" CLEAN CFG="eg1"
	$(MAKE) /F "examples.mak" CLEAN CFG="eg2_impl"
	$(MAKE) /F "examples.mak" CLEAN CFG="eg2_clt"
	$(MAKE) /F "examples.mak" CLEAN CFG="eg3_impl"
	$(MAKE) /F "examples.mak" CLEAN CFG="eg3_clt"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"


!ELSEIF  "$(CFG)" == "eg1"


OUTDIR=$(TOPOUT)\echo\eg1
INTDIR=$(TOPOUT)\echo\eg1

ALL : "$(OUTDIR)\eg1.exe"

CLEAN : 
	-@erase "$(INTDIR)\eg1.obj"
	-@erase "$(OUTDIR)\eg1.exe"
	-@erase "$(INTDIR)\echoSK.obj"
	-@erase  "$(SRCDIR)\echo\echoSK.cc"
	-@erase  "$(SRCDIR)\echo\echo.hh"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/eg1.exe" 
LINK32_OBJS= \
	"$(INTDIR)\echoSK.obj" "$(INTDIR)\eg1.obj" 

"$(OUTDIR)\eg1.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "eg2_impl"


OUTDIR=$(TOPOUT)\echo\eg2_impl
INTDIR=$(TOPOUT)\echo\eg2_impl

ALL : "$(OUTDIR)\eg2_impl.exe"

CLEAN : 
	-@erase "$(INTDIR)\eg2_impl.obj"
	-@erase "$(OUTDIR)\eg2_impl.exe"
	-@erase  "$(INTDIR)\echoSK.obj"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/eg2_impl.exe" 
LINK32_OBJS= \
	"$(INTDIR)\echoSK.obj" "$(INTDIR)\eg2_impl.obj"

"$(OUTDIR)\eg2_impl.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "eg2_clt"

OUTDIR=$(TOPOUT)\echo\eg2_clt
INTDIR=$(TOPOUT)\echo\eg2_clt

ALL : "$(OUTDIR)\eg2_clt.exe"

CLEAN : 
	-@erase "$(INTDIR)\eg2_clt.obj"
	-@erase "$(OUTDIR)\eg2_clt.exe"
	-@erase "$(INTDIR)\echoSK.obj"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/eg2_clt.exe" 
LINK32_OBJS= \
	"$(INTDIR)\echoSK.obj" "$(INTDIR)\eg2_clt.obj"

"$(OUTDIR)\eg2_clt.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "eg3_impl"

OUTDIR=$(TOPOUT)\echo\eg3_impl
INTDIR=$(TOPOUT)\echo\eg3_impl

ALL : "$(OUTDIR)\eg3_impl.exe"

CLEAN : 
	-@erase "$(INTDIR)\eg3_impl.obj"
	-@erase "$(OUTDIR)\eg3_impl.exe"
	-@erase "$(INTDIR)\echoSK.obj"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/eg3_impl.exe" 
LINK32_OBJS= \
	"$(INTDIR)\echoSK.obj" "$(INTDIR)\eg3_impl.obj"

"$(OUTDIR)\eg3_impl.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "eg3_clt"

OUTDIR=$(TOPOUT)\echo\eg3_clt
INTDIR=$(TOPOUT)\echo\eg3_clt

ALL : "$(OUTDIR)\eg3_clt.exe"

CLEAN : 
	-@erase "$(INTDIR)\eg3_clt.obj"
	-@erase "$(OUTDIR)\eg3_clt.exe"
	-@erase "$(INTDIR)\echoSK.obj"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/eg3_clt.exe" 
LINK32_OBJS= \
	"$(INTDIR)\echoSK.obj" "$(INTDIR)\eg3_clt.obj"

"$(OUTDIR)\eg3_clt.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<




!ELSEIF  "$(CFG)" == "thread"

OUTDIR=$(TOPOUT)\thread
INTDIR=$(TOPOUT)\thread

ALL : "thrspecdata" "prodcons"\
 "prio" "diner" 

CLEAN : 
	$(MAKE) /F "examples.mak" CLEAN CFG="diner"
	$(MAKE) /F "examples.mak" CLEAN CFG="prio"
	$(MAKE) /F "examples.mak" CLEAN CFG="prodcons"
	$(MAKE) /F "examples.mak" CLEAN CFG="thrspecdata"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"




!ELSEIF  "$(CFG)" == "diner"


OUTDIR=$(TOPOUT)\thread\diner
INTDIR=$(TOPOUT)\thread\diner

ALL : "$(OUTDIR)\diner.exe"

CLEAN : 
	-@erase "$(INTDIR)\diner.obj"
	-@erase "$(OUTDIR)\diner.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/diner.exe" 
LINK32_OBJS= \
	"$(INTDIR)\diner.obj"

"$(OUTDIR)\diner.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "prio"

OUTDIR=$(TOPOUT)\thread\prio
INTDIR=$(TOPOUT)\thread\prio

ALL : "$(OUTDIR)\prio.exe"

CLEAN : 
	-@erase "$(INTDIR)\prio.obj"
	-@erase "$(OUTDIR)\prio.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"


CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/prio.exe" 
LINK32_OBJS= \
	"$(INTDIR)\prio.obj"

"$(OUTDIR)\prio.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "prodcons"

OUTDIR=$(TOPOUT)\thread\prodcons
INTDIR=$(TOPOUT)\thread\prodcons

ALL : "$(OUTDIR)\prodcons.exe"

CLEAN : 
	-@erase "$(INTDIR)\prodcons.obj"
	-@erase "$(OUTDIR)\prodcons.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 

LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/prodcons.exe" 
LINK32_OBJS= \
	"$(INTDIR)\prodcons.obj"

"$(OUTDIR)\prodcons.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "thrspecdata"

OUTDIR=$(TOPOUT)\thread\thrspecdata
INTDIR=$(TOPOUT)\thread\thrspecdata

ALL : "$(OUTDIR)\thrspecdata.exe"

CLEAN : 
	-@erase "$(INTDIR)\thrspecdata.obj"
	-@erase "$(OUTDIR)\thrspecdata.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 


LINK32_FLAGS=kernel32.lib user32.lib omnithread_rt.lib omniORB2_rt.lib /nologo\
 /subsystem:console /pdb:none /machine:I386 /out:"$(OUTDIR)/thrspecdata.exe" 
LINK32_OBJS= \
	"$(INTDIR)\thrspecdata.obj"

"$(OUTDIR)\thrspecdata.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ENDIF 


CPP_OBJS=$(INTDIR)/

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $<  


################################################################################
# Begin Target

# Name "echo"
################################################################################
# Begin Project Dependency

# Project_Dep_Name "eg1"

!IF  "$(CFG)" == "echo"

"eg1" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="eg1" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "eg2_impl"

!IF  "$(CFG)" == "echo"

"eg2_impl" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="eg2_impl" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "eg2_clt"

!IF  "$(CFG)" == "echo"

"eg2_clt" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="eg2_clt" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "eg3_impl"

!IF  "$(CFG)" == "echo"

"eg3_impl" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="eg3_impl" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "eg3_clt"

!IF  "$(CFG)" == "echo"

"eg3_clt" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="eg3_clt" 

!ENDIF 

# End Project Dependency
# End Target
################################################################################
# Begin Target
# Name "echoSK.obj"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\echo\echoSK.cc

"$(SRCDIR)\echo\echoSK.cc": $(SRCDIR)\echo\echo.idl
	$(IDL)  -s SK.cc $(SRCDIR)\echo\echo.idl
	move echoSK.cc $(SRCDIR)\echo\echoSK.cc
	move echo.hh $(SRCDIR)\echo\echo.hh


"$(INTDIR)\echoSK.obj" : $(SOURCE) $(DEP_CPP_EG1_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "eg1"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\echo\eg1.cc
DEP_CPP_EG1_C=\
	"$(SRCDIR)\echo\echo_i.cc"\
	"$(SRCDIR)\echo\greeting.cc"\
	"$(SRCDIR)\echo\echo.hh"\
	

"$(INTDIR)\eg1.obj" : $(SOURCE) $(DEP_CPP_EG1_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "eg2_impl"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\echo\eg2_impl.cc
DEP_CPP_EG2_I=\
	{$(INCLUDE)}"\omnithread\nt.h"\
	"$(SRCDIR)\echo\echo_i.cc"\
	{$(INCLUDE)}"\omnithread.h"\
	"$(SRCDIR)\echo\echo.hh"\
	

"$(INTDIR)\eg2_impl.obj" : $(SOURCE) $(DEP_CPP_EG2_I) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "eg2_clt"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\echo\eg2_clt.cc
DEP_CPP_EG2_C=\
	"$(SRCDIR)\echo\greeting.cc"\
	"$(SRCDIR)\echo\echo.hh"\
	

"$(INTDIR)\eg2_clt.obj" : $(SOURCE) $(DEP_CPP_EG2_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "eg3_impl"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\echo\eg3_impl.cc
DEP_CPP_EG3_I=\
	{$(INCLUDE)}"\omnithread\nt.h"\
	"$(SRCDIR)\echo\echo_i.cc"\
	{$(INCLUDE)}"\omnithread.h"\
	"$(SRCDIR)\echo\echo.hh"\
	

"$(INTDIR)\eg3_impl.obj" : $(SOURCE) $(DEP_CPP_EG3_I) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "eg3_clt"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\echo\eg3_clt.cc
DEP_CPP_EG3_C=\
	"$(SRCDIR)\echo\greeting.cc"\

	
"$(INTDIR)\eg3_clt.obj" : $(SOURCE) $(DEP_CPP_EG3_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "thread"
################################################################################
# Begin Project Dependency

# Project_Dep_Name "diner"

!IF  "$(CFG)" == "thread"

"diner" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="diner" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "prio"

!IF  "$(CFG)" == "thread"

"prio" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="prio" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "prodcons"

!IF  "$(CFG)" == "thread"

"prodcons" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="prodcons" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "thrspecdata"

!IF  "$(CFG)" == "thread"

"thrspecdata" : 
   $(MAKE) /$(MAKEFLAGS) /F "examples.mak" CFG="thrspecdata" 

!ENDIF 

# End Project Dependency
# End Target
################################################################################
# Begin Target

# Name "diner"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\thread\diner.cc
DEP_CPP_DINER=\
	{$(INCLUDE)}"\omnithread\nt.h"\
	{$(INCLUDE)}"\omnithread.h"\

"$(INTDIR)\diner.obj" : $(SOURCE) $(DEP_CPP_DINER) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "prio"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\thread\prio.cc
DEP_CPP_PRIO_=\
	{$(INCLUDE)}"\omnithread\nt.h"\
	{$(INCLUDE)}"\omnithread.h"\
	
"$(INTDIR)\prio.obj" : $(SOURCE) $(DEP_CPP_PRIO_) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "prodcons"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\thread\prodcons.cc
DEP_CPP_PRODC=\
	{$(INCLUDE)}"\omnithread\nt.h"\
	{$(INCLUDE)}"\omnithread.h"\

"$(INTDIR)\prodcons.obj" : $(SOURCE) $(DEP_CPP_PRODC) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "thrspecdata"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\thread\thrspecdata.cc
DEP_CPP_THRSP=\
	{$(INCLUDE)}"\omnithread\nt.h"\
	{$(INCLUDE)}"\omnithread.h"\

"$(INTDIR)\thrspecdata.obj" : $(SOURCE) $(DEP_CPP_THRSP) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
# End Project
################################################################################
