#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/corelib/linkinfo.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.8
 | File mod date:    1997.11.29 23:10:38
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  corelib
 |
 | Purpose:          Provide scheme interface to C units (modules)
 `------------------------------------------------------------------------|#

(define-glue (c-module-list)
{
  obj lst = NIL_OBJ;
  struct module_descr **m;

  for (m=master_table; *m; m++) 
    {
      lst = cons( RAW_PTR_TO_OBJ(*m), lst );
    }
  REG0 = lst;
  RETURN1();
})

(define-glue (get-c-module-descr c_module)
{
  struct module_descr *m = (struct module_descr *)OBJ_TO_RAW_PTR(c_module);
  struct part_descr **p;
  obj lst = NIL_OBJ;

  for (p=m->parts; *p; p++)
    {
      lst = cons( RAW_PTR_TO_OBJ(*p), lst );
    }
  REG0 = make_string( m->name );
  REG1 = lst;
  REG2 = int2fx( m->num_roots );
  RETURN(3);
})

(define-glue (get-c-part-descr part_ptr)
{
  struct part_descr *p = (struct part_descr *)OBJ_TO_RAW_PTR(part_ptr);
  struct function_descr **f;
  obj lst = NIL_OBJ;

  for (f=p->functions; *f; f++)
    {
      lst = cons( RAW_PTR_TO_OBJ(*f), lst );
    }
  REG0 = make_string( p->name );
  REG1 = int2fx( p->tag );
  REG2 = lst;
  REG3 = RAW_PTR_TO_OBJ( p->in_module );
  RETURN(4);
})

(define-glue (get-c-function-descr fn_d)
{
  struct function_descr *f = (struct function_descr *)OBJ_TO_RAW_PTR(fn_d);
  jump_addr *m;
  obj lst = cons( JUMP_ADDR_TO_OBJ(f->monotones[0]), NIL_OBJ );
  obj prev;

  prev = lst;
  for (m=f->monotones+1; *m; m++)
    {
      obj cell = cons( JUMP_ADDR_TO_OBJ(*m), NIL_OBJ );
      gvec_write_fresh_ptr( prev, SLOT(1), cell );
      prev = cell;
    }
  REG0 = make_string( f->name );
  REG1 = lst;
  REG2 = RAW_PTR_TO_OBJ( f->in_part );
  RETURN(3);
})

(define-glue (find-linked-module name)
{
  struct module_descr *m;

  m = find_module( string_text(name) );
  REG0 = m ? RAW_PTR_TO_OBJ(m) : FALSE_OBJ;
  RETURN1();
})

(define-glue (find-part-in-linked-module module part)
{
  struct part_descr *p;

  p = find_part( (struct module_descr *)OBJ_TO_RAW_PTR(module), fx2int(part) );
  REG0 = p ? RAW_PTR_TO_OBJ(p) : FALSE_OBJ;
  RETURN1();
})

(define-glue (find-code-ptr-in-part part fn_num)
{
  struct function_descr *f;
  struct part_descr *p = (struct part_descr *)OBJ_TO_RAW_PTR(part);

  f = p->functions[ fx2int(fn_num) ];
  REG0 = RAW_PTR_TO_OBJ( f->monotones[0] );
  REG1 = RAW_PTR_TO_OBJ( f );
  RETURN(2);
})


(define-safe-glue (dl-open (path <raw-string>))
{
  void *ent;
  ent = dynamic_link_file(path);
  REG0 = ent ? (RAW_PTR_TO_OBJ(ent)) : FALSE_OBJ;
  RETURN1();
})

(define-safe-glue (dl-resolve ent (sym <raw-string>))
{
  void *ptr;
  ptr = resolve_link_symbol(OBJ_TO_RAW_PTR(ent),sym);
  REG0 = ptr ? (RAW_PTR_TO_OBJ(ptr)) : FALSE_OBJ;
  RETURN1();
})

(define-safe-glue (dl-done ent)
{
  done_resolving(OBJ_TO_RAW_PTR(ent));
  RETURN0();
})

(define-safe-glue (dl-call cfn)
{
 void *r, *(*fn)( void );

 fn = ((void *(*)(void))OBJ_TO_RAW_PTR(cfn));
 r = fn();
 REG0 = r ? (RAW_PTR_TO_OBJ(r)) : FALSE_OBJ;
 RETURN1();
})

(define-safe-glue (dl-install m)
{
  install_module( OBJ_TO_RAW_PTR(m) );
  RETURN0();
})

(define-safe-glue (dl-c-unit (path <raw-string>) (unit_name <raw-string>))
{
  if (!dynamic_link_c_unit( path, unit_name ))
    {
      scheme_error( "dynamic link of ~s:~s failed\n", 2, unit_name, raw_path );
    }
  RETURN0();
})
