#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/repl/load.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.8
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  repl
 |
 | Purpose:          Evaluate the contents of a file in an environment
 |------------------------------------------------------------------------|
 | Notes:
 |      In order to support script-mode, the scanner interprets `#!'
 |      as a to-end-of-line-comment like ';'
 `------------------------------------------------------------------------|#

(define (load-into envt . args)
  (for-each (lambda (f)
	      (load-1 f envt))
	    args))

(define (canonicalize-path path)
  (cond 
   ((string? path)
    path)
   ((symbol? path)
    (symbol->string path))
   ((and (list? path)
	 (every? (lambda (x) (or (symbol? x) (string? x))) path))
    (let loop ((a '()) (s path))
      (if (null? s)
	  (apply* (reverse a) string-append)
	  (if (null? a)
	      (loop (list (canonicalize-path (car s))) (cdr s))
	      (loop (cons (canonicalize-path (car s)) (cons "/" a)) 
		    (cdr s))))))
    (else
     (error "Illegal path form: ~s" path))))

(define load-hook 
  (lambda (filename)
    filename))

(define (set-load-hook! proc)
  (set! load-hook proc))

(define (locate-for-load path-form)
  (if (instance? path-form <file-name>)
      path-form
      (let* ((canon (canonicalize-path path-form))
	     (path (locate canon "scm")))
	(if path
	    path
	    (error "load: ~a not found" canon)))))

(define (load-1 path-form envt)
  (let ((path (locate-for-load path-form)))
    (within-directory
     (file-directory path)
     (lambda ()
       (fluid-let ((*source-point* (vector 'file path #f #f)))
	 (call-with-input-file
	     (pathname->os-path (load-hook path))
	   (lambda (port)
	     (if *compile-verbose*
		 (format #t ">> loading: ~a\n" path))
	     (let loop ((last '()))
	       (bind ((item line (read port)))
		 (if (eof-object? item)
		     (begin
		       (if *compile-verbose*
			   (format #t "<< done loading: ~a\n" path))
		       (list->values last))
		     (begin
		       (set! *source-point* (vector 'file path line item))
		       (loop (values->list (eval-in-envt item envt))))))))))))))

