/**********************************************************************/
/* LANG_C.C : Mise en couleur pour langage C                          */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "jered.h"

static char *dictionnaire[] =
        {
                "#define",
                "#elif",
                "#else",
                "#endif",
                "#error",
                "#ident",
                "#ifdef",
                "#ifndef",
                "#if",
                "#include",
                "#line",
                "#pragma",
                "#undef",
                "asm",
                "auto",
                "break",
                "case",
                "char",
                "const",
                "continue",
                "default",
                "defined",
                "do",
                "double",
                "else",
                "enum",
                "extern",
                "float",
                "for",
                "fortran",
                "goto",
                "if",
                "int",
                "long",
                "register",
                "return",
                "short",
                "signed",
                "sizeof",
                "static",
                "struct",
                "switch",
                "typedef",
                "union",
                "unsigned",
                "void",
                "volatile",
                "while",
                "{",
                "}",
                "delete",       /* C++ */
                "new",
                "this",
                "friend",
                "inline",
                "virtual",
                "class",
                "private",
                "protected",
                "public",
                "template",
                "try",
                "throw",
                "catch",
                "operator",
                NULL
        };

static char *delimiteurs = " ;(),:";

int dansdico(char *token);
/**********************************************************************/
void put_ligne(LIGNE *courante, int y, char *texte, int decalage)
{
        chtype buffer[SZBUF + 2];  /* buffer pour construire ecran */
        chtype *ptw;               /* pointeur sur ce buffer */
        char travail[SZBUF + 2];   /* buffer de travail pour decomposition */
        char *ptrav;               /* pointeur temporaire pour strtok */
        register char *ptreste;    /* pointeur pour sortir le reste de la ligne */
        register char *ptoken;     /* pointeur sur chaque token trouve */
        char *ptr;                 /* pointeur dans buffer de travail */
        int lgtok;                 /* longueur du token trouve */
        chtype curcolor;           /* couleur courante */
        int guillemet;             /* indicateur de guillemets */
        int cote;                  /* indicateur de cotes */
        int comment;               /* indicateur de commentaire C */

        ptw = buffer;
        if ((courante != NULL) && (courante->debut_marque != NOTMARKED))
        {
                if (texte != NULL)
                {
                        while (*texte)
                                *ptw++ = (chtype)(unsigned char)*texte++ | couleur[COULEUR_BLOC];
                }
                while (ptw <= buffer + COLS + decalage)
                        *ptw++ = (chtype)' ' | couleur[COULEUR_BLOC];
        }
        else
        {
                curcolor = couleur[COULEUR_NORMALE];
                guillemet = 0;
                cote = 0;
                comment = 0;

                if (texte != NULL)
                {
                        ptreste = texte;
                        while (*ptreste && (*ptreste == ' '))
                        {
                                *ptw++ = (chtype)' ' | couleur[COULEUR_NORMALE];
                                ptreste++;
                        }
                        strcpy(travail, ptreste);
                        ptrav = ptr = travail;

                        while ((ptoken = strtok(ptrav, delimiteurs)) != NULL)
                        {
                                ptrav = NULL;
                                while (ptr < ptoken)
                                {
                                        *ptw++ = (chtype)(unsigned char)*ptreste++ | curcolor;
                                        ptr++;
                                }
                                lgtok = strlen(ptoken);
                                ptr += lgtok;
                                ptreste += lgtok;
                                if ((! comment) && (! guillemet) && (! cote) && dansdico(ptoken))
                                {
                                        while (*ptoken)
                                                *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_MOTCLE];
                                }
                                else
                                {
                                        while (*ptoken)
                                        {
                                                        /* est-ce un debut de commentaire C */
                                                if ((! comment) && (! guillemet) && (! cote) && (*ptoken == '/') && (*(ptoken + 1) == '*'))
                                                {
                                                        comment = ! comment;
                                                        curcolor = couleur[COULEUR_COMMENT];

                                                        *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_COMMENT];
                                                }       /* est-ce une fin de commentaire C */
                                                else if (comment && (! guillemet) && (! cote) && (*ptoken == '*') && (*(ptoken + 1) == '/'))
                                                {
                                                        comment = ! comment;
                                                        curcolor = couleur[COULEUR_NORMALE];

                                                        *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_COMMENT];
                                                        *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_COMMENT];
                                                }        /* est-ce un commentaire C++ */
                                                else if ((! guillemet) && (! cote) && (*ptoken == '/') && (*(ptoken + 1) == '/'))
                                                {
                                                        while (*ptoken)
                                                                *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_COMMENT];
                                                        while (*ptreste)
                                                                *ptw++ = (chtype)(unsigned char)*ptreste++ | couleur[COULEUR_COMMENT];

                                                        /* c'est pas beau mais efficace */
                                                        goto fin_de_ligne;
                                                }       /* est-ce des cotes */
                                                else if ((*ptoken == '\'') && (! comment) && (! guillemet) && ((ptoken == travail) || ((ptoken > travail) && (*(ptoken - 1) != '\\'))))
                                                {
                                                        if (! cote)
                                                                curcolor = couleur[COULEUR_CHAR];
                                                        else
                                                                curcolor = couleur[COULEUR_NORMALE];
                                                        cote = ! cote;

                                                        *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_CHAR];
                                                }       /* est-ce des guillemets ? */
                                                else if ((*ptoken == '\"') && (! comment) && (! cote) && ((ptoken == travail) || ((ptoken > travail) && (*(ptoken - 1) != '\\'))))
                                                {
                                                        if (! guillemet)
                                                                curcolor = couleur[COULEUR_CHAINE];
                                                        else
                                                                curcolor = couleur[COULEUR_NORMALE];
                                                        guillemet = ! guillemet;

                                                        *ptw++ = (chtype)(unsigned char)*ptoken++ | couleur[COULEUR_CHAINE];
                                                }
                                                else
                                                        *ptw++ = (chtype)(unsigned char)*ptoken++ | curcolor;
                                        }
                                }
                        }
                        while (*ptreste)
                                *ptw++ = (chtype)(unsigned char)*ptreste++ | couleur[COULEUR_NORMALE];
                }
fin_de_ligne:   while (ptw <= buffer + COLS + decalage)
                        *ptw++ = (chtype)' ' | couleur[COULEUR_NORMALE];
        }

        put_txt(XMIN, y, XMAX, y, buffer + decalage);
}
/**********************************************************************/
int dansdico(char *token)
{
        char **pdico;

        for (pdico = dictionnaire; *pdico != NULL; pdico++)
        {
                if (! strcmp(*pdico, token))
                        return(1);
        }
        return(0);
}
/**********************************************************************/
int cfamily(char *filename)
/* PURPOSE OF FUNCTION:
This function verifies if the filename passed as an argument represents
a C/C++ family filename. This is the case if the extension is one of
the following: .c .cc .cpp .h in lower case or upper case.
It returns 1 if the filename is a C/C++ family filename, 0 otherwise.
 ....................................*/
{
        char *ptl;

        /* on cherche l'extension eventuelle en partant de la fin */
        ptl = filename + strlen(filename);
        while ((ptl > filename) && (*ptl != '.'))
                ptl--;

        /* extension trouvee */
        if (*ptl == '.')
        {
                if ((! strcasecmp(ptl, ".c")) || (! strcasecmp(ptl, ".cc"))
                 || (! strcasecmp(ptl, ".cpp")) || (! strcasecmp(ptl, ".h")))
                {
                        return(1);      /* fichier source de type C */
                }
        }
        return(0);      /* autre type de fichier */
}
/**********************************************************************/
