import Tkinter
import Test
import Pmw

Test.initialise()

c = Pmw.Counter

kw_1 = {
    'labelpos' : 'w',
    'label_text' : 'Counter:',
    'buttonaspect': 2.0,
    'autorepeat': 0,
    'initwait': 1000,
    'padx': 5,
    'pady': 5,
    'repeatrate': 20,
}
tests_1 = (
    (c.pack, (), {'padx' : 10, 'pady' : 10, 'fill' : 'both', 'expand' : 1}),
    (Test.num_options, (), 13),
    ('Arrow_borderwidth', 10),
    ('hull_background', 'yellow'),
    ('Arrow_background', 'green'),
    ('label_background', 'blue'),
    ('hull_borderwidth', 10),
    ('entryfield_command', Test.callback),
    ('hull_cursor', 'gumby'),
    ('datatype', 'time24'),
    ('datatype', 'numeric'),
    ('entry_borderwidth', '6'),
    ('entry_relief', 'raised'),
    ('entry_exportselection', 0),
    ('entryfield_maxwidth', 10),
    ('entryfield_maxwidth', 0),
    ('entry_foreground', 'blue'),
    ('hull_highlightcolor', 'Red'),
    ('hull_highlightthickness', 2),
    ('increment', 1),
    ('entry_insertbackground', 'Yellow'),
    ('entry_insertbackground', 'Black'),
    ('entry_insertborderwidth', 1),
    ('entry_insertborderwidth', 0),
    ('entry_insertofftime', 400),
    ('entry_insertontime', 700),
    ('entry_insertwidth', 3),
    ('entryfield_invalidcommand', Test.callback),
    ('max', 100),
    ('min', 50),
    ('entry_show', '*'),
    ('entry_background', 'red'),
    (c.setentry, '69', 1),
    ('entry_justify', 'right'),
    ('entry_justify', 'center'),
    ('entry_justify', 'left'),
    ('label_text', 'Label'),
    ('entry_relief', 'raised'),
    ('entry_relief', 'sunken'),
    ('entry_state', 'disabled'),
    ('entry_state', 'normal'),
    ('entry_background', 'GhostWhite'),
    ('entryfield_validate', 'numeric'),
    ('entryfield_validate', 'alphabetic'),
    ('entry_width', 30),
    ('entryfield_maxwidth', 'bogus',
      'ValueError: "maxwidth" option should be non-negative integer'),
    ('relief', 'bogus', 'IndexError: Unknown option "relief" for Counter'),
    (c.interior, (), Tkinter.Frame),
    (c.insert, ('end', 69)),
    (c.increment, ()),
    (c.decrement, ()),
    (c.invoke, ()),
    (c.clear, ()),
    (c.insert, ('end', 'Test String')),
    (c.get, (), 'Test String'),
    (c.delete, (0, 'end')),
    (c.insert, ('end', 'Another Test')),
    (c.icursor, 'end'),
    (c.index, 'end', 12),
    (c.selection_from, 0),
    (c.selection_to, 'end'),
    (c.xview, '3'),
    (c.clear, ()),
)

tests_2 = (
    (c.pack, (), {'padx' : 10, 'pady' : 10}),
)

alltests = [(tests_1, kw_1)]

poslist = ('nw', 'n', 'ne', 'en', 'e', 'es', 'se', 's', 'sw', 'ws', 'w', 'wn',)
for count in range(len(poslist)):
    pos = poslist[count]
    margin = count * 10
    kw_2 = {
      'entry_width' : 12,
      'labelpos' : pos,
      'labelmargin' : margin,
      'label_text' : 'Counter:',
    }
    alltests.append((tests_2, kw_2))

testData = ((c, alltests),)

if __name__ == '__main__':
    Test.runTests(testData)
