/*								-*- C++ -*-
 * $Id: WIN_slider.h,v 1.2 1997-01-15 14:58:08+01 mho Exp $
 *
 * Purpose: slider panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Slider_h
#define Slider_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;

class wxSlider : public wxItem {
DECLARE_DYNAMIC_CLASS(wxSlider)
public:
    wxSlider(void);
    wxSlider(wxPanel *panel, wxFunction func, Const char *label,
	     int value, int min_value, int max_value, int width,
	     int x = -1, int y = -1, long style = wxHORIZONTAL,
	     Constdata char *name = wxSliderNameStr);

    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		int value, int min_value, int max_value, int width,
		int x = -1, int y = -1, long style = wxHORIZONTAL,
		Constdata char *name = wxSliderNameStr);

    int   GetMin(void)   { return minimum; }
    int   GetMax(void)   { return maximum; }
    int   GetValue(void) { return value; }
    void  SetButtonColour(wxColour &col);
    void  SetRange(int smin, int smax);
    void  SetValue(int value);
    // OnChar handles cursor keys
    void OnChar(wxKeyEvent& event);
private:
    #ifdef Have_Xt_Types
    static void EventCallback(Widget, XtPointer, XtPointer);
    #endif

    int minimum, maximum, value;
};

#endif // Slider_h
