
#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include "../siod/siod.h"
#include "../siag/types.h"
#include "../siag/calc.h"
#include "../xcommon/xfonts.h"
#include "../xcommon/dialogs.h"
#include "../xcommon/embed.h"
#include "xsiag.h"

int select_file(char *path, char *name, char *patterns[], char *fmt)
{
	return fsel_input(topLevel, path, name, patterns, fmt);
}

int alert_box(char *text, char *buttons[], int nbuttons)
{
	return alertbox(topLevel, text, buttons, nbuttons);
}

int select_from_list(char *text, char *choices[], int nchoices)
{
	return listsel(topLevel, text, choices, nchoices);
}

void error_box(char *message)
{
	errorbox(topLevel, message);
}

#ifdef GUILE
static void execute_guile_action(Widget w, XEvent * event,
                           String * params, Cardinal * num_params)
{
        char b[256];
        int i;

        strcpy(b, "(");
        strncat(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        strncat(b, ")", 255);

TRACEME((f,"guile(%s)\n", b))

        exec_expr(name2interpreter("guile"), b);
}
#endif	/* GUILE */

static void execute_siod_action(Widget w, XEvent * event,
                           String * params, Cardinal * num_params)
{
        char b[256];
        int i;

        strcpy(b, "(");
        strncat(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        strncat(b, ")", 255);
        exec_expr(siod_interpreter, b);
}

#ifdef TCL
static void execute_tcl_action(Widget w, XEvent *event,
                           String *params, Cardinal *num_params)
{
        char b[256];
        int i;

        strncpy(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        exec_expr(name2interpreter("tcl"), b);
}
#endif	/* TCL */

static XtActionsRec actions[] =
{
#ifdef GUILE
        {"guile", execute_guile_action},
#endif
	{"execute", execute_siod_action},
#ifdef TCL
	{"tcl", execute_tcl_action}
#endif
};

/* a wrapper around XGetGeometry */
/* returns the list (x y width height border_width depth) */
static LISP get_geometry()
{
        Window root, cell_win = xwindow_of_window(w_list);
        int x, y;
        unsigned int width, height, border_width, depth;
        LISP result;

        XGetGeometry(XtDisplay(topLevel), cell_win, &root, &x, &y, &width, &height,
                     &border_width, &depth);

        result = cons(flocons(depth), NIL);
        result = cons(flocons(border_width), result);
        result = cons(flocons(height), result);
        result = cons(flocons(width), result);
        result = cons(flocons(y), result);
        result = cons(flocons(x), result);

        return result;
}

static LISP fit_block_width()
{
        int r, c, font_index, text_width;
        char *p;

        if (block_upper(w_list).row < 1 || block_upper(w_list).col < 1 ||
                block_lower(w_list).row < 1 || block_lower(w_list).col < 1)
                        return NIL;

        for (c = block_upper(w_list).col; c <= block_lower(w_list).col; c++) {
                set_width(buffer_of_window(w_list), c, 10);
                for (r = block_upper(w_list).row; r <= block_lower(w_list).row; r++) {
                        font_index = ret_font(buffer_of_window(w_list), r, c);
                        p = ret_pvalue(NULL, buffer_of_window(w_list), r, c, -1);
                        text_width = XTextWidth(font_struct(XtDisplay(topLevel), font_index),
                                        p, strlen(p)) + 10;
                        if (text_width > cell_width(buffer_of_window(w_list), c))
                                set_width(buffer_of_window(w_list), c, text_width);
                }
        }
        pr_scr_flag = 1;
        return NIL;
}

static LISP fit_block_height()
{
        int r, c, font_index, text_height;
        char *p;

        if (block_upper(w_list).row < 1 || block_upper(w_list).col < 1 ||
                block_lower(w_list).row < 1 || block_lower(w_list).col < 1)
                        return NIL;

        for (r = block_upper(w_list).row; r <= block_lower(w_list).row; r++) {
                set_height(buffer_of_window(w_list), r, 10);
                for (c = block_upper(w_list).col; c <= block_lower(w_list).col; c++) {
                        font_index = ret_font(buffer_of_window(w_list), r, c);
                        p = ret_pvalue(NULL, buffer_of_window(w_list), r, c, -1);
                        text_height = font_height(XtDisplay(topLevel), font_index) + 10;
                        if (text_height > cell_height(buffer_of_window(w_list), r))
                                set_height(buffer_of_window(w_list), r, text_height);
                }
        }
        pr_scr_flag = 1;
        return NIL;
}

static LISP lembed_object()
{
        char file[256], *tag;
        char *i;
        unsigned int width, height;
        buffer *buf = buffer_of_window(w_list);
        int row = get_point(w_list).row;
        int col = get_point(w_list).col;
	cval value;
	value.text = NULL;

        if (ret_type(buf, row, col) == EMBED) {
                llpr("Can't overwrite embedded object");
                return NIL;
        }

        file[0] = '\0';
        if (!ask_for_str("Object file:", file)) return NIL;

        tag = embed_load(file);
        if (tag == NULL) return NIL;

        i = tag;
        if (!i) return NIL;

        embed_size(tag, &width, &height);
        /* don't change cell width and/or height */

        undo_save(buf, row, col, row, col);
        ins_data(buf, siod_interpreter, i, value, EMBED, row, col);

        buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_remove()
{
        buffer *buf = buffer_of_window(w_list);
        int row = get_point(w_list).row;
        int col = get_point(w_list).col;
	cval value;
	value.number = 0;

        if (ret_type(buf, row, col) == EMBED) {
                undo_save(buf, row, col, row, col);
                ins_data(buf, siod_interpreter, NULL, value, EMPTY, row, col);
        }
        buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_open()
{
        buffer *buf = buffer_of_window(w_list);
        int row = get_point(w_list).row;
        int col = get_point(w_list).col;

        if (ret_type(buf, row, col) == EMBED) {
                embed_open(ret_text(buf, row, col));
                embed_load(ret_text(buf, row, col));
        }
        buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_save()
{
        char cmd[1024];
        char file[256];
        buffer *buf = buffer_of_window(w_list);
        Pixmap bitmap;

        file[0] = '\0';
        if (!ask_for_str("Object file:", file)) return NIL;

        bitmap = draw_snapshot();
        sprintf(cmd, "siag %s", buf->path);
        embed_save(file, cmd, bitmap);
        XFreePixmap(XtDisplay(topLevel), bitmap);
        return NIL;
}

static LISP copy_block()
{
        /* NULL is a bogus event */
        XtGetSelectionValue(grid_of_window(w_list), XA_PRIMARY, target_atom,
                requestor_callback, NULL, CurrentTime);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP set_block()
{
        if (get_point(w_list).row < get_mark(w_list).row) {
                set_blku_row(w_list, get_point(w_list).row);
                set_blkl_row(w_list, get_mark(w_list).row);
        } else {
                set_blku_row(w_list, get_mark(w_list).row);
                set_blkl_row(w_list, get_point(w_list).row);
        }
        if (get_point(w_list).col < get_mark(w_list).col) {
                set_blku_col(w_list, get_point(w_list).col);
                set_blkl_col(w_list, get_mark(w_list).col);
        } else {
                set_blku_col(w_list, get_mark(w_list).col);
                set_blkl_col(w_list, get_point(w_list).col);
        }

        /* Become selection owner (CurrentTime is not right, really) */
        if (XtOwnSelection(grid_of_window(w_list), XA_PRIMARY,
                CurrentTime, convert_proc,
                lose_ownership_proc, NULL) == False) {
                XtWarning("Siag: failed to become selection owner\n");
                set_blku_row(w_list, -1); set_blku_col(w_list, -1);
                set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
        }

        pr_scr_flag = TRUE;
        return NIL;
}

static LISP unset_block()
{
        set_blku_row(w_list, -1); set_blku_col(w_list, -1);
        set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
        XtDisownSelection(grid_of_window(w_list), XA_PRIMARY, CurrentTime);
        pr_scr_flag = TRUE;
        return NIL;
}

void interp_startup()
{
        XtAppContext app_context = XtWidgetToApplicationContext(topLevel);

        XtAppAddActions(app_context, actions, XtNumber(actions));
	init_subr_0("get-geometry", get_geometry);
	init_subr_0("fit-block-width", fit_block_width);
	init_subr_0("fit-block-height", fit_block_height);
	init_subr_0("embed-object", lembed_object);
	init_subr_0("embed-remove", lembed_remove);
	init_subr_0("embed-open", lembed_open);
	init_subr_0("embed-save", lembed_save);
	init_subr_0("copy-block", copy_block);
	init_subr_0("set-block", set_block);
	init_subr_0("unset-block", unset_block);
	
}

/* Postscript font handling. Metrics are taken from X */
char *ps_fontname(int index)
{
	return fonts[index].psfont;
}

int ps_text_width(int index, char *s)
{
	return XTextWidth(font_struct(XtDisplay(topLevel), index), s, strlen(s));
}

int ps_font_descent(int index)
{
	return font_descent(XtDisplay(topLevel), index);
}

int ps_font_height(long font)
{
	return font_height(XtDisplay(topLevel), font);
}

int ps_embed_print(FILE *fp, char *tag, int x_base, int y_base)
{
	return embed_print(fp, tag, x_base, y_base);
}

int ps_font_size(int index)
{
	return font_size[index];
}

