/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  bootp.h
 * Purpose: Definitions for implementing the BOOTP protocol
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * BOOTP hardware identifiers. Same as those used for ARP protocol. See
 * assigned numbers RFC.
 */
#define BOOTP_ETHER	1		/* Ethernet 10Mbps		*/
#define	BOOTP_EETHER	2		/* Experimental Ethernet	*/
#define	BOOTP_AX25	3		/* AX.25 Level 2		*/



/*
 **************************************************************************
 *
 * BOOTP protocol opcodes:
 */
#define	BOOTP_REQUEST	1		/* BOOTP request		*/
#define	BOOTP_REPLY	2		/* BOOTP reply			*/



/*
 **************************************************************************
 *
 * BOOTP UDP port numbers:
 */
#define BOOTP_S_PORT	67		/* BOOTP server port		*/
#define BOOTP_C_PORT	68		/* BOOTP client port		*/



/*
 **************************************************************************
 *
 * Various definitions:
 */
#define MIN_TIMEOUT	4		/* Min # of seconds for read timeout */
#define MAX_EXT_BLOCKS	4		/* Max # of blocks in ext file	*/



/*
 **************************************************************************
 *
 * Vendor magic ID's:
 */
#define VM_SIZE		4			/* Size of vendor magic	*/
#define	VM_STANFORD	"STAN"			/* Stanford		*/
#define VM_RFC1048      "\143\202\123\143"	/* RFC 1048		*/



/*
 **************************************************************************
 *
 * Routines in the BOOTP module which are public only within the ARPA
 * library
 */

/* Initialize the BOOTP protocol */
extern int init_bootp __P((void));
