# Module: MkSetup.tk
# 30.1.96 T.Niederreiter
# 23.03.97 tn
# 
# External called functions:
# - mksetup { w }: creates the setup-menu 
#


# Creates the Setup-Menu

proc MkSetup { w } {

	log $w "entering Setup"

	# Save the XCDR* variables
	backupglobals

	# Draw header-bar
	label $w.l -text "Setup" -relief sunken -borderwidth 2 -anchor c
	pack $w.l -fill x -expand 1 -ipady 10 -pady 5 -side top

	# Create notebook and set background to gray
	tixNoteBook $w.nb -ipadx 6 -ipady 6
	$w config -bg gray
	$w.nb subwidget nbframe config -backpagecolor gray

	# Add pages in notebook
	$w.nb add cd-setup -label "CD Setup"
	$w.nb add hd-setup -label "HD Setup"
	$w.nb add misc -label "Misc."
	$w.nb add defaults -label "Defaults"
	pack $w.nb -fill both -expand 1 -padx 5 -pady 5 -side top

	# Create first page
	set f [$w.nb subwidget cd-setup]
	mksetup_cd $f

	# Create second page
	set f [$w.nb subwidget hd-setup]
	mksetup_hd $f 

	# Create third page
	set f [$w.nb subwidget misc]
	mksetup_misc $f

	# Create fourth page
	set f [$w.nb subwidget defaults]
	mksetup_defaults $f

	setupsidebar
}


# update sidebar

proc setupsidebar { } {
global sidebar 
global statusbar
global maincanv

	set w $sidebar.all
	catch { destroy $w }
	frame $w
	pack $w -expand 1 -fill both

	button $w.b1 -text "Save" -command "setup:save_cmd .root"
	button $w.b2 -text "Cancel" -command "setup:cancel_cmd .root"
	button $w.b3 -text "Done" -command "setup:ok_cmd .root"
	tixForm $w.b1 -top %10 -left %10 -right %90
	tixForm $w.b2 -top %20 -left %10 -right %90
	tixForm $w.b3 -top %35 -left %10 -right %90

	tixBalloon $w.bal1 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b1 -msg "Saves the current configuration to disk"
	tixBalloon $w.bal2 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b2 -msg "Abort Setup, leaving all setting unchanged"
	tixBalloon $w.bal3 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b3 -msg "Setup done, use new settings"

}

proc setup:ok_cmd { w } {
global forcesetup

	# Check if settings are sane
	set stat [CheckIfSane $w]
	if { $stat == 0 } { #; all ok 
		setEndianorder
		set forcesetup 0
		mainsidebar
	}
}

proc setup:save_cmd { w } {
global CONFDIR
global CFGFILE

	# Check if settings are sane
	set stat [CheckIfSane $w]
	if { $stat == 0 } { #; all ok 
		savecfgfile $CONFDIR/$CFGFILE
		Msg_CfgSaved .cfgsaved $w
	}
	log $w "Setup: Configuration saved"
}


# Cancel pressed, restore old values and exit

proc setup:cancel_cmd { w } {

	restoreglobals
	mainsidebar
}


# Draws the CD-Setup-page

proc mksetup_cd { f } {
global XCDR_DATA_SOURCE_CDROM
global XCDR_AUDIO_SOURCE_CDROM
global XCDR_AUDIOREAD_MODE
global XCDR_AUDIOREAD_SPEED 
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_MODE
global XCDR_DEST_WRITER_SPEED 
global cdinfo
global CDRECORD

	tixLabelFrame $f.cdw -label CD-Writer 
	set f2 [$f.cdw subwidget frame]
	tixLabelFrame $f.cdrom -label CD-Reader 
	set f1 [$f.cdrom subwidget frame]

	pack $f.cdw -ipady 10 -ipadx 10
	pack $f.cdrom -ipady 10 -ipadx 10

	# older versions of Tix require that the variable in an OptionMenu
	# is not set...therefore I backup the variable and unset it.
	set tmpval $XCDR_DEST_WRITER_DEV
	unset XCDR_DEST_WRITER_DEV

	tixOptionMenu $f2.d_cd_dev -label "CD-Writer-Device : " \
        	-variable XCDR_DEST_WRITER_DEV \
        	-options { label.width 25 label.anchor e menubutton.width 32}

	# lookup in the cdlist for possible cd-writer-devices
	set i 0
	while { $cdinfo($i,0) != "x" } {
		# are we talking about scsi-devices?
		if { $cdinfo($i,2) != "" } {
			$f2.d_cd_dev add command $cdinfo($i,1)
		}

		if { $XCDR_DEST_WRITER_DEV == ""  && $cdinfo($i,2) != "" } {
			set XCDR_DEST_WRITER_DEV $cdinfo($i,1)
		}
		incr i
	}

	if { $tmpval != "" } {
		catch { $f2.d_cd_dev configure -value $tmpval }
	}
	
	pack $f2.d_cd_dev

	# get from cdrecord the list of supported CDRs
	set modelist [getcdrecorddrivers]

	# older versions of Tix require that the variable in an OptionMenu
	# is not set...therefore I backup the variable and unset it.
	set tmpval $XCDR_DEST_WRITER_MODE
	unset XCDR_DEST_WRITER_MODE

	tixOptionMenu $f2.d_cd_mde -label "CD-Writer-Mode : " \
        	-variable XCDR_DEST_WRITER_MODE \
        	-options { label.width 25 label.anchor e menubutton.width 32}

	#set tmplist { "Autodetect" "Philips/Kodak/IMS" "HP" "Yamaha" "Sony" }
	set tmplist { "autodetect" "Autodetect" }
	append tmplist $modelist

	foreach {i j} $tmplist {
		$f2.d_cd_mde add command $i -label $j

		if { $XCDR_DEST_WRITER_MODE == "" } {
			set XCDR_DEST_WRITER_MODE $i
		}
	}
	if { $tmpval != "" } {
		catch { $f2.d_cd_mde configure -value $tmpval }
	}

	pack $f2.d_cd_mde

	frame $f2.d_cd_spd
	tixLabelWidget $f2.d_cd_spd.l -label "CD-Writer Speed : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f2.d_cd_spd.b0 -text "Zero" -variable XCDR_DEST_WRITER_SPEED \
		-value 0
	radiobutton $f2.d_cd_spd.b1 -text "1x" -variable XCDR_DEST_WRITER_SPEED \
		-value 1
	radiobutton $f2.d_cd_spd.b2 -text "2x" -variable XCDR_DEST_WRITER_SPEED \
		-value 2
	radiobutton $f2.d_cd_spd.b3 -text "4x" -variable XCDR_DEST_WRITER_SPEED \
		-value 4
	radiobutton $f2.d_cd_spd.b4 -text "6x" -variable XCDR_DEST_WRITER_SPEED \
		-value 6
	radiobutton $f2.d_cd_spd.b5 -text "8x" -variable XCDR_DEST_WRITER_SPEED \
		-value 8

	# if nothing selected, select 1x
	if { $XCDR_DEST_WRITER_SPEED == "" } {
		set XCDR_DEST_WRITER_SPEED 1
	}

	pack $f2.d_cd_spd -expand 1 -fill both -padx 10
	pack $f2.d_cd_spd.l $f2.d_cd_spd.b0 $f2.d_cd_spd.b1 $f2.d_cd_spd.b2 $f2.d_cd_spd.b3 \
		$f2.d_cd_spd.b4 -side left 

	# older versions of Tix require that the variable in an OptionMenu
	# is not set...therefore I backup the variable and unset it.
	set tmpval $XCDR_DATA_SOURCE_CDROM
	unset XCDR_DATA_SOURCE_CDROM

	tixOptionMenu $f1.s_cd_dev -label "Data-Read-Device : " \
       		-variable XCDR_DATA_SOURCE_CDROM \
       		-options { label.width 25 label.anchor e menubutton.width 32 }

	# lookup in the cdlist for possible cd-reader-devices
	# IDE and SCSI
	set i 0
	while { $cdinfo($i,0) != "x" } {
		$f1.s_cd_dev add command $cdinfo($i,1)

		if { $XCDR_DATA_SOURCE_CDROM == "" } {
			set XCDR_DATA_SOURCE_CDROM $cdinfo($i,1)
		}
		incr i
	}

	# catch the error, when $tmpval contains an invalid value
	# (happens e.g. when you disconnect a scsi-device earlier connected)
	if { $tmpval != "" } {
		catch { $f1.s_cd_dev configure -value $tmpval }
	}	
	pack $f1.s_cd_dev 

	# older versions of Tix require that the variable in an OptionMenu
	# is not set...therefore I backup the variable and unset it.
	set tmpval $XCDR_AUDIO_SOURCE_CDROM
	unset XCDR_AUDIO_SOURCE_CDROM

	tixOptionMenu $f1.s_cd_dev2 -label "Audio-Read-Device : " \
       		-variable XCDR_AUDIO_SOURCE_CDROM \
       		-options { label.width 25 label.anchor e menubutton.width 32 }

	# lookup in the cdlist for possible cd-readerdevices
	# only SCSI for Read-Audio
	set i 0
	while { $cdinfo($i,0) != "x" } {
		# are we talking about scsi-devices?
		if { $cdinfo($i,2) != "" } {
			$f1.s_cd_dev2 add command $cdinfo($i,1)
		}

		if { $XCDR_AUDIO_SOURCE_CDROM == "" && $cdinfo($i,2) != "" } {
			set XCDR_AUDIO_SOURCE_CDROM $cdinfo($i,1)
		}
		incr i
	}

	# catch the error, when $tmpval contains an invalid value
	# (happens e.g. when you disconnect a scsi-device earlier connected)
	if { $tmpval != "" } {
		catch { $f1.s_cd_dev2 configure -value $tmpval }
	}	
	pack $f1.s_cd_dev2 

	# older versions of Tix require that the variable in an OptionMenu
	# is not set...therefore I backup the variable and unset it.
	set tmpval $XCDR_AUDIOREAD_MODE
	unset XCDR_AUDIOREAD_MODE

	tixOptionMenu $f1.d_read_mde -label "Audio-Read-Mode : " \
        	-variable XCDR_AUDIOREAD_MODE \
        	-options { label.width 25 label.anchor e menubutton.width 32}

	set tmplist { "Autodetect" "SCSI-3/mmc" "Philips" "New Philips" \
		"Yamaha" "Toshiba" "Sony" "Ricoh" "Teac" }
	foreach i $tmplist {
		$f1.d_read_mde add command $i 

		if { $XCDR_AUDIOREAD_MODE == "" } {
			set XCDR_AUDIOREAD_MODE $i
		}
	}
	if { $tmpval != "" } {
		catch { $f1.d_read_mde configure -value $tmpval }
	}

	pack $f1.d_read_mde

	frame $f1.s_cd_spd 
	tixLabelWidget $f1.s_cd_spd.l -label "Audio-Read-Speed : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.s_cd_spd.b0 -text "Default" -variable XCDR_AUDIOREAD_SPEED \
		-value -1
	radiobutton $f1.s_cd_spd.b1 -text "1x" -variable XCDR_AUDIOREAD_SPEED \
		-value 1
	radiobutton $f1.s_cd_spd.b2 -text "2x" -variable XCDR_AUDIOREAD_SPEED \
		-value 2
	radiobutton $f1.s_cd_spd.b3 -text "4x" -variable XCDR_AUDIOREAD_SPEED \
		-value 4
	radiobutton $f1.s_cd_spd.b4 -text "6x" -variable XCDR_AUDIOREAD_SPEED \
		-value 6

	if { $XCDR_AUDIOREAD_SPEED == "" } {
		set XCDR_AUDIOREAD_SPEED -1
	}

	pack $f1.s_cd_spd -expand 1 -fill both -padx 10
	pack $f1.s_cd_spd.l $f1.s_cd_spd.b0 $f1.s_cd_spd.b1 $f1.s_cd_spd.b2 \
		$f1.s_cd_spd.b3 $f1.s_cd_spd.b4 -side left 

}


# Draws the HD-Setup-page
 
proc mksetup_hd { f } {
global XCDR_IMAGE_PART
global XCDR_IMAGE_MNTPNT
global XCDR_IMAGE_PART2
global XCDR_IMAGE_MNTPNT2
global XCDR_IMAGE_FIXED
global XCDR_DEFAULT_PART

	tixLabelFrame $f.image -label "Temporary Disk-Space: (Only one have to be set)"
	pack $f.image -expand 1 -fill x -padx 50  
	set f2 [$f.image subwidget frame]

	#-----------------
	canvas $f2.c0 -height 0 -width 500 
	pack $f2.c0  -pady 5
	#-----------------

	frame $f2.imgprt 
	tixLabelWidget $f2.imgprt.l -label "Image-Partition 1: " \
		-options {label.width 25 label.anchor e}
	frame $f2.imgprt.f -width 250 -relief sunken -borderwidth 2 
	pack $f2.imgprt.f -side right -expand 1 -fill x
	pack $f2.imgprt.l
	message $f2.imgprt.f.msg -anchor w -width 300 \
		-text " \n " 
	pack $f2.imgprt.f.msg -expand 1 -fill x 
	
	global TMP_XCDR_IMAGE_PART
	set TMP_XCDR_IMAGE_PART $f2.imgprt.f.msg
	updateselimagetextbox XCDR_IMAGE_PART

	pack $f2.imgprt -expand 1 -fill x
	frame $f2.imgsel
	tixLabelWidget $f2.imgsel.l \
		-options {label.width 25 label.anchor e}
	button $f2.imgsel.b -text "Select" \
		-command "spawnsubwindow selectimagepartition .sel .root 2 {XCDR_IMAGE_PART}"
	radiobutton $f2.imgsel.rb -text "Default" -value 1 \
		-variable XCDR_DEFAULT_PART
	pack $f2.imgsel -fill x -expand 1
	pack $f2.imgsel.l $f2.imgsel.b -side left
	pack $f2.imgsel.rb -side right


	frame $f2.imgmnt
	tixLabelEntry $f2.imgmnt.e -label "Image-Mountpoint 1: " \
		-options { 
			label.width 25 label.anchor e 
			entry.width 20 entry.textVariable XCDR_IMAGE_MNTPNT }

	button $f2.imgmnt.b -text "Browse" \
		-command "spawnsubwindow selectimagemntpnt .mnt .root 2 {XCDR_IMAGE_MNTPNT}" 
	pack $f2.imgmnt.e $f2.imgmnt.b -side left
	pack $f2.imgmnt -expand 1 -fill x

	#-----------------
	canvas $f2.c -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f2.c -pady 5
	#-----------------

	frame $f2.imgprt2 
	tixLabelWidget $f2.imgprt2.l -label "Image-Partition 2: " \
		-options {label.width 25 label.anchor e}
	frame $f2.imgprt2.f -width 250 -relief sunken -borderwidth 2 
	pack $f2.imgprt2.f -side right -expand 1 -fill x
	pack $f2.imgprt2.l
	message $f2.imgprt2.f.msg -anchor w -width 300 \
		-text " \n " 
	pack $f2.imgprt2.f.msg -expand 1 -fill x 
	
	global TMP_XCDR_IMAGE_PART2
	set TMP_XCDR_IMAGE_PART2 $f2.imgprt2.f.msg
	updateselimagetextbox XCDR_IMAGE_PART2

	pack $f2.imgprt2 -expand 1 -fill x
	frame $f2.imgsel2
	tixLabelWidget $f2.imgsel2.l \
		-options {label.width 25 label.anchor e}
	button $f2.imgsel2.b -text "Select" \
		-command "spawnsubwindow selectimagepartition .sel .root 2 {XCDR_IMAGE_PART2}"
	radiobutton $f2.imgsel2.rb -text "Default" -value 2 \
		-variable XCDR_DEFAULT_PART
	pack $f2.imgsel2 -fill x -expand 1
	pack $f2.imgsel2.l $f2.imgsel2.b -side left
	pack $f2.imgsel2.rb -side right


	frame $f2.imgmnt2
	tixLabelEntry $f2.imgmnt2.e -label "Image-Mountpoint 2: " \
		-options { 
			label.width 25 label.anchor e 
			entry.width 20 entry.textVariable XCDR_IMAGE_MNTPNT2 }

	button $f2.imgmnt2.b -text "Browse" \
		-command "spawnsubwindow selectimagemntpnt .mnt .root 2 {XCDR_IMAGE_MNTPNT2}" 
	pack $f2.imgmnt2.e $f2.imgmnt2.b -side left
	pack $f2.imgmnt2 -expand 1 -fill x

	#-----------------
	canvas $f2.c2 -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f2.c2 -pady 5
	#-----------------

	frame $f2.imgmnt3
	tixLabelEntry $f2.imgmnt3.e -label "Image-Data-Path: " \
		-options { 
			label.width 25 label.anchor e 
			entry.width 20 entry.textVariable XCDR_IMAGE_FIXED }

	button $f2.imgmnt3.b -text "Browse" \
		-command "spawnsubwindow selectimagemntpnt .mnt .root 2 {XCDR_IMAGE_FIXED }" 
	pack $f2.imgmnt3.e $f2.imgmnt3.b -side left
	pack $f2.imgmnt3 -expand 1 -fill x

	frame $f2.imgsel3
	radiobutton $f2.imgsel3.rb -text "Default" -value 3 \
		-variable XCDR_DEFAULT_PART
	pack $f2.imgsel3.rb -side right
	pack $f2.imgsel3 -expand 1 -fill x

	if { $XCDR_DEFAULT_PART == "" } {
		set XCDR_DEFAULT_PART 1
	}
}


# Draws the Misc-Setup-page

proc mksetup_misc { f } {
global XCDR_BEEP
global XCDR_BEEP_VIA
global XCDR_LOGFILE
global XCDR_LOGNAME
global XCDR_DSP_DEV
global XCDR_AUTORAISE
global XCDR_SAVEWINPOS 

	tixLabelFrame $f.misc -label "Misc." 
	pack $f.misc -fill x -expand 1 -padx 50
	set f1 [$f.misc subwidget frame]

	# older versions of Tix require that the variable in an OptionMenu
	# is not set...therefore I backup the variable and unset it.
	set tmpval $XCDR_DSP_DEV
	unset XCDR_DSP_DEV

	frame $f1.dsp

	tixOptionMenu $f1.dsp.dspdev -label "DSP-Device for Audio : " \
        	-variable XCDR_DSP_DEV \
        	-options { label.width 25 label.anchor e menubutton.width 20 } \
		-command "changedspdev $f1.beep3.b1 $f1.dsp.dsptest"


	button $f1.dsp.dsptest -text "Test" -command "spawnsubwindow showdsptest .dsptest .root 2 {} "
	pack $f1.dsp.dspdev $f1.dsp.dsptest -side left
	pack $f1.dsp -expand 1 -fill x

	#-----------------
	canvas $f1.c  -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f1.c  -pady 5
	#-----------------

	frame $f1.beep3 
	tixLabelWidget $f1.beep3.l -label "Beep via : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.beep3.b1 -text "DSP-Device" -variable XCDR_BEEP_VIA \
		-value "dsp" 
	radiobutton $f1.beep3.b2 -text "Internal Speaker" \
		-variable XCDR_BEEP_VIA -value "speaker" 
	pack $f1.beep3.l $f1.beep3.b1 $f1.beep3.b2 -side left
	pack $f1.beep3 -expand 1 -fill x

	if { $XCDR_BEEP_VIA == "" } {
		set XCDR_BEEP_VIA "speaker"
	}

	set TMP_VIA $XCDR_BEEP_VIA

	# fill the optionbox above. We do this this late, so that
	# the radiobuttons are already defined, so that the callback
	# will work
	$f1.dsp.dspdev add command "None"
	# Get all dsp-devices 
	set tmplist [glob /dev/dsp*]
	foreach i $tmplist {
        	$f1.dsp.dspdev add command $i 

		if { $XCDR_DSP_DEV == "" } {
			set XCDR_DSP_DEV "None" 
		}
	}

	if { $tmpval != "" } {
		catch { $f1.dsp.dspdev configure -value $tmpval }
	}

	set XCDR_BEEP_VIA $TMP_VIA

	frame $f1.beep 
	tixLabelWidget $f1.beep.l -label "when : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.beep.b1 -text "Never" -variable XCDR_BEEP \
		-value "off" 
	radiobutton $f1.beep.b2 -text "Always" -variable XCDR_BEEP \
		-value "on" 

	pack $f1.beep -expand 1 -fill x
	pack $f1.beep.l $f1.beep.b1 $f1.beep.b2 -side left

	frame $f1.beep2
	tixLabelWidget $f1.beep2.l \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.beep2.b3 -text "On Completion" -variable XCDR_BEEP \
		-value "oncompl" 
	radiobutton $f1.beep2.b4 -text "On Warnings" -variable XCDR_BEEP \
		-value "onwarn" 

	pack $f1.beep2 -expand 1 -fill x
	pack $f1.beep2.l $f1.beep2.b3 $f1.beep2.b4 -side left

	if { $XCDR_BEEP == "" } {
		set XCDR_BEEP "off"
	}

	#-----------------
	canvas $f1.c2  -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f1.c2  -pady 5
	#-----------------

	frame $f1.log
	tixLabelWidget $f1.log.l -label "Logfile : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.log.b1 -text "None" -variable XCDR_LOGFILE \
		-value "off" -command "$f1.log2.e configure -state disabled"
	radiobutton $f1.log.b2 -text "Filename:" -variable XCDR_LOGFILE \
		-value "on" -command "$f1.log2.e configure -state normal"

	pack $f1.log -expand 1 -fill x
	pack $f1.log.l $f1.log.b1 $f1.log.b2 -side left

	if { $XCDR_LOGFILE == "" } {
		set XCDR_LOGFILE "off"
	}

	frame $f1.log2
	tixLabelEntry $f1.log2.e -disabledforeground gray \
		-options { 
			label.width 25 label.anchor e 
			entry.width 25 entry.textVariable XCDR_LOGNAME 
		 }
	button $f1.log2.b -text "Browse" \
		-command "spawnsubwindow selectlogfilename .sellog .root 2 {} " 
	pack $f1.log2.e $f1.log2.b -side left
	pack $f1.log2 -fill x -expand 1


	# trigger radiobutton, to be sure the -command-scripts
	# have been run
	if { $XCDR_LOGFILE == "off" } "$f1.log.b1 invoke"

	#-----------------
	canvas $f1.c3  -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f1.c3  -pady 5
	#-----------------

	frame $f1.auto
	tixLabelWidget $f1.auto.l -label "Auto-Raise/Lower : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.auto.b1 -text "Never" -variable XCDR_AUTORAISE \
		-value 0 
	radiobutton $f1.auto.b2 -text "Always" -variable XCDR_AUTORAISE \
		-value 2
	pack $f1.auto -expand 1 -fill x
	pack $f1.auto.l $f1.auto.b1 $f1.auto.b2 -side left

	frame $f1.auto2
	tixLabelWidget $f1.auto2.l \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.auto2.b1 -text "Only on Read/Verify/Write/Master" \
		-variable XCDR_AUTORAISE -value 1

	pack $f1.auto2 -expand 1 -fill x
	pack $f1.auto2.l $f1.auto2.b1 -side left

	#-----------------
	canvas $f1.c4  -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f1.c4  -pady 5
	#-----------------
	frame $f1.auto3
	tixLabelWidget $f1.auto3.l -label "Save Window-Positions : " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.auto3.b1 -text "Never" -variable XCDR_SAVEWINPOS \
		-value 0 
	radiobutton $f1.auto3.b2 -text "Same pos for all windows" -variable XCDR_SAVEWINPOS \
		-value 2
	pack $f1.auto3 -expand 1 -fill x
	pack $f1.auto3.l $f1.auto3.b1 $f1.auto3.b2 -side left
	frame $f1.auto4
	tixLabelWidget $f1.auto4.l \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.auto4.b1 -text "Own pos for each process-window" \
		-variable XCDR_SAVEWINPOS -value 1
	pack $f1.auto4 -expand 1 -fill x
	pack $f1.auto4.l $f1.auto4.b1 -side left


	if { $XCDR_AUTORAISE == "" } {
		set XCDR_AUTORAISE 0 
	}

	if { $XCDR_SAVEWINPOS == "" } {
		set XCDR_SAVEWINPOS 0 
	}
}


# Draws the Defaults-Setup-page

proc mksetup_defaults { f } {
global XCDR_SUB_VIEW
global XCDR_EJECT
global XCDR_PADDATA
global XCDR_SWABAUDIO
global XCDR_DUMMY
global XCDR_GLOBAL_OFFSETS
global XCDR_SKIP2SEC
global XCDR_AUDIO_UNITS
global XCDR_ECHOLISTEN

	# preselect defaults
	if { $XCDR_SUB_VIEW == "" } {
		set XCDR_SUB_VIEW 1
	}
	if { $XCDR_EJECT == "" } {
		set XCDR_EJECT 1
	}
	if { $XCDR_PADDATA == "" } {
		set XCDR_PADDATA 0
	}
	if { $XCDR_DUMMY == "" } {
		set XCDR_DUMMY 0
	}
	if { $XCDR_SWABAUDIO == "" } {
		set XCDR_SWABAUDIO 0
	}
	if { $XCDR_GLOBAL_OFFSETS == "" } {
		set XCDR_GLOBAL_OFFSETS 0
	}
	if { $XCDR_SKIP2SEC == "" } {
		set XCDR_SKIP2SEC 1
	}
	if { $XCDR_AUDIO_UNITS == "" } {
		set XCDR_AUDIO_UNITS "sec"
	}
	if { $XCDR_ECHOLISTEN == "" } {
		set XCDR_ECHOLISTEN 0
	}

	tixLabelFrame $f.misc -label "Default-Values for miscellaneous Options" 
	pack $f.misc -fill x -expand 1 -padx 50
	set f1 [$f.misc subwidget frame]

	frame $f1.wte
	tixLabelWidget $f1.wte.l -label "Default Write-Options: " \
		-options {label.width 25 label.anchor e}
	checkbutton $f1.wte.b1 -variable XCDR_DUMMY -anchor w \
                -text "Simulation-Write" -width 16 
	checkbutton $f1.wte.b2 -variable XCDR_PADDATA -anchor w \
                -text "Pad Data-Track"
	pack $f1.wte.l $f1.wte.b1 $f1.wte.b2 -side left
	pack $f1.wte -expand 1 -fill x
	frame $f1.wte2
	tixLabelWidget $f1.wte2.l \
		-options {label.width 25 label.anchor e}
	checkbutton $f1.wte2.b1 -variable XCDR_EJECT -anchor w \
                -text "Eject after write" -width 16 
	checkbutton $f1.wte2.b2 -variable XCDR_SWABAUDIO -anchor w \
                -text "Swap Audio"
	pack $f1.wte2.l $f1.wte2.b1 $f1.wte2.b2 -side left
	pack $f1.wte2 -expand 1 -fill x
#	frame $f1.wte3
#	tixLabelWidget $f1.wte3.l \
#		-options {label.width 25 label.anchor e}
#	checkbutton $f1.wte3.b1 -variable XCDR_PADDATA -anchor w \
#                -text "Pad Data-Track"
#	pack $f1.wte3.l $f1.wte3.b1 -side left
#	pack $f1.wte3 -expand 1 -fill x

	#-----------------
	canvas $f1.c  -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f1.c  -pady 5
	#-----------------

	frame $f1.view
	tixLabelWidget $f1.view.l -label "Default Subprocess-View: " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.view.b1 -variable XCDR_SUB_VIEW -value 0 -anchor w \
                -text "Normal (Text + Progress-bar)"
	pack $f1.view.l $f1.view.b1 -side left
	pack $f1.view -expand 1 -fill x
	frame $f1.view2
	tixLabelWidget $f1.view2.l  \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.view2.b1 -variable XCDR_SUB_VIEW -value 1 -anchor w \
                -text "Extended (Text + Progress-bar + Output)"
	pack $f1.view2.l $f1.view2.b1 -side left
	pack $f1.view2 -expand 1 -fill x
	frame $f1.view3
	tixLabelWidget $f1.view3.l  \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.view3.b1 -variable XCDR_SUB_VIEW -value 2 -anchor w \
                -text "Small (only Progress-bar)"
	pack $f1.view3.l $f1.view3.b1 -side left
	pack $f1.view3 -expand 1 -fill x

	#-----------------
	canvas $f1.c2  -height 0 -width 500 -relief sunken -borderwidth 1
	pack $f1.c2  -pady 5
	#-----------------

	frame $f1.audio
	tixLabelWidget $f1.audio.l -label "Default Read-Audio-Opt.: " \
		-options {label.width 25 label.anchor e}
	checkbutton $f1.audio.b1 -variable XCDR_GLOBAL_OFFSETS -anchor w \
                -text "Global Offsets"
	pack $f1.audio.l $f1.audio.b1 -side left
	pack $f1.audio -expand 1 -fill x
	frame $f1.audio2
	tixLabelWidget $f1.audio2.l \
		-options {label.width 25 label.anchor e}
	checkbutton $f1.audio2.b1 -variable XCDR_SKIP2SEC -anchor w \
                -text "Skip last 2 sec. of track"
	pack $f1.audio2.l $f1.audio2.b1 -side left
	pack $f1.audio2 -expand 1 -fill x
	frame $f1.audio5
	tixLabelWidget $f1.audio5.l -label "Listen while recording: " \
		-options {label.width 25 label.anchor e}
	checkbutton $f1.audio5.b1 -variable XCDR_ECHOLISTEN -anchor w \
                -text "(Audio-Read-Speed = 1x  when ON)"
	pack $f1.audio5.l $f1.audio5.b1 -side left
	pack $f1.audio5 -expand 1 -fill x
	frame $f1.audio3
	tixLabelWidget $f1.audio3.l -label "Time-Offset Unit: " \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.audio3.b1 -variable XCDR_AUDIO_UNITS -value "sec" \
		-anchor w -text "Seconds"
	pack $f1.audio3.l $f1.audio3.b1 -side left
	pack $f1.audio3 -expand 1 -fill x
	frame $f1.audio4
	tixLabelWidget $f1.audio4.l \
		-options {label.width 25 label.anchor e}
	radiobutton $f1.audio4.b1 -variable XCDR_AUDIO_UNITS -value "frame" \
		-anchor w -text "Frames (1/75 sec)"
	pack $f1.audio4.l $f1.audio4.b1 -side left
	pack $f1.audio4 -expand 1 -fill x

}


# called when the dsp-device is changed

proc changedspdev { w w2 newval } {
global XCDR_BEEP_VIA

	if { $newval == "None" } {
		set XCDR_BEEP_VIA "speaker"
		$w config -state disabled
		$w2 config -state disabled
	} else {
		$w config -state normal 
		$w2 config -state normal 
	}	
	
}


# play a testsample

proc dotestdsp { } {
global XCDR_DSP_DEV
global PLAYCDDA
global TESTSAMPLE

	catch { exec $PLAYCDDA -q -d $XCDR_DSP_DEV $TESTSAMPLE }
}


# called when the dsp-test-button is pressed

proc showdsptest { w args } {

	message $w.1 -text "Press the \"Play Sample\"-button to play a CD-Quality sample. If you hear the sound correct, then your DSP-Device is working perfectly. If you hear nothing, then your DSP-Device is not configured, or is not able to play samples with that quality, or incorrect choosen." -width 400

	pack $w.1 

	tixButtonBox $w.box -orient horizontal
	$w.box add play -text "Play Sample" -command "dotestdsp" 
	$w.box add cancel -text "Cancel" -command "destroy $w"
	pack $w.box -fill x -expand 1 
}


# Check if all settings are sane. Warn the user if anything is 
# missing. Executed by the Ok-Button.
# Return 0 if all is ok, 1 on problems.

proc CheckIfSane { w } {
global XCDR_DATA_SOURCE_CDROM
global XCDR_AUDIO_SOURCE_CDROM
global XCDR_AUDIOREAD_MODE
global XCDR_AUDIOREAD_SPEED 
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_MODE
global XCDR_DEST_WRITER_SPEED 
global XCDR_IMAGE_PART
global XCDR_IMAGE_MNTPNT
global XCDR_IMAGE_PART2
global XCDR_IMAGE_MNTPNT2
global XCDR_IMAGE_FIXED
global XCDR_DEFAULT_PART
global XCDR_BEEP
global XCDR_BEEP_VIA
global XCDR_LOGFILE
global XCDR_LOGNAME
global XCDR_DSP_DEV

	set ok 0
	if { $XCDR_BEEP_VIA == "" || $XCDR_BEEP == "" ||
	     $XCDR_LOGFILE == "" || $XCDR_DEFAULT_PART == "" } {
		set ok 1	
		set stat [Msg_SetupNotCompl1 .setnc  $w ]
		if { $stat == 1 } {	;# Bail out
			exit
		}
	}

	# No CD-Writer choosen
	if { $XCDR_DEST_WRITER_DEV == "" } {
		set stat [Msg_SetupNoWriter .setnw $w ]
		if { $stat == 1 } {	;# return to setup
			return 1
		}
	} else {
		# We have a writer, but have we the speed?
		if { $XCDR_DEST_WRITER_SPEED == "" } {
			set ok 1	
			set stat [Msg_SetupNotCompl1 .setnc  $w ]
			if { $stat == 1 } {	;# Bail out
				exit
			}
		}
	}

	# No Data-Reader choosen
	if { $XCDR_DATA_SOURCE_CDROM == "" } {
		set stat [Msg_SetupNoDataReader .setnw $w ]
		if { $stat == 1 } {	;# return to setup
			return 1
		}
	}
	
	# No Audio-Reader choosen
	if { $XCDR_AUDIO_SOURCE_CDROM == "" } {
		set stat [Msg_SetupNoAudioReader .setnw $w ]
		if { $stat == 1 } {	;# return to setup
			return 1
		}
	} else {
		# We have a reader, but have we the speed?
		if { $XCDR_AUDIOREAD_SPEED == "" } {
			set ok 1	
			set stat [Msg_SetupNotCompl1 .setnc  $w ]
			if { $stat == 1 } {	;# Bail out
				exit
			}
		}
	}
	
	if { $XCDR_LOGFILE == "on" && $XCDR_LOGNAME == "" } {
		set ok 1
		Msg_SetupNotCompl2 .setnc $w 
	}

	if { $XCDR_DEFAULT_PART == "1" && ( $XCDR_IMAGE_PART == "" ||
	     $XCDR_IMAGE_MNTPNT == "" ) } {
		set ok 1
		Msg_SetupNotCompl3 .setnc $w 
	}
	if { $XCDR_DEFAULT_PART == "2" && ( $XCDR_IMAGE_PART2 == "" ||
	     $XCDR_IMAGE_MNTPNT2 == "" ) } {
		set ok 1
		Msg_SetupNotCompl3 .setnc $w 
	}
	if { $XCDR_DEFAULT_PART == "3" && $XCDR_IMAGE_FIXED == "" } {
		set ok 1
		Msg_SetupNotCompl4 .setnc $w 
	}
	if { $XCDR_IMAGE_FIXED != "" } {
		set XCDR_IMAGE_FIXED [string trimright $XCDR_IMAGE_FIXED "/"]
		if { $XCDR_IMAGE_FIXED == "" } { set XCDR_IMAGE_FIXED "/" }
		if { [file isdirectory $XCDR_IMAGE_FIXED] == 0 } {
		 	set ok 1
			Msg_SetupNotCompl5 .setnc $w $XCDR_IMAGE_FIXED 
			set XCDR_IMAGE_FIXED ""
		}
	}

	if { $XCDR_IMAGE_MNTPNT2 == "/" } {
		set ok 1
		Msg_SetupNotCompl6 .setnc $w  
		set XCDR_IMAGE_MNTPNT2 ""
	}

	if { $XCDR_IMAGE_MNTPNT == "/" } {
		set ok 1
		Msg_SetupNotCompl6 .setnc $w  
		set XCDR_IMAGE_MNTPNT ""
	}

	if { $XCDR_IMAGE_MNTPNT2 != "" } {
		set XCDR_IMAGE_MNTPNT2 [string trimright $XCDR_IMAGE_MNTPNT2 "/"]
		if { [file isdirectory $XCDR_IMAGE_MNTPNT2] == 0 } {
		 	set ok 1
			Msg_SetupNotCompl5 .setnc $w $XCDR_IMAGE_MNTPNT2 
			set XCDR_IMAGE_MNTPNT2 ""
		}
	}
	if { $XCDR_IMAGE_MNTPNT != "" } {
		set XCDR_IMAGE_MNTPNT [string trimright $XCDR_IMAGE_MNTPNT "/"]
		if { [file isdirectory $XCDR_IMAGE_MNTPNT] == 0 } {
		 	set ok 1
			Msg_SetupNotCompl5 .setnc $w $XCDR_IMAGE_MNTPNT 
			set XCDR_IMAGE_MNTPNT ""
		}
	}

	return $ok
}

