// pulsegen.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Utility class for generating an evenly-spaced series of pulses in a Sound
// object.  Primarly used for calibration of other processes.

#ifndef PULSEGEN_H
#ifdef __GNUG__
#pragma interface
#endif
#define PULSEGEN_H

#include "processfun.h"

class PulseGenerator : public SimpleFunction {
	typedef SimpleFunction Super;
	friend class PulseGenerateRequester;
public:
	PulseGenerator(Data* output);
	PulseGenerator(Data* output, int space, double amp=1.0);
	redefined const char* message() { return "Synthesizing..."; }
	redefined void restoreState() { count = 0; }
	redefined double operator () (double input);
protected:
	redefined Requester* createRequester();
private:
	int count;
	int spacing;
	double amplitude;
};

#endif

