;; $Id: dbverb.dsl 1.2 1998/02/19 17:59:12 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(define ($format-linenumber$ linenumber)
  ;; A line-field would make more sense here, and allow proportional
  ;; fonts, but you can't put line-fields in the middle of a paragraph
  ;; in the current RTF backend of Jade
  (let ((%factor% (if %verbatim-size-factor%
		      %verbatim-size-factor%
		      1.0)))
    (if (equal? (remainder linenumber %linenumber-mod%) 0)
	(make sequence
	  font-family-name: %mono-font-family%
	  font-size: (* (inherited-font-size) %factor%)
	  (literal (pad-string (format-number linenumber "1") 
			       %linenumber-length% %linenumber-padchar%))
	  ($linenumber-space$))
	(make sequence
	  font-family-name: %mono-font-family%
	  font-size: (* (inherited-font-size) %factor%)
	  (literal (pad-string "" %linenumber-length% " "))
	  ($linenumber-space$)))))

(define ($linespecific-content$)
  (process-children))

(define ($linespecific-content-with-linenumbers$)
  (make sequence
    ($format-linenumber$ 1)
    (let loop ((kl (children (current-node)))
	       (linecount 1)
	       (res (empty-sosofo)))
      (if (node-list-empty? kl)
	  res
	  (loop
	   (node-list-rest kl)
	   (if (char=? (node-property 'char (node-list-first kl)
				      default: #\U-0000) #\U-000D)
	       (+ linecount 1)
	       linecount)
	   (let ((c (node-list-first kl)))
	     (if (char=? (node-property 'char c default: #\U-0000) 
			 #\U-000D)
		 (sosofo-append res
				(process-node-list c)
				($format-linenumber$ (+ linecount 1)))
		 (sosofo-append res (process-node-list c)))))))))

(define ($verbatim-display$ line-numbers?)
  (let* ((width-in-chars (if (attribute-string "width")
			     (string->number (attribute-string "width"))
			     %verbatim-default-width%))
	 (fsize (lambda () (if (or (attribute-string "WIDTH")
				   (not %verbatim-size-factor%))
			       (/ (/ (- %text-width% (inherited-start-indent))
				     width-in-chars) 
				  0.7)
			       (* (inherited-font-size) 
				  %verbatim-size-factor%))))
	 (vspace (if (INBLOCK?)
		     0pt
		     (if (INLIST?)
			 %para-sep% 
			 %block-sep%))))
    (make paragraph
	  space-before: vspace
	  space-after:  vspace
	  font-family-name: %mono-font-family%
	  font-size: (fsize)
	  font-weight: 'medium
	  font-posture: 'upright
	  line-spacing: (* (fsize) %line-spacing-factor%)
	  first-line-start-indent: 0pt
	  start-indent: (if (INBLOCK?)
			    (inherited-start-indent)
			    (+ %block-start-indent% (inherited-start-indent)))
	  lines: 'asis
          input-whitespace-treatment: 'preserve
	  quadding: 'start
	  (if line-numbers?
	      ($linespecific-content-with-linenumbers$)
	      ($linespecific-content$)))))

(define ($linespecific-display$ line-numbers?)
  (let ((vspace (if (INBLOCK?)
		   0pt
		   (if (INLIST?) 
		       %para-sep% 
		       %block-sep%))))
    (make paragraph
      space-before: vspace
      space-after:  vspace
      first-line-start-indent: 0pt
      start-indent: (if (INBLOCK?)
			(inherited-start-indent)
			(+ %block-start-indent% (inherited-start-indent)))
      lines: 'asis
      input-whitespace-treatment: 'preserve
      quadding: 'start
      (if line-numbers?
	  ($linespecific-content-with-linenumbers$)
	  ($linespecific-content$)))))

(element LITERALLAYOUT ($linespecific-display$ %number-literallayout-lines%))
(element ADDRESS ($linespecific-display$ %number-address-lines%))
(element PROGRAMLISTING ($verbatim-display$ %number-programlisting-lines%))
(element SCREEN ($verbatim-display$ %number-screen-lines%))

(element SCREENSHOT (process-children))
(element SCREENINFO (empty-sosofo))

