#include <signal.h>
#include <stdio.h>

struct sigaction sigusr1_vec,  sigusr1_ovec;
struct sigaction sigusr2_vec,  sigusr2_ovec;

FILE *fp;
int ckpt_count;

/************************************************************************************/

void sigusr1()

{

char cur_host[40];
        
        gethostname(cur_host, sizeof(cur_host));
        fprintf(fp,"MIGRATING from %s\n",cur_host);
        fclose(fp);
        ckpt();
        exit(77); /* this exit value will be used */

}

/************************************************************************************/

void sigusr2()

{

char cur_host[40];

        gethostname(cur_host, sizeof(cur_host));
        fprintf(fp,"We are about to die!\n");
        fclose(fp);
        ckpt();
        exit(78); /* this exit value will be used */

}

/************************************************************************************/

main()

{

int i;

        sigusr1_vec.sa_handler=sigusr1;
        sigfillset(&sigusr1_vec.sa_mask);
        sigdelset(&sigusr1_vec.sa_mask,SIGQUIT);
        sigusr1_vec.sa_flags=0;
        sigaction(SIGQUIT,&sigusr1_vec,&sigusr1_ovec);

        sigusr2_vec.sa_handler=sigusr2;
        sigfillset(&sigusr2_vec.sa_mask);
        sigdelset(&sigusr2_vec.sa_mask,SIGQUIT);
        sigusr2_vec.sa_flags=0;
        sigaction(SIGUSR2,&sigusr2_vec,&sigusr2_ovec);

        fp = fopen("DQS.CKPT","r");

        if (!fp) 
           ckpt_count=0;
        else {
           fscanf(fp,"%d",&ckpt_count);
           fclose(fp);
           }

        fp = fopen("DQS.OUT","a");

        if (!fp) {
                perror("error opening DQS.OUT\n");
                exit(-1);
                }

        for (i=ckpt_count;i<1000;i++) {
              do_something();
              ckpt_count++;
              ckpt();
              fprintf(fp,"ckpt no. %d-------------------------\n",ckpt_count);
              fflush(fp);
	    }

       exit(0);

      }

/************************************************************************************/

ckpt()

{
FILE *fp2;

        fp2 = fopen("DQS.CKPT","w");
        fprintf(fp2,"%d",ckpt_count);
        fclose(fp2);

}

/************************************************************************************/

do_something()

{

int i,j,k;

       for (i=0;i<1000;i++)
           {
		for (j=0;j<100000;j++)
		{
		     if (!(j%50000))
		     {
			  fprintf(fp,"%d %d\n",i,j);
			  fflush(fp);
		     }
		     k=j;
		}
	   }

}

               
