;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Cgen/main.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 17:59:38 1995                          */
;*    Last change :  Thu Aug 21 12:14:02 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We produce a Bigloo's `main' function.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_main
   (import  engine_param
	    module_module
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_env
	    ast_sexp
	    ast_local
	    ast_glo-def)
   (export  (make-bigloo-main)))

;*---------------------------------------------------------------------*/
;*    make-bigloo-main ...                                             */
;*---------------------------------------------------------------------*/
(define (make-bigloo-main)
   (let* ((args        (list (make-local-svar 'argv *obj*)))
	  (user-main   (if (global? *main*)
			   *main*
			   #f))
	  (main-body   (if (global? user-main)
			   `(begin
			       (,(module-initialization-id *module*)
				0
				,(symbol->string *module*))
			       (bigloo-exit ((@ ,(global-id user-main)
						,(global-module user-main))
					     argv)))
			   `(bigloo-exit
			     (,(module-initialization-id *module*)
			      0
			      ,(symbol->string *module*)))))
	  (node        (let ((_ *_*))
			  (set! *_* *obj*)
			  (let ((node (sexp->node main-body args #f 'value)))
			     (set! *_* _)
			     node)))
	  (bigloo-main (def-global-sfun! 'bigloo_main::obj
			  '(argv::obj)
			  args
			  *module*
			  'sfun
			  'bigloo-main-procedure
			  'now
			  node)))
      (global-name-set! bigloo-main "bigloo_main")
      bigloo-main))
