;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/initial.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:41:05 1994                          */
;*    Last change :  Fri Feb 27 16:53:03 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Initial compiler expanders.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_install
   (import expand_if
	   expand_lambda
	   expand_define
	   expand_expander
	   expand_exit
	   expand_garithmetique
	   expand_iarithmetique
	   expand_farithmetique
	   expand_let
	   expand_case
	   expand_struct
	   expand_map
	   expand_assert
	   expand_object
	   tools_progn
	   engine_param
	   expand_expander)
   (export (install-initial-expander)))

;*---------------------------------------------------------------------*/
;*    install-initial-expander ...                                     */
;*---------------------------------------------------------------------*/
(define (install-initial-expander)
   ;; In order to be able to install O-macros,
   ;; we first of all, we perform Oenv initialization
   (initialize-Oenv!)

   ;; if
   (install-compiler-expander 'if expand-if)
   
   ;; not
   (install-compiler-expander 'not expand-not)
   
   ;; lambda
   (install-compiler-expander 'lambda expand-lambda)
   
   ;; define
   (install-compiler-expander 'define expand-define)
   
   ;; define-inline
   (install-compiler-expander 'define-inline expand-inline)

   ;; define-generic
   (install-compiler-expander 'define-generic expand-generic)

   ;; define-method
   (install-compiler-expander 'define-method expand-method)
   
   ;; define-struct
   (install-compiler-expander 'define-struct expand-struct)
   
   ;; set!
   (install-compiler-expander 'set! expand-set!)

   ;; set-exit
   (install-compiler-expander 'set-exit expand-set-exit)

   ;; jump-exit
   (install-compiler-expander 'jump-exit expand-jump-exit)
   
   ;; bind-exit
   (install-compiler-expander 'bind-exit expand-bind-exit)

   ;; unwind-protect
   (install-compiler-expander 'unwind-protect expand-unwind-protect)
   
   ;; append
   (install-O-comptime-expander 'append
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?l1 ?l2)
				       `(append-2 ,(e l1 e) ,(e l2 e)))
				      ((?- . ?lists)
				       `(append
					 ,@(map (lambda (l) (e l e)) lists)))
				      (else
				       (error #f
					      "Illegal `append' form"
					      x)))))
   
   ;; string-append
   (install-O-comptime-expander 'string-append
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?s1 ?s2)
				       `(c-string-append ,(e s1 e)
							 ,(e s2 e)))
				      ((?- . ?lists)
				       `(string-append
					 ,@(map (lambda (l) (e l e)) lists)))
				      (else
				       (error #f
					      "Illegal 'string-append' form"
					      x)))))
   
   ;; cons
   (install-O-comptime-expander 'cons
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?fun ?a ?d)
				       `(cons ,(e a e) ,(e d e)))
				      (else
				       (error #f
					      "Illegal `cons' form"
					      x)))))
   
   ;; map
   (install-O-comptime-expander 'map expand-map)
   
   ;; for-each
   (install-O-comptime-expander 'for-each expand-for-each)
   
   ;; equal?
   (install-O-comptime-expander 'equal? (lambda (x::obj e::procedure)
					   (match-case x
					      ((?- ?a1 ?a2)
					       `(,(if (or (integer? a1)
							  (integer? a2)
							  (and (pair? a1)
							       (eq? (car a1)
								    'quote)
							       (symbol?
								(cadr a1)))
							  (and (pair? a2)
							       (eq? (car a2)
								    'quote)
							       (symbol?
								(cadr a2))))
						      'eq?
						      'equal?)
						 ,(e a1 e)
						 ,(e a2 e)))
					      (else
					       (error #f
						      "Illegal `equal?' form"
						      x)))))
   
   ;; les procedures arithmetiques
   (if *genericity*
       (begin
	  ;; +
	  (install-O-comptime-expander '+ expand-g+)
	  ;; *
	  (install-O-comptime-expander '* expand-g*)
	  ;; /
	  (install-O-comptime-expander '/ expand-g/)
	  ;; -
	  (install-O-comptime-expander '- expand-g-)
	  ;; =
	  (install-O-comptime-expander '= expand-g=)
	  ;; <
	  (install-O-comptime-expander '< expand-g<)
	  ;; >
	  (install-O-comptime-expander '> expand-g>)
	  ;; <=
	  (install-O-comptime-expander '<= expand-g<=)
	  ;; >=
	  (install-O-comptime-expander '>= expand-g>=))
       (begin
	  ;; +
	  (install-O-comptime-expander '+ expand-i+)
	  ;; *
	  (install-O-comptime-expander '* expand-i*)
	  ;; /
	  (install-O-comptime-expander '/ expand-i/)
	  ;; -
	  (install-O-comptime-expander '- expand-i-)
	  ;; =
	  (install-O-comptime-expander '= expand-i=)
	  ;; <
	  (install-O-comptime-expander '< expand-i<)
	  ;; >
	  (install-O-comptime-expander '> expand-i>)
	  ;; <=
	  (install-O-comptime-expander '<= expand-i<=)
	  ;; >=
	  (install-O-comptime-expander '>= expand-i>=)))
   
   ;; +fx
   (install-O-comptime-expander '+fx expand-+fx)
   
   ;; -fx
   (install-O-comptime-expander '-fx expand--fx)

   ;; maxfl
   (install-O-comptime-expander 'maxfl expand-fmax)

   ;; minfl
   (install-O-comptime-expander 'minfl expand-fmin)

   ;; atanfl
   (install-O-comptime-expander 'atanfl expand-fatan)

   ;; sqrtfl
   (install-O-comptime-expander 'sqrtfl
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?n)
				       (if *unsafe-range*
					   `(sqrtfl-ur ,(e n e))
					   `(sqrtfl ,(e n e))))
				      (else
				       (error #f
					      "Illegal `sqrtfl' call"
					      x)))))
   ;; atan-2fl
   (install-O-comptime-expander 'atan-2fl
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?n ?m)
				       (if *unsafe-range*
					   `(atan-2fl-ur ,(e n e) ,(e m e))
					   `(atan-2fl ,(e n e) ,(e m e))))
				      (else
				       (error #f
					      "Illegal `atan-2fl' call"
					      x)))))
   ;; let*
   (install-compiler-expander 'let* expand-let*)
   
   ;; let
   (install-compiler-expander 'let expand-let)
   
   ;; letrec
   (install-compiler-expander 'letrec expand-letrec)
   
   ;; labels
   (install-compiler-expander 'labels expand-labels)
   
   ;; case
   (install-compiler-expander 'case expand-case)
   
   ;; read
   (install-O-comptime-expander 'read
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?port)
				       `(read ,(e port e)))
				      ((?- ?port ?value)
				       `(read ,(e port e) ,(e value e)))
				      ((?-)
				       `(read (current-input-port)))
				      (else
				       (error #f
					      "Illegal `read' form"
					      x)))))
   
   ;; read/rp
   (install-O-comptime-expander 'read/rp
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?grammar ?port)
				       `(read/rp ,(e grammar e)
						 ,(e port e)))
				      (else
				       (error #f
					      "Illegal `read/rp' form"
					      x)))))
   
   ;; vector
   (install-O-comptime-expander 'vector
				(lambda (x::obj e::procedure)
				   (let ((args (cdr x))
					 (v    (gensym 'v)))
				      (e `(let ((,v (c-create-vector
						    ,(length args))))
					     ,@(let loop ((i    0)
							  (args args)
							  (res  '()))
						  (if (null? args)
						      res
						      (loop (+fx i 1)
							    (cdr args)
							    (cons
							     `(vector-set-ur!
							       ,v
							       ,i
							       ,(car args))
							     res))))
					     ,v)
					 e))))
   
   ;; make-vector
   (install-O-comptime-expander 'make-vector
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?n)
				       `(c-make-vector ,(e n e)
						       ,(e '(unspecified) e)))
				      ((?- ?n ?init)
				       `(c-make-vector ,(e n e)
						       ,(e init e)))
				      (else
				       (map (lambda (x) (e x e)) x)))))
   ;; vector-set!
   (install-O-comptime-expander 'vector-set!
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?vec ?k ?obj)
				       (let ((evec (e vec e))
					     (ek   (e k e))
					     (eobj (e obj e)))
					  (if *unsafe-range*
					      `(vector-set-ur! ,evec ,ek ,eobj)
					      `(vector-set! ,evec ,ek ,eobj))))
				      (else
				       (error #f
					      "Illegal `vector-set!' form"
					      x)))))
   
   ;; vector-ref
   (install-O-comptime-expander 'vector-ref
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?vec ?k)
				       (let ((evec (e vec e))
					     (ek   (e k e)))
					  (if *unsafe-range*
					      `(vector-ref-ur ,evec ,ek)
					      `(vector-ref ,evec ,ek))))
				      (else
				       (error #f
					      "Illegal `vector-ref' form"
					      x)))))
   
   ;; substring
   (install-O-comptime-expander 'substring
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?s ?min ?max)
				       (let ((s   (e s e))
					     (min (e min e))
					     (max (e max e)))
					  (if *unsafe-range*
					      `(substring-ur ,s ,min ,max)
					      `(substring ,s ,min ,max))))
				      (else
				       (error #f
					      "Illegal `substring' form"
					      x)))))

   ;; string-set!
   (install-O-comptime-expander 'string-set!
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?vec ?k ?obj)
				       (let ((evec (e vec e))
					     (ek   (e k e))
					     (eobj (e obj e)))
					  (if *unsafe-range*
					      `(string-set-ur! ,evec ,ek ,eobj)
					      `(string-set! ,evec ,ek ,eobj))))
				      (else
				       (error #f
					      "Illegal `string-set!' form"
					      x)))))
   
   ;; string-ref
   (install-O-comptime-expander 'string-ref
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?vec ?k)
				       (let ((evec (e vec e))
					     (ek   (e k e)))
					  (if *unsafe-range*
					      `(string-ref-ur ,evec ,ek)
					      `(string-ref ,evec ,ek))))
				      (else
				       (error #f
					      "Illegal `string-ref' form"
					      x)))))

   ;; blit-string!
   (install-O-comptime-expander 'blit-string!
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?s1 ?o1 ?s2 ?o2 ?l)
				       (let ((s1 (e s1 e))
					     (o1 (e o1 e))
					     (s2 (e s2 e))
					     (o2 (e o2 e))
					     (l  (e l e)))
					  (if *unsafe-range*
					      `(blit-string-ur! ,s1
								,o1
								,s2
								,o2
								,l)
					      `(blit-string! ,s1
							     ,o1
							     ,s2
							     ,o2
							     ,l))))
				      (else
				       (error #f
					      "Illegal `blit-string!' form"
					      x)))))
   ;; integer->char
   (install-O-comptime-expander 'integer->char
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?n)
				       (if *unsafe-range*
					   `(integer->char-ur ,(e n e))
					   `(integer->char ,(e n e))))
				      (else
				       (error #f
					      "Illegal `integer->char' call"
					      x)))))
   
   ;; apply
   (install-O-comptime-expander 'apply
				(lambda (x::obj e::procedure)
				   (match-case x
				      ((?- ?function ?one-arg)
				       `(apply ,(e function e)
					       ,(e one-arg e)))
				      ((?- ?function . ?args)
				       `(apply ,(e function e)
					       ,(e `(cons* ,@args) e)))
				      (else
				       (error #f
					      "Illegal `apply' form"
					      x)))))
   
   ;; values
   (install-O-comptime-expander
    'values
    (lambda (x e)
       (match-case x
	  ((?-)
	   '(set! (@ *res-number* __r5_control_features_6_4) 0))
	  ((?- ?val0)
	   (let ((g0 (gensym 'val0-)))
	      `(let ((,g0 ,(e val0 e)))
		  (set! (@ *res-number* __r5_control_features_6_4) 1)
		  ,g0)))
	  ((?- ?val0 ?val1)
	   (let ((g0 (gensym 'val0-))
		 (g1 (gensym 'val1-)))
	      `(let ((,g0 ,(e val0 e))
		     (,g1 ,(e val1 e)))
		  (set! (@ *res-number* __r5_control_features_6_4) 2)
		  (set! (@ *res1* __r5_control_features_6_4) ,g1)
		  ,g0)))
	  ((?- ?val0 ?val1 ?val2)
	   (let ((g0 (gensym 'val0-))
		 (g1 (gensym 'val1-))
		 (g2 (gensym 'val2-)))
	      `(let ((,g0 ,(e val0 e))
		     (,g1 ,(e val1 e))
		     (,g2 ,(e val2 e)))
		  (set! (@ *res-number* __r5_control_features_6_4) 3)
		  (set! (@ *res1* __r5_control_features_6_4) ,g1)
		  (set! (@ *res2* __r5_control_features_6_4) ,g2)
		  ,g0)))
	  ((?- ?val0 ?val1 ?val2 ?val3)
	   (let ((g0 (gensym 'val0-))
		 (g1 (gensym 'val1-))
		 (g2 (gensym 'val2-))
		 (g3 (gensym 'val3)))
	      `(let ((,g0 ,(e val0 e))
		     (,g1 ,(e val1 e))
		     (,g2 ,(e val2 e))
		     (,g3 ,(e val3 e)))
		  (set! (@ *res-number* __r5_control_features_6_4) 4)
		  (set! (@ *res1* __r5_control_features_6_4) ,g1)
		  (set! (@ *res2* __r5_control_features_6_4) ,g2)
		  (set! (@ *res3* __r5_control_features_6_4) ,g3)
		  ,g0)))
	  (else
	   (let ((g0 (gensym 'val-)))
	      `(let ((,g0 (list ,@(map (lambda (x) (e x e)) (cdr x)))))
		  (set! (@ *res-number* __r5_control_features_6_4) -1)
		  ,g0))))))

   ;; call-with-values
   (install-O-comptime-expander
    'call-with-values
    (lambda (x e)
       (e (match-case x
	     ((?- ?producer (lambda () . ?body))
	      `(begin
		  ,(match-case producer
		      ((lambda () . ?prod)
		       `(begin ,@prod))
		      (else
		       `(,producer)))
		  ,@body))
	     ((?- ?producer (lambda (?v0) . ?body))
	      `(let ((,v0 ,(match-case producer
			      ((lambda () . ?prod)
			       `(begin ,@prod))
			      (else
			       `(,producer)))))
		  ,@body))
	     ((?- ?producer (lambda (?v0 ?v1) . ?body))
	      `(let ((,v0 ,(match-case producer
			      ((lambda () . ?prod)
			       `(begin ,@prod))
			      (else
			       `(,producer)))))
		  (let ((,v1 (@ *res1* __r5_control_features_6_4)))
		     ,@body)))
	     ((?- ?producer (lambda (?v0 ?v1 ?v2) . ?body))
	      `(let ((,v0 ,(match-case producer
			      ((lambda () . ?prod)
			       `(begin ,@prod))
			      (else
			       `(,producer)))))
		  (let ((,v1 (@ *res1* __r5_control_features_6_4))
			(,v2 (@ *res2* __r5_control_features_6_4)))
		     ,@body)))
	     ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3) . ?body))
	      `(let ((,v0 ,(match-case producer
			      ((lambda () . ?prod)
			       `(begin ,@prod))
			      (else
			       `(,producer)))))
		  (let ((,v1 (@ *res1* __r5_control_features_6_4))
			(,v2 (@ *res2* __r5_control_features_6_4))
			(,v3 (@ *res3* __r5_control_features_6_4)))
		     ,@body)))
	     (else
	      `((@ call-with-values __r5_control_features_6_4) ,@(cdr x))))
	  e)))

   ;; assert
   (install-compiler-expander 'assert expand-assert)

   ;; with-access
   (install-compiler-expander 'with-access expand-with-access)

   ;; instantiate
   (install-compiler-expander 'instantiate expand-instantiate)

   ;; duplicate
   (install-compiler-expander 'duplicate expand-duplicate)

   ;; widen!
   (install-compiler-expander 'widen! expand-widen!)

   ;; shrink!
   (install-compiler-expander 'shrink! expand-shrink!))
			 
					
 

