;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Module/main.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 11:51:01 1996                          */
;*    Last change :  Thu Aug 21 09:09:55 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The main clause compilation.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_main
   (import module_module
	   tools_error
	   type_type
	   type_cache
	   ast_var
	   ast_env)
   (export (make-main-compiler)))

;*---------------------------------------------------------------------*/
;*    make-main-compiler ...                                           */
;*    -------------------------------------------------------------    */
;*    We don't need a checksum for main clauses because, for each      */
;*    main clause, an export clause has been generated. This export    */
;*    clause will be naturally checksummed.                            */
;*---------------------------------------------------------------------*/
(define (make-main-compiler)
   (instantiate::ccomp (id 'main)
		       (producer main-producer)
		       (consumer main-consumer)))

;*---------------------------------------------------------------------*/
;*    correct-main? ...                                                */
;*    -------------------------------------------------------------    */
;*    A main is a function, which has exactly one argument of          */
;*    type `obj' or `pair'.                                            */
;*---------------------------------------------------------------------*/
(define (correct-main?::bool global::global)
   (let ((sfun (global-value global)))
      (and (sfun? sfun)
	   (=fx (sfun-arity sfun) 1)
	   (let* ((args (car (sfun-args sfun)))
		  (type (local-type args)))
	      (or (eq? type *obj*) (eq? type *pair*))))))

;*---------------------------------------------------------------------*/
;*    main-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (main-producer clause)
   (if (or (eq? *main* 'imported) (global? *main*))
       (duplicate-main-error clause)
       (match-case clause
	  ((?- (and (? symbol?) ?main))
	   (let ((global (find-global main *module*)))
	      (if (global? global)
		  (if (not (correct-main? global))
		      (user-error *module*
				  "Illegal declaration of main function"
				  main
				  '()))
		  (begin
		     (produce-module-clause! `(export (,main argv::pair)))
		     (set! *main* (find-global main *module*))))))
	  (else
	   (user-error "Parse error" "Illegal main clause" clause '())))))

;*---------------------------------------------------------------------*/
;*    main-consumer ...                                                */
;*---------------------------------------------------------------------*/
(define (main-consumer module clause)
   (if (global? *main*)
       (duplicate-main-error clause)
       (set! *main* 'imported))
   '())

;*---------------------------------------------------------------------*/
;*    duplicate-main-error ...                                         */
;*---------------------------------------------------------------------*/
(define (duplicate-main-error clause)
   (user-error "Parse error" "Duplicated main clause" clause '()))

