;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/error.scm                    */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 16 15:41:47 1993                          */
;*    Last change :  Wed Sep 10 09:38:32 1997 (serrano)                */
;*                                                                     */
;*    On test le fonctionnement des `error-handler'                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module error
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-error)))

;*---------------------------------------------------------------------*/
;*    gee ...                                                          */
;*---------------------------------------------------------------------*/
(define (gee x)
   (if x
       '()
       1))

;*---------------------------------------------------------------------*/
;*    handler ...                                                      */
;*---------------------------------------------------------------------*/
(define (handler a b c d)
   (a #f))

;*---------------------------------------------------------------------*/
;*    try-test ...                                                     */
;*---------------------------------------------------------------------*/
(define (try-test)
   (let ((handler1
	  (lambda (w x y z) (w #t)))
	 (handler2
	  (lambda (w x y z) (w #f))))
      (try
       (begin
	  (try
	   (error 'error 1 1)
	   handler2)
	  (error 'error 2 2))
       handler1)))

;*---------------------------------------------------------------------*/
;*    side-effect ...                                                  */
;*---------------------------------------------------------------------*/
(define (side-effect x)
   (let ((y x))
      (try (begin
	      (set! y 7)
	      (error 1 2 3)
	      4)
	   (lambda (a b c d)
	      (a 3)))))

;*---------------------------------------------------------------------*/
;*    error-port ...                                                   */
;*---------------------------------------------------------------------*/
(define (error-port)
   (let ((p (open-output-string)))
      (with-error-to-port p
			  (lambda ()
			     (display 5 (current-error-port))))
      (close-output-port p)))

;*---------------------------------------------------------------------*/
;*    test-error ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-error)
   (test-module "error" "error.scm" #t)
   (test "type error (car)" (try (car (gee #f)) handler) #f)
   (test "type error (integer)" (try (=fx (gee #f) 7) handler) #f)
   (test "type error (string)" (try (string-ref (gee #f) (gee #f)) handler) #f)
   (test "type error" (try (integer? (string-length (gee #f))) handler) #f)
   (test "type error" (try (pair? (string-length (gee #f))) handler) #f)
   (test "try" (try-test) #t)
   (test "side effect" (side-effect 3) 3)
   (test "error port" (error-port) "5"))
