;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;; ---------------------------------------------------------------------- ;;
;; FICHIER               : gen.scm                                        ;;
;; DATE DE CREATION      : Mon Jul  3 14:04:24 1995                       ;;
;; DERNIERE MODIFICATION : Tue Jul  4 13:40:53 1995                       ;;
;; ---------------------------------------------------------------------- ;;
;; Copyright (c) 1995 Dominique Boucher                                   ;;
;; ---------------------------------------------------------------------- ;;
;; Gnration du code ...                                                 ;;
;; ---------------------------------------------------------------------- ;;

(module __Lalr_gen
   
	(include "Lalr/lalr.sch")

	(import (__error                   "Llib/error.scm")
		(__lalr_global             "Lalr/global.scm")
		(__lalr_rewrite            "Lalr/rewrite.scm"))
	
	(import (__type                    "Llib/type.scm")
		(__bigloo                  "Llib/bigloo.scm")
		(__tvector                 "Llib/tvector.scm")
		(__structure               "Llib/struct.scm")
		(__tvector                 "Llib/tvector.scm")
		(__rgc                     "Rgc/runtime.scm")
		(__r4_numbers_6_5          "Ieee/number.scm")
		(__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
		(__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
		(__r4_characters_6_6       "Ieee/char.scm")
		(__r4_equivalence_6_2      "Ieee/equiv.scm")
		(__r4_booleans_6_1         "Ieee/boolean.scm")
		(__r4_symbols_6_4          "Ieee/symbol.scm")
		(__r4_strings_6_7          "Ieee/string.scm")
		(__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
		(__r4_input_6_10_2         "Ieee/input.scm")
		(__r4_control_features_6_9 "Ieee/control.scm")
		(__r4_vectors_6_8          "Ieee/vector.scm")
		(__r4_ports_6_10_1         "Ieee/port.scm")
		(__r4_output_6_10_3        "Ieee/output.scm")
		(__evenv                   "Eval/evenv.scm"))

	(export (gen-lalr-code)))

(define (gen-lalr-code)
  `(LET* (,(gen-action-table)
	  ,(gen-goto-table)
	  ,(gen-reduction-table))
     (__MAKE-PARSER __ACTION-TABLE __REDUCE)))


(define (gen-action-table)
  (define (actions)
    (let loop-a ((i 0))
      (if (= i nstates)
	  '()
	  (cons
	   (let loop ((l (vector-ref action-table i)))
	     (if (null? l)
		 '()
		 (let* ((p (car l)) (x (car p)) (y (cdr p)))
		   (cons
		    (cons
		     (if (integer? x) (vector-ref *symv* (+fx nvars x)) x)
		     y)
		    (loop (cdr l))))))
	   (loop-a (+fx i 1))))))

  `(__ACTION-TABLE '#(,@(actions))))

(define (gen-goto-table)
  (define (gotos)
    (let loop-g ((i 0))
      (if (= i nstates)
	  '()
	  (cons 
	   (let ((shifts (vector-ref shift-table i)))
	     (if shifts
		 (let loop ((l (shift-shifts shifts)))
		   (if (null? l)
		       '()
		       (let* ((state (car l))
			      (symbol (vector-ref acces-symbol state)))
			 (if (<fx symbol nvars)
			     (cons
			      `(,(vector-ref *symv* symbol) . ,state)
			      (loop (cdr l)))
			     (loop (cdr l))))))
		 '()))
	   (loop-g (+fx i 1))))))
  
  `(__GOTO-TABLE '#(,@(gotos))))

(define (gen-reduction-table)
  (define (bindings rhs act n) 
    (let loop ((i n) (l rhs))
      (if (null? l)
	  '()
	  (let ((sym (car l)))
	    (cons
	     `(,(if (pair? sym) (cdr sym) sym)
	       (VECTOR-REF-UR __STACK (-fx __SP ,(-fx (*fx i 2) 1))))
	     (loop (-fx i 1) (cdr l)))))))
  
  (define (action nt n act)
    (if (eq? nt '*start*)
	(vector-ref *symv* 1)
	`(__PUSH __STACK (-fx __SP ,(*fx 2 n)) 
	       ',nt
	       __GOTO-TABLE
	       (LET () ,@act))))

  (define (reductions)
    (let loop-l ((l grammar) (no 1))
      (if (null? l)
	  '()
	  (let* ((def (car l))
		 (nt (car def)))
	    (let loop-p ((prods (cdr def)) (no no))
	      (if (null? prods)
		  (loop-l (cdr l) no)
		  (let* ((rhs (caar prods)) (act (cdar prods)) (n (length rhs)))
		    (cons 
		     (list
		      (list no)
		      `(LET (,@(bindings rhs act n))
			  ,(action nt n act)))
		     (loop-p (cdr prods) (+fx no 1))))))))))
  
  
  `(__REDUCE (LAMBDA (N __STACK __SP) 
	       (CASE N
		 ,@(reductions)))))
