;; ---------------------------------------------------------------------- ;;
;! @file     utils.scm                                                    !;
;! @created  Fri Jun 20 13:46:20 1997                                     !;
;! @modified Thu Mar  5 15:36:53 1998                                     !;
;; ---------------------------------------------------------------------- ;;
;! @copyright Dominique Boucher                                           !;
;; ---------------------------------------------------------------------- ;;
;; Utilities                                                              ;;
;; ---------------------------------------------------------------------- ;;

(module utils
	(export 
	 (filter pred? lst)
	 (sort lst pred)
	 (flatten lst)))

;; ---------------------------------------------------------------------- ;;
;; The filter function                                                    ;;
;; ---------------------------------------------------------------------- ;;
(define (filter p? lst)
  (if (null? lst)
      '()
      (let ((fst (car lst)))
	(if (p? fst)
	    (cons fst (filter p? (cdr lst)))
	    (filter p? (cdr lst))))))

;; ---------------------------------------------------------------------- ;;
;; List flattening                                                        ;;
;; ---------------------------------------------------------------------- ;;
(define (flatten lst)
  (cond
   ((null? lst)
    '())
   ((pair? lst)
    (let ((fst (car lst))
	  (rst (flatten (cdr lst))))
      (if (pair? fst)
	  (append (flatten fst) rst)
	  (cons fst rst))))
   (else
    lst)))
  

;; ---------------------------------------------------------------------- ;;
;; Sorting function (very inefficient)                                    ;;
;; ---------------------------------------------------------------------- ;;
(define (sort lst less-than)
  (define (insert elt lst)
    (if (null? lst)
	(list elt)
	(let ((elt1 (car lst)))
	  (if (less-than elt elt1)
	      (cons elt lst)
	      (cons elt1 (insert elt (cdr lst)))))))
  
  (let loop ((l lst) (res '()))
    (if (null? l)
	res
	(loop (cdr l) (insert (car l) res)))))
