/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** indxMap.h
*/

# ifndef INDXMAP_H
# define INDXMAP_H

/*@constant int INDXMAP_BASESIZE; @*/
# define INDXMAP_BASESIZE 32

typedef struct _indxMap
{
  int entries;
  int *map;
} *indxMap ;

extern /*@unused@*/ /*@only@*/ cstring indxMap_unparse (indxMap p_map);
extern int indxMap_map (indxMap p_map, int p_i);
extern void indxMap_addpair (indxMap p_map, int p_from, int p_to) /*@modifies p_map@*/;
extern /*@only@*/ indxMap indxMap_create (void) /*@*/ ;
extern int indxMap_mapSafe (indxMap p_map, int p_i) /*@*/ ;
extern void indxMap_free (/*@only@*/ indxMap p_map);

# else
# error "Multiple include"
# endif
