/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** paramNode.h
*/

# ifndef PARAMNODEH
# define PARAMNODEH

typedef enum _paramtype { PNORMAL, PYIELD, PELIPSIS } paramkind ;  
/* add PREF later?   PYIELD is for iterators only (~ POUT) */

typedef struct _paramNode {
  /*@null@*/ lclTypeSpecNode type;
  /*@null@*/ struct _typeExpr *paramdecl;
  paramkind kind;
} *paramNode;

extern void paramNode_free (/*@only@*/ /*@null@*/ paramNode p_x);

extern /*@null@*/ paramNode paramNode_copy (/*@null@*/ paramNode p_p);
extern /*@only@*/ cstring paramNode_unparse (paramNode p_x);
extern /*@only@*/ cstring paramNode_unparseComments (paramNode p_x);

extern bool paramNode_isElipsis (paramNode p_p);
extern bool paramNode_isYield (paramNode p_p);

# define paramNode_isElipsis(p) ((p)->kind == PELIPSIS)
# define paramNode_isYield(p) ((p)->kind == PYIELD)

# else
# error "Multiple include"
# endif


