/*;-*-C-*-;
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
**	 Copyright (c) Massachusetts Institute of Technology, 1993
**	    All Rights Reserved.  Unpublished rights reserved
**	    under the copyright laws of the United States.
**++
**  FACILITY:  LSLC
**
**  MODULE DESCRIPTION:
**
**      FILENAME: llgramar.y
**
**	PURPOSE:  bison grammar for LCL language.
** 
**  AUTHORS:
**	Yang Meng Tan, Massachusetts Institute of Technology
*/

%{

# include "bison.reset"

# include "lclintMacros.nf"
# include "llbasic.h"
# include "lclscan.h"
# include "checking.h"
# include "lslparse.h" 
# include "lh.h"
# include "usymtab_interface.h"

/*@-noparams@*/
static /*@unused@*/ void yyprint ();
/*@=noparams@*/

/*@-redecl@*/
void ylerror (char *s) /*@modifies *g_msgstream@*/ ;
/*@=redecl@*/

bool inTypeDef = FALSE;

/*@constant int YYDEBUG;@*/
# define YYDEBUG 1

/*@notfunction@*/
# define YYPRINT(file, type, value) yyprint (file, type, value)

# include "bison.head"

%}

%union 
{
  ltoken ltok;  /* a leaf is also an ltoken */
  qual typequal;
  unsigned int count;
  /*@only@*/ ltokenList ltokenList;
  /*@only@*/ abstDeclaratorNode abstDecl; 
  /*@only@*/ declaratorNode declare;
  /*@only@*/ declaratorNodeList declarelist;
  /*@only@*/ typeExpr typeexpr;
  /*@only@*/ arrayQualNode array;
  /*@only@*/ quantifierNode quantifier;
  /*@only@*/ quantifierNodeList quantifiers;
  /*@only@*/ varNode var;
  /*@only@*/ varNodeList vars;
  /*@only@*/ storeRefNode storeref;
  /*@only@*/ storeRefNodeList storereflist;
  /*@only@*/ termNode term;
  /*@only@*/ termNodeList termlist;
  /*@only@*/ programNode program; 
  /*@only@*/ stmtNode stmt;
  /*@only@*/ claimNode claim;
  /*@only@*/ typeNode type;
  /*@only@*/ iterNode iter;
  /*@only@*/ fcnNode fcn;
  /*@only@*/ fcnNodeList fcns;
  /*@only@*/ letDeclNode letdecl;
  /*@only@*/ letDeclNodeList letdecls;
  /*@only@*/ lclPredicateNode lclpredicate;
  /*@only@*/ modifyNode modify;
  /*@only@*/ paramNode param;
  /*@only@*/ paramNodeList paramlist;
  /*@only@*/ declaratorInvNodeList declaratorinvs;	
  /*@only@*/ declaratorInvNode declaratorinv;	
  /*@only@*/ abstBodyNode abstbody;
  /*@only@*/ abstractNode abstract;
  /*@only@*/ exposedNode exposed;
  /*    taggedUnionNode taggedunion; */
  /*@only@*/ globalList globals;
  /*@only@*/ constDeclarationNode constdeclaration;
  /*@only@*/ varDeclarationNode vardeclaration;
  /*@only@*/ varDeclarationNodeList vardeclarationlist;
  /*@only@*/ initDeclNodeList initdecls;
  /*@only@*/ initDeclNode initdecl;
  /*@only@*/ stDeclNodeList structdecls;
  /*@only@*/ stDeclNode structdecl;
  /*@only@*/ strOrUnionNode structorunion;
  /*@only@*/ enumSpecNode enumspec; 
  /*@only@*/ lclTypeSpecNode lcltypespec;
  /*@only@*/ typeNameNode typename;
  /*@only@*/ opFormNode opform;
  /*@only@*/ sigNode signature;
  /*@only@*/ nameNode name;
  /*@only@*/ typeNameNodeList namelist;
  /*@only@*/ replaceNode replace;	
  /*@only@*/ replaceNodeList replacelist;
  /*@only@*/ renamingNode renaming;
  /*@only@*/ traitRefNode traitref;
  /*@only@*/ traitRefNodeList traitreflist;
  /*@only@*/ importNode import;
  /*@only@*/ importNodeList importlist;
  /*@only@*/ interfaceNode interface;
  /*@only@*/ interfaceNodeList interfacelist; 
  /*@only@*/ CTypesNode ctypes;
}

/* Order of precedence is increasing going down the list */

%left     simpleOp
%right    PREFIX_OP 
%left     POSTFIX_OP 
%left     MULOP    
  /* as arithmetic binary operator, or as iteration construct in claims */
%left     SEMI
%left     VERTICALBAR
%nonassoc ITERATION_OP /* two * cannot follow each other */
%right    UNARY        /* when MULOP is used as an address-content operator */
%left     LPAR LBRACKET selectSym 
  /* to allow mixing if-then-else with other kinds of terms */
%left     IF_THEN_ELSE 
%left     logicalOp

/* Note: the grammar parses b = p /\ q as (b = p) /\ q, that is,
    = has higher precedence than logicalOp.  
   Reminder: = > logicalOp >= if_then_else > == (present in LSL) */

/* Precedence of claim operators: ( > * > | >; (| and; left-assoc) */

/* These are not needed in the grammar, 
   but needed in init files and lclscanline.c */

%token <ltok> eqSepSym          /* \eqsep */
%token <ltok> equationSym     /* \equals or == */
%token <ltok> commentSym        /* \comment */
%token <ltok> WHITESPACE
%token <ltok> LLT_EOL  /*@-varuse@*/  /* yacc declares yytranslate here */
/* used to bypass parsing problems in C types */
%token <ltok> TYPEDEF_NAME /*@=varuse@*/

/* LSL reserved extension symbols */

%token <ltok> quantifierSym     /* \forall */
%token <ltok> logicalOp         /* \implies, \and, \not, \or */
%token <ltok> selectSym         /* \select */
%token <ltok> openSym           /* \( */
%token <ltok> closeSym          /* \) */
%token <ltok> sepSym            /* \, */

%token <ltok> simpleId          /* \: id-char +, Ordinary Identifier */
%token <ltok> mapSym            /* \arrow, -> */
%token <ltok> markerSym         /* \marker, __ */
%token <ltok> preSym            /* \pre */
%token <ltok> postSym           /* \post */
%token <ltok> anySym            /* \any */

/* Generic LSL operators */

%token <ltok> simpleOp          /* opSym - reserved */

/* Reserved special symbols */

%token <ltok> COLON              /* : */
%token <ltok> COMMA              /* , */
%token <ltok> LLT_EQUALS             /* = */
%token <ltok> LBRACE             /* { */
%token <ltok> RBRACE             /* } */
%token <ltok> LBRACKET           /* [ */
%token <ltok> RBRACKET           /* ] */
%token <ltok> LPAR               /* ( */
%token <ltok> RPAR               /* ) */
%token <ltok> QUOTE              /* ' */
%token <ltok> SEMI               /*; */
%token <ltok> VERTICALBAR        /* | */

/* C operator tokens and Combined C/LSL operator tokens */

%token <ltok> eqOp                /* \eq, \neq, ==, != */
%token <ltok> MULOP               /* * */

/* LCL C literal tokens */

%token <ltok> CCHAR
%token <ltok> CFLOAT
%token <ltok> CINTEGER
%token <ltok> LCSTRING

/* LCL reserved words */

%token <ltok> ALL
%token <ltok> ANYTHING
%token <ltok> BE
%token <ltok> BODY
%token <ltok> CLAIMS
%token <ltok> CHECKS
%token <ltok> CONSTANT
%token <ltok> LLT_ELSE
%token <ltok> LLT_ENSURES
%token <ltok> FOR
%token <ltok> FRESH
%token <ltok> IF
%token <ltok> IMMUTABLE
%token <ltok> IMPORTS
%token <ltok> CONSTRAINT /* was INVARIANT */
%token <ltok> ISSUB
%token <ltok> LET
%token <ltok> MODIFIES
%token <ltok> MUTABLE
%token <ltok> NOTHING
%token <ltok> INTERNAL
%token <ltok> FILESYS
%token <ltok> OBJ
%token <ltok> OUT
%token <ltok> SEF
%token <ltok> ONLY PARTIAL OWNED DEPENDENT KEEP KEPT TEMP 
%token <ltok> SHARED UNIQUE LLT_UNUSED
%token <ltok> LLT_EXITS MAYEXIT NEVEREXIT TRUEEXIT FALSEEXIT
%token <ltok> LLT_UNDEF LLT_KILLED
%token <ltok> CHECKMOD CHECKED UNCHECKED CHECKEDSTRICT
%token <ltok> TRUENULL
%token <ltok> FALSENULL
%token <ltok> LNULL
%token <ltok> LNOTNULL
%token <ltok> RETURNED
%token <ltok> OBSERVER
%token <ltok> LLT_EXPOSED
%token <ltok> REFCOUNTED
%token <ltok> REFS
%token <ltok> RELNULL
%token <ltok> RELDEF
%token <ltok> KILLREF
%token <ltok> TEMPREF
%token <ltok> NEWREF
%token <ltok> PRIVATE
%token <ltok> REQUIRES
%token <ltok> RESULT
%token <ltok> SIZEOF
%token <ltok> SPEC
%token <ltok> TAGGEDUNION  /* keep it for other parts of LCL checker */
%token <ltok> THEN
%token <ltok> TYPE
%token <ltok> TYPEDEF
%token <ltok> UNCHANGED
%token <ltok> USES

/* LCL C keywords */

%token <ltok> CHAR
%token <ltok> CONST
%token <ltok> DOUBLE
%token <ltok> LLT_ENUM
%token <ltok> FLOAT
%token <ltok> INT
%token <ltok> ITER
%token <ltok> YIELD
%token <ltok> LONG
%token <ltok> SHORT
%token <ltok> LLT_SIGNED
%token <ltok> UNKNOWN
%token <ltok> STRUCT
%token <ltok> TELIPSIS
%token <ltok> UNION
%token <ltok> UNSIGNED
%token <ltok> VOID
%token <ltok> VOLATILE

%token <ltok> LLT_PRINTFLIKE LLT_SCANFLIKE LLT_MESSAGELIKE

%type <interfacelist> interface externals optDeclarations declarations
%type <interface> external declaration imports uses export private private2
%type <type> type 
%type <fcn> fcn
%type <fcns> fcns
%type <claim> claim 
%type <iter> iter
%type <vardeclaration> varDeclaration globalDecl privateInit 
%type <globals> globals
%type <ltokenList> interfaceNameList traitIdList domain sortList 
%type <import> importName
%type <importlist> importNameList
%type <traitreflist> traitRefNodeList 
%type <traitref> traitRef 
%type <renaming> renaming
%type <namelist> nameList 
%type <name> name 
%type <replacelist> replaceNodeList
%type <replace> replace
%type <opform> opForm
%type <signature> signature
%type <typename> typeName
%type <count> middle placeList pointers 
%type <abstDecl> optAbstDeclarator 
%type <lcltypespec> lclTypeSpec lclType sortSpec
%type <ltokenList> enumeratorList postfixOps
%type <ctypes> CTypes typeSpecifier
%type <structorunion> structOrUnionSpec 
%type <enumspec> enumSpec
%type <declare> declarator 
%type <typeexpr> notype_decl after_type_decl abstDeclarator parameter_decl 
%type <declarelist> declaratorList
%type <structdecls> structDecls 
%type <structdecl> structDecl
%type <constdeclaration> constDeclaration
%type <initdecls> initDecls 
%type <initdecl> initDecl 
%type <vardeclarationlist> privateInits
%type <abstract> abstract
%type <exposed> exposed 
%type <declaratorinvs> declaratorInvs
%type <declaratorinv> declaratorInv
%type <abstbody> abstBody optExposedBody 
%type <lclpredicate> optClaim optEnsure optRequire optChecks lclPredicate 
%type <lclpredicate> optTypeInv typeInv 
%type <modify> optModify
%type <letdecls> optLetDecl beDeclList 
%type <letdecl> beDecl 
%type <term> term constLclExpr initializer value equalityTerm 
%type <term> simpleOpTerm prefixOpTerm secondary primary lclPrimary 
%type <term> bracketed sqBracketed matched term0 cLiteral
%type <termlist> args infixOpPart valueList termList
%type <program> optBody callExpr
%type <stmt> stmt 
%type <storereflist> storeRefList 
%type <storeref> storeRef  
%type <var> quantified 
%type <vars> quantifiedList
%type <quantifier> quantifier 
%type <quantifiers> quantifiers
%type <array> arrayQual 
%type <paramlist> optParamList paramList realParamList iterParamList realIterParamList
%type <param> param iterParam
%type <ltok> open close anyOp separator simpleOp2 stateFcn 
%type <ltok> interfaceName 
%type <ltok> varId fcnId tagId claimId sortId traitId opId CType optTagId
%type <ltok> simpleIdOrTypedefName
%type <typequal> specialQualifier special

/*
** Conventions in calling static semantic routines:
**   The inputs are in strict order (in AST) as well as in the position of
**   the call to the static semantic routine. 
*/ 

%%

interface
 : externals { lhExternals ($1); } optDeclarations 
   { interfaceNodeList_free ($1); interfaceNodeList_free ($3); }

externals   
 : /* empty */        { $$ = interfaceNodeList_new (); }
 | externals external { $$ = interfaceNodeList_addh ($1, $2);}  

external
 : imports
 | uses

optDeclarations    
 : /* empty */              { $$ = interfaceNodeList_new (); }
 | export declarations      { $$ = consInterfaceNode ($1, $2);}  
 | private declarations     { $$ = consInterfaceNode ($1, $2);}  

declarations 
 : /* empty */              { $$ = interfaceNodeList_new (); }
 | declarations declaration { $$ = interfaceNodeList_addh ($1, $2);}  

declaration
 : export
 | private
 | uses 

imports   
 : IMPORTS importNameList SEMI 
   { $$ = makeInterfaceNodeImports ($2);
     /* assume subspecs are already processed, symbol table info in external file */
   }

uses   
 : USES traitRefNodeList SEMI  
   { $$ = makeInterfaceNodeUses ($2); readlsignatures ($$);}

export
 : constDeclaration
   { declareConstant ($1); $$ = interfaceNode_makeConst ($1); }
 | varDeclaration
   { declareVar ($1); $$ = interfaceNode_makeVar ($1); }
 | type
   { declareType ($1); $$ = interfaceNode_makeType ($1); }
 | fcn
   { declareFcn ($1, typeId_invalid); $$ = interfaceNode_makeFcn ($1); }
 | claim
   { $$ = interfaceNode_makeClaim ($1); }
 | iter
   { declareIter ($1); $$ = interfaceNode_makeIter ($1); }                              

iter 
 : ITER varId LPAR iterParamList RPAR SEMI
   { $$ = makeIterNode ($2, $4); }
 
iterParamList      
 : /* empty */         { $$ = paramNodeList_new (); }
 | realIterParamList   { $$ = $1; }
 
realIterParamList  
 : iterParam           
   { $$ = paramNodeList_add (paramNodeList_new (), $1); }
 | realIterParamList COMMA iterParam  
   { $$ = paramNodeList_add ($1,$3); }     
   
iterParam          
 : YIELD param            { $$ = markYieldParamNode ($2); }
 | param                  { $$ = $1; }

private   
 : SPEC { symtable_export (g_symtab, FALSE); } private2 
   { $$ = $3; symtable_export (g_symtab, TRUE); } 

private2 
 : constDeclaration
   { declarePrivConstant ($1); $$ =  interfaceNode_makePrivConst ($1); } 
 | varDeclaration
   { declarePrivVar ($1); $$ = interfaceNode_makePrivVar ($1); }
 | type 
   { declarePrivType ($1); $$ = interfaceNode_makePrivType ($1); }
 | fcn
   { declarePrivFcn ($1, typeId_invalid); $$ = interfaceNode_makePrivFcn ($1); }

constDeclaration   
 : CONSTANT lclTypeSpec initDecls SEMI
   { $$ = makeConstDeclarationNode ($2, $3); } 

varDeclaration    
 : lclTypeSpec initDecls SEMI
   { $$ = makeVarDeclarationNode ($1, $2, FALSE, FALSE); $$->qualifier = QLF_NONE; } 
 | CONST lclTypeSpec initDecls SEMI
   { $$ = makeVarDeclarationNode ($2, $3, FALSE, FALSE); $$->qualifier = QLF_CONST; } 
 | VOLATILE lclTypeSpec initDecls SEMI
   { $$ = makeVarDeclarationNode ($2, $3, FALSE, FALSE); $$->qualifier = QLF_VOLATILE; }

type
 : abstract                     { $$ = makeAbstractTypeNode ($1); } 
 | exposed                      { $$ = makeExposedTypeNode ($1); } 

special
 : LLT_PRINTFLIKE  { $$ = qual_createPrintfLike (); }
 | LLT_SCANFLIKE   { $$ = qual_createScanfLike (); }
 | LLT_MESSAGELIKE { $$ = qual_createMessageLike (); }

fcn   
 : lclTypeSpec declarator globals { enteringFcnScope ($1, $2, $3); } LBRACE
   privateInits optLetDecl optChecks optRequire optModify optEnsure optClaim RBRACE
   { $$ = makeFcnNode (qual_createUnknown (), $1, $2, $3, $6, $7, 
		       $8, $9, $10, $11, $12); 
     /* type, declarator, glovbls, privateinits,
	lets, checks, requires, modifies, ensures, claims */
     symtable_exitScope (g_symtab);
   }
 | special lclTypeSpec declarator globals { enteringFcnScope ($2, $3, $4); }
   LBRACE
   privateInits optLetDecl optChecks optRequire optModify optEnsure optClaim 
   RBRACE
   { $$ = makeFcnNode ($1, $2, $3, $4, $7, 
		       $8, $9, $10, $11, $12, $13); 
     /* type, declarator, glovbls, privateinits,
	lets, checks, requires, modifies, ensures, claims */
     symtable_exitScope (g_symtab);
   }


claim 
 : CLAIMS claimId LPAR optParamList RPAR globals
   { enteringClaimScope ($2, $4, $6); } 
   LBRACE optLetDecl optRequire optBody optEnsure RBRACE
   { $$ = makeClaimNode ($2, $4, $6, $9, $10, $11, $12); 
     symtable_exitScope (g_symtab); } 
 | CLAIMS fcnId claimId SEMI
   { $$ = (claimNode) 0; }

abstract
 : MUTABLE {inTypeDef = TRUE; } TYPE TYPEDEF_NAME {inTypeDef = FALSE; } abstBody
   { $$ = makeAbstractNode ($1, $4, TRUE, FALSE, $6); } 
 | MUTABLE {inTypeDef = TRUE; } REFCOUNTED TYPE 
   TYPEDEF_NAME {inTypeDef = FALSE; } abstBody
   { $$ = makeAbstractNode ($1, $5, TRUE, TRUE, $7); } 
 | REFCOUNTED MUTABLE {inTypeDef = TRUE; } TYPE 
   TYPEDEF_NAME {inTypeDef = FALSE; } abstBody
   { $$ = makeAbstractNode ($2, $5, TRUE, TRUE, $7); } 
 | IMMUTABLE {inTypeDef = TRUE; } TYPE TYPEDEF_NAME {inTypeDef = FALSE; } abstBody
   { $$ = makeAbstractNode ($1, $4, FALSE, FALSE, $6); } 

exposed
 : TYPEDEF lclTypeSpec { inTypeDef = TRUE; setExposedType ($2); } declaratorInvs
   { inTypeDef = FALSE; } SEMI
   { $$ = makeExposedNode ($1, $2, $4); /* to support mutually recursive types */ }
 | structOrUnionSpec SEMI
   { $$ = makeExposedNode ($2, makeLclTypeSpecNodeSU ($1), declaratorInvNodeList_new ()); }
 | enumSpec SEMI
   { $$ = makeExposedNode ($2, makeLclTypeSpecNodeEnum ($1), declaratorInvNodeList_new ()); }

/* evs - 26 Feb 1995 (changed to be consistent with C grammar)
 | STRUCT tagId SEMI
   { (void) checkAndEnterTag (TAG_FWDSTRUCT, ltoken_copy ($2));
     lhForwardStruct ($2); $$ = (exposedNode)0;
   }
 | UNION tagId SEMI
   { (void) checkAndEnterTag (TAG_FWDUNION, ltoken_copy ($2));
     lhForwardUnion ($2);
     $$ = (exposedNode)0; 
   }
*/

importNameList  
 : importName        
   { $$ = importNodeList_add (importNodeList_new (), $1); } 
 | importNameList COMMA importName  
   { $$ = importNodeList_add ($1, $3); } 

importName       
 : interfaceName      { $$ = importNode_makePlain ($1); }
 | simpleOp interfaceName simpleOp
   { checkBrackets ($1, $3); $$ = importNode_makeBracketed ($2); }
 | LCSTRING           { $$ = importNode_makeQuoted ($1); } 

interfaceNameList  
 : interfaceName                         { $$ = ltokenList_singleton ($1); } 
 | interfaceNameList COMMA interfaceName { $$ = ltokenList_push ($1, $3); }

interfaceName   
 : simpleIdOrTypedefName
   /* to allow module names to be the same as LCL type names */

traitRefNodeList   
 : traitRef
   { $$ = traitRefNodeList_add (traitRefNodeList_new (), $1); } 
 | traitRefNodeList COMMA traitRef
   { $$ = traitRefNodeList_add ($1, $3); } 

traitRef   
 : traitId
   { $$ = makeTraitRefNode (ltokenList_singleton ($1), (renamingNode)0); } 
 | traitId LPAR renaming RPAR
   { $$ = makeTraitRefNode (ltokenList_singleton ($1), $3); } 
 | LPAR traitIdList RPAR
   { $$ = makeTraitRefNode ($2, (renamingNode)0); } 
 | LPAR traitIdList RPAR LPAR renaming RPAR
   { $$ = makeTraitRefNode ($2, $5); } 

traitIdList   
 : traitId                     { $$ = ltokenList_singleton ($1); } 
 | traitIdList COMMA traitId   { $$ = ltokenList_push ($1, $3); } 

renaming   
 : replaceNodeList   
   { $$ = makeRenamingNode (typeNameNodeList_new (), $1); } 
 | nameList
   { $$ = makeRenamingNode ($1, replaceNodeList_new ()); } 
 | nameList COMMA replaceNodeList { $$ = makeRenamingNode ($1, $3); } 
 
nameList
 : typeName
   { $$ = typeNameNodeList_add (typeNameNodeList_new (), $1); } 
 | nameList COMMA typeName       { $$ = typeNameNodeList_add ($1, $3); } 

replaceNodeList   
 : replace
   { $$ = replaceNodeList_add (replaceNodeList_new (), $1); } 
 | replaceNodeList COMMA replace { $$ = replaceNodeList_add ($1, $3); } 

replace
 : typeName FOR CType            { $$ = makeReplaceNode ($2, $1, TRUE, $3, NULL, NULL); } 
 | typeName FOR name             { $$ = makeReplaceNameNode ($2, $1, $3); }
 | typeName FOR name signature   { $$ = makeReplaceNode ($2, $1, FALSE, ltoken_undefined,
							 $3, $4); } 

name    
 : opId                          { $$ = makeNameNodeId ($1); } 
 | opForm                        { $$ = makeNameNodeForm ($1); } 

initializer : constLclExpr

constLclExpr : term

initDecls
 : initDecl 
   { $$ = initDeclNodeList_add (initDeclNodeList_new (), $1); } 
 | initDecls COMMA initDecl      
   { $$ = initDeclNodeList_add ($1, $3); } 

initDecl  
 : declarator                    { $$ = makeInitDeclNode ($1, (termNode)0); } 
 | declarator LLT_EQUALS initializer { $$ = makeInitDeclNode ($1, $3); } 

globals   
 : /* empty */ /* has the same structure */
   { $$ = varDeclarationNodeList_new (); }
 | globals globalDecl
   { varDeclarationNodeList_addh ($1, $2); $$ = $1; }

globalDecl   
 : lclTypeSpec initDecls SEMI    { $$ = makeVarDeclarationNode ($1, $2, TRUE, FALSE); } 
 | INTERNAL SEMI                 { $$ = makeInternalStateNode (); }
 | FILESYS SEMI                  { $$ = makeFileSystemNode (); }

privateInits   
 : /* empty */                  { $$ = varDeclarationNodeList_new (); }
 | privateInits privateInit     { varDeclarationNodeList_addh ($1, $2); $$ = $1; }

privateInit   
 : PRIVATE lclTypeSpec initDecls SEMI
   { $$ = makeVarDeclarationNode ($2, $3, FALSE, TRUE); } 

optLetDecl   
 : /* empty */                 { $$ = letDeclNodeList_new (); }
 | LET beDeclList SEMI         { $$ = $2; } 

beDeclList   
 : beDecl                      { $$ = letDeclNodeList_add (letDeclNodeList_new (), $1); } 
 | beDeclList COMMA beDecl     { $$ = letDeclNodeList_add ($1, $3); } 

beDecl   
 : varId COLON sortSpec BE term { $$ = makeLetDeclNode ($1, $3, $5); } 
 | varId                BE term { $$ = makeLetDeclNode ($1, (lclTypeSpecNode)0, $3); } 

sortSpec : lclTypeSpec

optChecks   
 : /* empty */                  { $$ = (lclPredicateNode)0; }
 | CHECKS lclPredicate SEMI     { checkLclPredicate ($1, $2); $$ = makeChecksNode ($1, $2); }

optRequire
 : /* empty */                  { $$ = (lclPredicateNode)0; }
 | REQUIRES lclPredicate SEMI   { checkLclPredicate ($1, $2); $$ = makeRequiresNode ($1, $2);} 

optModify
 : /* empty */                  { $$ = (modifyNode)0; }
 | MODIFIES NOTHING SEMI        { $$ = makeModifyNodeSpecial ($1, TRUE); } 
 | MODIFIES ANYTHING SEMI       { $$ = makeModifyNodeSpecial ($1, FALSE); } 
 | MODIFIES storeRefList SEMI   { $$ = makeModifyNodeRef ($1, $2); } 

storeRefList   
 : storeRef                     { $$ = storeRefNodeList_add (storeRefNodeList_new (), $1); } 
 | storeRefList COMMA storeRef  { $$ = storeRefNodeList_add ($1, $3); } 

storeRef   
 : term                         { $$ = makeStoreRefNodeTerm ($1); } 
 | lclType                      { $$ = makeStoreRefNodeType ($1, FALSE); } 
 | OBJ lclType                  { $$ = makeStoreRefNodeType ($2, TRUE); } 
 | INTERNAL                     { $$ = makeStoreRefNodeInternal (); }
 | FILESYS                      { $$ = makeStoreRefNodeSystem (); }

optEnsure
 : /* empty */                  { $$ = (lclPredicateNode)0; }
 | LLT_ENSURES lclPredicate SEMI    { checkLclPredicate ($1, $2); $$ = makeEnsuresNode ($1, $2);} 

optClaim   
 : /* empty */                  { $$ = (lclPredicateNode)0; }
 | CLAIMS lclPredicate SEMI     { checkLclPredicate ($1, $2); $$ = makeIntraClaimNode ($1, $2);} 

optParamList       
 : /* empty */                  { $$ = paramNodeList_new (); }
 | realParamList                { $$ = $1; }

realParamList      
 : paramList
 | TELIPSIS                  { $$ = paramNodeList_add (paramNodeList_new (), paramNode_elipsis ()); }
 | paramList COMMA TELIPSIS  { $$ = paramNodeList_add ($1, paramNode_elipsis ()); }

paramList   
 : param                     { $$ = paramNodeList_single ($1); }
 | paramList COMMA param     { $$ = paramNodeList_add ($1, $3); } 

optBody
 : /* empty */                      { $$ = (programNode)0; }
 | BODY LBRACE callExpr RBRACE      { $$ = $3; } 
 | BODY LBRACE callExpr SEMI RBRACE { $$ = $3; } 

callExpr   
 : stmt                             { $$ = makeProgramNode ($1); } 
 | LPAR callExpr RPAR 
   /* may need to make a copy of $2 */
   { $$ = $2; $$->wrapped = $$->wrapped + 1; } 
 | callExpr MULOP        %prec ITERATION_OP
   { programNodeList x = programNodeList_new ();
     programNodeList_addh (x, $1);
     $$ = makeProgramNodeAction (x, ACT_ITER); 
   } 
 | callExpr VERTICALBAR callExpr  
   { programNodeList x = programNodeList_new ();
     programNodeList_addh (x, $1);
     programNodeList_addh (x, $3);
     $$ = makeProgramNodeAction (x, ACT_ALTERNATE); 
   } 
 | callExpr SEMI callExpr   
   { programNodeList x = programNodeList_new ();
     programNodeList_addh (x, $1);
     programNodeList_addh (x, $3);
     $$ = makeProgramNodeAction (x, ACT_SEQUENCE); 
   } 

stmt               
 : fcnId LPAR valueList RPAR 
   { $$ = makeStmtNode (ltoken_undefined, $1, $3); } 
 | fcnId LPAR RPAR
   { $$ = makeStmtNode (ltoken_undefined, $1, termNodeList_new ()); }
 | varId LLT_EQUALS fcnId LPAR RPAR
   { $$ = makeStmtNode ($1, $3, termNodeList_new ()); } 
 | varId LLT_EQUALS fcnId LPAR valueList RPAR
   { $$ = makeStmtNode ($1, $3, $5); }

valueList   
 : value                 { $$ = termNodeList_push (termNodeList_new (), $1); } 
 | valueList COMMA value { $$ = termNodeList_push ($1, $3); } 

value   
 : cLiteral
 | varId                            { $$ = makeSimpleTermNode ($1); } 
 | simpleOp value %prec PREFIX_OP   { $$ = makePrefixTermNode ($1, $2); } 
 | value simpleOp  %prec POSTFIX_OP { $$ = makePostfixTermNode2 ($1, $2); } 
 | value simpleOp value /* infix */ { $$ = makeInfixTermNode ($1, $2, $3); }
 | LPAR value RPAR                  { $$ = $2; $$->wrapped = $$->wrapped + 1; }
 | fcnId LPAR RPAR
   { $$ = makeOpCallTermNode ($1, $2, termNodeList_new (), $3); }
 | fcnId LPAR valueList RPAR
   { $$ = makeOpCallTermNode ($1, $2, $3, $4); } 

abstBody   
 : SEMI                                  { $$ = (abstBodyNode)0; } 
 | LBRACE fcns RBRACE                    { $$ = makeAbstBodyNode ($1, $2); }
 | LBRACE interfaceNameList RBRACE SEMI  { $$ = makeAbstBodyNode2 ($1, $2); }
 | LBRACE RBRACE SEMI                    { $$ = (abstBodyNode)0; }

fcns   
 : /* empty */                           { $$ = fcnNodeList_new (); }
 | fcns fcn                              { $$ = fcnNodeList_add ($1, $2); } 

optTypeInv   
 : /* empty */                           { $$ = (lclPredicateNode)0; }
 | typeInv

typeInv   
 : CONSTRAINT { inTypeDef = FALSE; } quantifier LPAR lclPredicate RPAR
   { $5->tok = $1; $5->kind = LPD_CONSTRAINT;
     checkLclPredicate ($1, $5);
     $$ = $5;
     symtable_exitScope (g_symtab); 
     inTypeDef = TRUE;
   }

declaratorInvs     
 : declaratorInv        { $$ = declaratorInvNodeList_add (declaratorInvNodeList_new (), $1); } 
 | declaratorInvs COMMA declaratorInv
   { $$ = declaratorInvNodeList_add ($1, $3); } 

declaratorInv      
 : declarator { declareForwardType ($1); } optExposedBody
   { $$ = makeDeclaratorInvNode ($1, $3); } 

optExposedBody   
 : /* empty */                  { $$ = (abstBodyNode)0; }
 | LBRACE optTypeInv RBRACE     { $$ = makeExposedBodyNode ($1, $2); }

CType   
 : VOID           { $$ = $1; ltoken_setIntField ($$, fixBits (TS_VOID, 0)); }
 | CHAR           { $$ = $1; ltoken_setIntField ($$, fixBits (TS_CHAR, 0)); }
 | DOUBLE         { $$ = $1; ltoken_setIntField ($$, fixBits (TS_DOUBLE, 0)); }
 | FLOAT          { $$ = $1; ltoken_setIntField ($$, fixBits (TS_FLOAT, 0)); }
 | INT            { $$ = $1; ltoken_setIntField ($$, fixBits (TS_INT, 0)); }
 | LONG           { $$ = $1; ltoken_setIntField ($$, fixBits (TS_LONG, 0)); }
 | SHORT          { $$ = $1; ltoken_setIntField ($$, fixBits (TS_SHORT, 0)); }
 | LLT_SIGNED         { $$ = $1; ltoken_setIntField ($$, fixBits (TS_SIGNED, 0)); }
 | UNSIGNED       { $$ = $1; ltoken_setIntField ($$, fixBits (TS_UNSIGNED, 0)); }
 | UNKNOWN        { $$ = $1; ltoken_setIntField ($$, fixBits (TS_UNKNOWN, 0)); }

/*
** CTypes allow "unsigned short int" but we drop all C type qualifiers 
** and storage class except TYPEDEF 
*/

CTypes   
 : CType                       { $$ = makeCTypesNode ((CTypesNode)0, $1); }
 | CTypes CType                { $$ = makeCTypesNode ($1, $2); } 

/* Add abstract type names and typedef names */

typeSpecifier   
 : TYPEDEF_NAME                
   { $$ = makeTypeSpecifier ($1); }
 | CTypes                      
   { $$ = $1; $$->sort = sort_lookupName (lclctype_toSort ($1->intfield)); } 

/* Add struct and enum types */

specialQualifier
 : OUT       { $$ = qual_createOut (); }
 | LLT_UNUSED { $$ = qual_createUnused (); } 
 | SEF       { $$ = qual_createSef (); }
 | ONLY      { $$ = qual_createOnly (); }
 | OWNED     { $$ = qual_createOwned (); }
 | DEPENDENT { $$ = qual_createDependent (); }
 | KEEP      { $$ = qual_createKeep (); }
 | KEPT      { $$ = qual_createKept (); }
 | OBSERVER  { $$ = qual_createObserver (); }
 | LLT_EXITS     { $$ = qual_createExits (); }
 | MAYEXIT   { $$ = qual_createMayExit (); }
 | TRUEEXIT  { $$ = qual_createTrueExit (); }
 | FALSEEXIT { $$ = qual_createFalseExit (); }
 | NEVEREXIT { $$ = qual_createNeverExit (); }
 | TEMP      { $$ = qual_createOnly (); }
 | SHARED    { $$ = qual_createShared (); }
 | UNIQUE    { $$ = qual_createUnique (); }
 | CHECKED   { $$ = qual_createChecked (); }
 | UNCHECKED { $$ = qual_createUnchecked (); }
 | CHECKEDSTRICT { $$ = qual_createCheckedStrict (); }
 | TRUENULL  { $$ = qual_createTrueNull (); }
 | FALSENULL { $$ = qual_createFalseNull (); }
 | RELNULL   { $$ = qual_createRelNull (); }
 | RELDEF    { $$ = qual_createRelDef (); }
 | REFCOUNTED{ $$ = qual_createRefCounted (); }
 | REFS      { $$ = qual_createRefs (); }
 | NEWREF    { $$ = qual_createNewRef (); }
 | KILLREF   { $$ = qual_createKillRef (); }
 | LNULL     { $$ = qual_createNull (); }
 | LNOTNULL  { $$ = qual_createNotNull (); }
 | RETURNED  { $$ = qual_createReturned (); }
 | LLT_EXPOSED   { $$ = qual_createExposed (); }
 | PARTIAL   { $$ = qual_createPartial (); }
 | LLT_UNDEF { $$ = qual_createUndef (); }
 | LLT_KILLED { $$ = qual_createKilled (); }

lclTypeSpec   
 : typeSpecifier                        
   { $$ = makeLclTypeSpecNodeType ($1); } /* does not process CONST at all */
 | structOrUnionSpec                    
   { $$ = makeLclTypeSpecNodeSU ($1); }
 | enumSpec                             
   { $$ = makeLclTypeSpecNodeEnum ($1); }
 | specialQualifier lclTypeSpec         
   { $$ = lclTypeSpecNode_addQual ($2, $1); }
 | VERTICALBAR lclType COLON lclType VERTICALBAR
   { $$ = makeLclTypeSpecNodeConj ($2, $4); } 

/* 
** Add pointers to the right, only used in StoreRef, maybe should throw
** out and replace its use in StoreRef by CTypeName 
*/

lclType     
 : lclTypeSpec 
 | lclTypeSpec pointers 
   { llassert (lclTypeSpecNode_isDefined ($1));
     $1->pointers = $2; $$ = $1; }

pointers   
 : MULOP          { $$ = 1; }
 | pointers MULOP { $$ = $1 + 1; } 

structOrUnionSpec  
 : STRUCT optTagId 
   { (void) checkAndEnterTag (TAG_FWDSTRUCT, ltoken_copy ($2)); } 
   LBRACE structDecls RBRACE
   { $$ = makestrOrUnionNode ($1, SU_STRUCT, $2, $5); }
 | UNION optTagId  
   { (void) checkAndEnterTag (TAG_FWDUNION, ltoken_copy ($2)); } 
   LBRACE structDecls RBRACE
   { $$ = makestrOrUnionNode ($1, SU_UNION, $2, $5); }
 | STRUCT tagId 
   { $$ = makeForwardstrOrUnionNode ($1, SU_STRUCT, $2); }
 | UNION tagId  
   { $$ = makeForwardstrOrUnionNode ($1, SU_UNION, $2); }

optTagId    
 : /* empty */ { $$ = ltoken_undefined; }
 | tagId

structDecls   
 : structDecl               { $$ = stDeclNodeList_add (stDeclNodeList_new (), $1); } 
 | structDecls structDecl   { $$ = stDeclNodeList_add ($1, $2); } 

/* We don't allow specification of field size */

structDecl   
 : lclTypeSpec declaratorList SEMI { $$ = makestDeclNode ($1, $2); } 

declaratorList   
 : declarator                       
   { $$ = declaratorNodeList_add (declaratorNodeList_new (), $1); } 
 | declaratorList COMMA declarator  
   { $$ = declaratorNodeList_add ($1, $3); } 

optCOMMA           
 : /* empty */ { ; }
 | COMMA       { ; }

enumSpec   
 : LLT_ENUM optTagId LBRACE enumeratorList optCOMMA RBRACE
   { $$ = makeEnumSpecNode ($1, $2, $4); } 
 | LLT_ENUM tagId
   { $$ = makeEnumSpecNode2 ($1, $2); } 

enumeratorList   
 : simpleId                             { $$ = ltokenList_singleton ($1); } 
 | enumeratorList COMMA simpleId        { $$ = ltokenList_push ($1, $3); } 

/* This part of declarator rules is adapted from GCC (2.2.1)'s C grammar */

/* An after_type_decl is a declarator that is allowed only after an explicit 
   typeSpecifier, an id can be typedef'd here.  
   A notype_decl is a declarator that may not have seen a typeSpecifier
   preceding it; it cannot typedef'd an id.  */

declarator   
 : after_type_decl                      { $$ = makeDeclaratorNode ($1); }
 | notype_decl                          { $$ = makeDeclaratorNode ($1); }

notype_decl    
 : varId                                { $$ = makeTypeExpr ($1); }
 | LPAR notype_decl RPAR                { $$ = $2; $$->wrapped = $$->wrapped + 1; } 
 | MULOP notype_decl /* %prec UNARY */  { $$ = makePointerNode ($1, $2); } 
 | notype_decl arrayQual                { $$ = makeArrayNode ($1, $2); } 
 | notype_decl LPAR RPAR                { $$ = makeFunctionNode ($1, paramNodeList_new ()); } 
 | notype_decl LPAR realParamList RPAR  { $$ = makeFunctionNode ($1, $3); }

after_type_decl    
 : TYPEDEF_NAME                             { $$ = makeTypeExpr ($1); }
 | LPAR after_type_decl RPAR                { $$ = $2; $$->wrapped = $$->wrapped + 1; }
 | MULOP after_type_decl /* %prec UNARY */  { $$ = makePointerNode ($1, $2); } 
 | after_type_decl arrayQual                { $$ = makeArrayNode ($1, $2); } 
 | after_type_decl LPAR RPAR                { $$ = makeFunctionNode ($1, paramNodeList_new ()); } 
 | after_type_decl LPAR realParamList RPAR  { $$ = makeFunctionNode ($1, $3); }

/* A parameter_decl is a decl that can appear in a parameter list.  
   We disallow the old C way of giving only the id names without types.
   A parameter_decl is like an after_type_decl except that it does not
   allow a TYPEDEF_NAME to appear in parens.  It will conflict with a
   a function with that typedef as an argument */

parameter_decl     
 : TYPEDEF_NAME                             { $$ = makeTypeExpr ($1); } 
 | MULOP parameter_decl /* %prec UNARY */   { $$ = makePointerNode ($1, $2); } 
 | parameter_decl arrayQual                 { $$ = makeArrayNode ($1, $2); } 
 | parameter_decl LPAR RPAR                 { $$ = makeFunctionNode ($1, paramNodeList_new ()); } 
 | parameter_decl LPAR realParamList RPAR   { $$ = makeFunctionNode ($1, $3); } 

/* param : the last production allows C types to be generated without the
   parameter name */

param   
 : lclTypeSpec parameter_decl               { $$ = makeParamNode ($1, $2); } 
 | lclTypeSpec notype_decl                  { $$ = makeParamNode ($1, $2); } 
 | lclTypeSpec optAbstDeclarator            { $$ = makeParamNode ($1, $2); } 
/*
** | OUT lclTypeSpec parameter_decl           { $$ = makeOutParamNode ($1, $2, $3); } 
** | OUT lclTypeSpec notype_decl              { $$ = makeOutParamNode ($1, $2, $3); } 
** | OUT lclTypeSpec optAbstDeclarator        { $$ = makeOutParamNode ($1, $2, $3); } 
*/

/* typeName is only used in trait parameter renaming */

typeName   
 : lclTypeSpec optAbstDeclarator           { $$ = makeTypeNameNode (FALSE, $1, $2); } 
 | OBJ lclTypeSpec optAbstDeclarator       { $$ = makeTypeNameNode (TRUE, $2, $3); } 
 | opForm                                  { $$ = makeTypeNameNodeOp ($1); } 

/* Abstract declarator is like a declarator, but with no identifier */
 
optAbstDeclarator  
 : /* empty */                            { $$ = (abstDeclaratorNode)0; }
 | abstDeclarator                         { $$ = (abstDeclaratorNode)$1; } 

abstDeclarator   
 : LPAR abstDeclarator RPAR               { $$ = $2; $$->wrapped = $$->wrapped + 1; }
 | MULOP abstDeclarator                   { $$ = makePointerNode ($1, $2); } 
 | MULOP                                  { $$ = makePointerNode ($1, (typeExpr)0); } 
 | arrayQual                              { $$ = makeArrayNode ((typeExpr)0, $1); } 
 | abstDeclarator arrayQual               { $$ = makeArrayNode ($1, $2); } 
 | abstDeclarator LPAR RPAR               { $$ = makeFunctionNode ($1, paramNodeList_new ()); } 
 | LPAR realParamList RPAR                { $$ = makeFunctionNode ((typeExpr)0, $2); } 
 | abstDeclarator LPAR realParamList RPAR { $$ = makeFunctionNode ($1, $3); } 

arrayQual   
 : LBRACKET RBRACKET                     { $$ = makeArrayQualNode ($1, (termNode)0); } 
 | LBRACKET constLclExpr RBRACKET        { $$ = makeArrayQualNode ($1, $2); } 

opForm   
 : IF markerSym THEN markerSym LLT_ELSE markerSym
   { $$ = makeOpFormNode ($1, OPF_IF, opFormUnion_createMiddle (0), ltoken_undefined); }
 | anyOp
   { $$ = makeOpFormNode ($1, OPF_ANYOP, opFormUnion_createAnyOp ($1), ltoken_undefined); }
 | markerSym anyOp
   { $$ = makeOpFormNode ($1, OPF_MANYOP, opFormUnion_createAnyOp ($2), ltoken_undefined); }
 | anyOp markerSym
   { $$ = makeOpFormNode ($1, OPF_ANYOPM, opFormUnion_createAnyOp ($1), ltoken_undefined); }
 | markerSym anyOp markerSym
   { $$ = makeOpFormNode ($1, OPF_MANYOPM, 
			  opFormUnion_createAnyOp ($2), ltoken_undefined); }
 | open middle close
   { $$ = makeOpFormNode ($1, OPF_MIDDLE, opFormUnion_createMiddle ($2), $3); }
 | markerSym open middle close
   { $$ = makeOpFormNode ($1, OPF_MMIDDLE, opFormUnion_createMiddle ($3), $4); }
 | open middle close markerSym
   { $$ = makeOpFormNode ($1, OPF_MIDDLEM, opFormUnion_createMiddle ($2), $3); }
 | markerSym open middle close markerSym
   { $$ = makeOpFormNode ($2, OPF_MMIDDLEM, opFormUnion_createMiddle ($3), $4); }
 | LBRACKET middle RBRACKET
   { $$ = makeOpFormNode ($1, OPF_BMIDDLE, opFormUnion_createMiddle ($2), $3); }
 | LBRACKET middle RBRACKET markerSym
   { $$ = makeOpFormNode ($1, OPF_BMIDDLEM, opFormUnion_createMiddle ($2), $3); }

   /* added the next 6 productions (wrt old checker) to complete LSL grammar
   ** LSL treats '[' and '{' as openSym but LCL treats them as LBRACKET and
   ** LBRACE, and hence the need for these separate productions 
   */

 | markerSym LBRACKET middle RBRACKET 
   { $$ = makeOpFormNode ($2, OPF_BMMIDDLE, opFormUnion_createMiddle ($3), $4); }
 | markerSym LBRACKET middle RBRACKET markerSym
   { $$ = makeOpFormNode ($2, OPF_BMMIDDLEM, opFormUnion_createMiddle ($3), $4); }
 | selectSym simpleIdOrTypedefName
   { $$ = makeOpFormNode ($1, OPF_SELECT, 
			  opFormUnion_createAnyOp ($2), ltoken_undefined); }
 | mapSym simpleIdOrTypedefName
   { $$ = makeOpFormNode ($1, OPF_MAP, 
			  opFormUnion_createAnyOp ($2), ltoken_undefined); }
 | markerSym selectSym simpleIdOrTypedefName
   { $$ = makeOpFormNode ($1, OPF_MSELECT, 
			  opFormUnion_createAnyOp ($3), ltoken_undefined); }
 | markerSym mapSym simpleIdOrTypedefName
   { $$ = makeOpFormNode ($1, OPF_MMAP, 
			  opFormUnion_createAnyOp ($3), ltoken_undefined); }

open   
 : openSym
 | LBRACE

close   
 : closeSym
 | RBRACE 

anyOp   
 : simpleOp2
 | logicalOp
 | eqOp

middle   
 : /* empty */               { $$ = 0; }
 | placeList

placeList   
 : markerSym                      { $$ = 1; }
 | placeList separator markerSym  { $$ = $1 + 1; }

separator   
 : COMMA
 | sepSym

signature   
 : COLON domain mapSym sortId   { $$ = makesigNode ($1, $2, $4); } 

domain   
 : /* empty */               { $$ = ltokenList_new (); }
 | sortList

sortList   
 : sortId                    { $$ = ltokenList_singleton ($1); } 
 | sortList COMMA sortId     { $$ = ltokenList_push ($1, $3); } 

lclPredicate   
 : term                      { $$ = makeLclPredicateNode (ltoken_undefined, $1, LPD_PLAIN);} 

term 
 : term0                     { $$ = checkSort ($1); }

/* When "if <term> then <term> else <term> . <logicalOp> <term>"
   shift instead of reduce */

term0   
 : IF term0 THEN term0 LLT_ELSE term0 %prec IF_THEN_ELSE
   { $$ = makeIfTermNode ($1,$2,$3,$4,$5,$6); } 
 | equalityTerm
 | term0 logicalOp term0          { $$ = makeInfixTermNode ($1, $2, $3); } 

equalityTerm   
 : simpleOpTerm   /* was   | quantifiers LPAR term RPAR */
 | quantifiers LPAR lclPredicate RPAR
   /* temp fix, should change interface in future, add lclPredicateKind too */
   { checkLclPredicate ($2, $3); $$ = makeQuantifiedTermNode ($1, $2, $3->predicate, $4);
     symtable_exitScope (g_symtab); 
   } 
 | simpleOpTerm eqOp simpleOpTerm
   { $$ = makeInfixTermNode ($1, $2, $3);} 
 | simpleOpTerm LLT_EQUALS simpleOpTerm 
   { $$ = makeInfixTermNode ($1, $2, $3);} 

simpleOpTerm   
 : prefixOpTerm
 | secondary postfixOps          { $$ = makePostfixTermNode ($1, $2); } 
 | secondary infixOpPart         { $$ = CollapseInfixTermNode ($1, $2); } 

simpleOp2          
 : simpleOp
 | MULOP

prefixOpTerm   
 : secondary
 | simpleOp2 prefixOpTerm          { $$ = makePrefixTermNode ($1, $2); } 

postfixOps   
 : simpleOp2                       { $$ = ltokenList_singleton ($1); } 
 | postfixOps simpleOp2            { $$ = ltokenList_push ($1, $2); } 

infixOpPart   
 : simpleOp2 secondary             { $$ = pushInfixOpPartNode (termNodeList_new (), $1, $2); } 
 | infixOpPart simpleOp2 secondary { $$ = pushInfixOpPartNode ($1, $2, $3); } 

secondary   
 : primary
 | bracketed                 { $$ = computePossibleSorts ($1); } 
 | bracketed primary         { $$ = updateMatchedNode ((termNode)0, $1, $2); }
 | primary bracketed         { $$ = updateMatchedNode ($1, $2, (termNode)0); }
 | primary bracketed primary { $$ = updateMatchedNode ($1, $2, $3); }
 | sqBracketed               { $$ = computePossibleSorts ($1); } 
 | sqBracketed primary       { $$ = updateSqBracketedNode ((termNode)0, $1, $2); }

bracketed   
 : matched COLON sortId    { $$ = $1; $$->sort = sort_lookupName (ltoken_getText ($3)); }
 | matched

sqBracketed   
 : LBRACKET args RBRACKET COLON sortId
   { $$ = makeSqBracketedNode ($1, $2, $3); 
     $$->given = sort_lookupName (ltoken_getText ($5)); }
 | LBRACKET args RBRACKET
   { $$ = makeSqBracketedNode ($1, $2, $3); } 
 | LBRACKET  RBRACKET COLON sortId
   { $$ = makeSqBracketedNode ($1, termNodeList_new (), $2); 
     $$->given = sort_lookupName (ltoken_getText ($4)); 
   }
 | LBRACKET  RBRACKET
   { $$ = makeSqBracketedNode ($1, termNodeList_new (), $2); } 

matched      
 : open args  close          { $$ = makeMatchedNode ($1, $2, $3); } 
 | open close                { $$ = makeMatchedNode ($1, termNodeList_new (), $2); } 

args   
 : term                      { $$ = termNodeList_push (termNodeList_new (), $1); } 
 | args separator term       { $$ = termNodeList_push ($1, $3); } 

primary   
 : LPAR term0 RPAR           /* may need to make a copy of $2 */
   { $$ = $2; $$->wrapped = $$->wrapped + 1; }
 | varId
   { $$ = makeSimpleTermNode ($1); } 
 | opId LPAR termList RPAR
   { $$ = makeOpCallTermNode ($1, $2, $3, $4); } 
 | lclPrimary
 | primary stateFcn
   { $$ = makePostfixTermNode2 ($1, $2); }  
 | primary selectSym simpleIdOrTypedefName
   { ltoken_markOwned ($3); $$ = makeSelectTermNode ($1, $2, $3); } 
 | primary mapSym simpleIdOrTypedefName
   { ltoken_markOwned ($3); $$ = makeMapTermNode ($1, $2, $3); } 
 | primary LBRACKET RBRACKET   
   { $$ = updateSqBracketedNode ($1, makeSqBracketedNode ($2, termNodeList_new (), $3), 
				(termNode)0); }
 | primary LBRACKET termList RBRACKET
   { $$ = updateSqBracketedNode ($1, makeSqBracketedNode ($2, $3, $4), (termNode)0); }
 | primary COLON sortId
   { $$ = $1; $$->given = sort_lookupName (ltoken_getText ($3)); }

termList   
 : term0                  { $$ = termNodeList_push (termNodeList_new (), $1); } 
 | termList COMMA term0   { $$ = termNodeList_push ($1, $3); } 

stateFcn   
 : preSym
 | postSym
 | anySym
 | QUOTE

lclPrimary   
 : cLiteral                         
 | RESULT                           { $$ = makeSimpleTermNode ($1); } 
 | FRESH LPAR termList RPAR         { $$ = makeOpCallTermNode ($1, $2, $3, $4); } 
 | UNCHANGED LPAR ALL RPAR          { $$ = makeUnchangedTermNode1 ($1, $3); } 
 | UNCHANGED LPAR storeRefList RPAR { $$ = makeUnchangedTermNode2 ($1, $3); } 
 | SIZEOF LPAR term RPAR
   { termNodeList x = termNodeList_new (); 
     termNodeList_addh (x, $3);
     $$ = makeOpCallTermNode ($1, $2, x, $4); 
   } 
 | ISSUB LPAR term COMMA term RPAR
   { termNodeList x = termNodeList_new ();
     termNodeList_addh (x, $3);
     termNodeList_addh (x, $5);
     $$ = makeOpCallTermNode ($1, $2, x, $6); 
   } 
 | SIZEOF LPAR lclTypeSpec RPAR       { $$ = makeSizeofTermNode ($1, $3); } 

/* removed 94-Mar-25:
**   | MODIFIES LPAR term RPAR
**                             {termNodeList x = termNodeList_new ();
**          termNodeList_addh (x, $3);
**        $$ = makeOpCallTermNode ($1, $2, x, $4); } 
*/

cLiteral   
 : CINTEGER  { $$ = makeLiteralTermNode ($1, sort_int); }
 | LCSTRING  { $$ = makeLiteralTermNode ($1, sort_cstring); }
 | CCHAR     { $$ = makeLiteralTermNode ($1, sort_char); }
 | CFLOAT    { $$ = makeLiteralTermNode ($1, sort_double); }

quantifiers   
 : quantifier
   { $$ = quantifierNodeList_add (quantifierNodeList_new (), $1); } 
 | quantifiers quantifier
   { $$ = quantifierNodeList_add ($1, $2); } 

quantifier   
 : quantifierSym { scopeInfo si = (scopeInfo) dmalloc (sizeof (*si));
		   si->kind = SPE_QUANT;
		   symtable_enterScope (g_symtab, si); }
   quantifiedList 
   { $$ = makeQuantifierNode ($3, $1); } 

quantifiedList   
 : quantified                         { $$ = varNodeList_add (varNodeList_new (), $1); } 
 | quantifiedList COMMA quantified    { $$ = varNodeList_add ($1, $3); } 

quantified   
 : varId COLON sortSpec     { $$ = makeVarNode ($1, FALSE, $3); } 
 | varId COLON OBJ sortSpec { $$ = makeVarNode ($1, TRUE, $4); } 

simpleIdOrTypedefName  
 : simpleId
 | TYPEDEF_NAME

/* a different name space from varId/fcnId/typeId */
fcnId : simpleId
varId : simpleId
tagId : simpleIdOrTypedefName
claimId : simpleIdOrTypedefName
sortId : simpleIdOrTypedefName
traitId : simpleIdOrTypedefName
opId : simpleIdOrTypedefName

%%

# include "bison.reset"

/*
** yytext is set in lex scanner 
** extern YYSTYPE yylval;  
** yylval is defined by code generated by bison 
*/

void ylerror (char *s) 
{
  /* 
  ** This resetting of the left context is very important when multiple
  ** files are to be parsed.  We do not want failures to propagate.
  ** Lex/Yacc does not reset the flags when the parsing goes bad.  
  ** BEGIN 0;        
  **/

  /*@-mustfree@*/
  lclfatalerror (yllval.ltok,
		 message ("%s: Token code: %s, Token String: %s", 
			  cstring_fromChars (s), 
			  ltoken_unparseCodeName (yllval.ltok), 
			  ltoken_getRawString (yllval.ltok)));
  /*@=mustfree@*/
}

static void yyprint (FILE *f, int t, YYSTYPE value) 
{
  fprintf (f, " type: %d (%s)", t, 
	   cstring_toCharsSafe (ltoken_getRawString (value.ltok)));
}







