/*
 * ym2203.c
 * 
 * dummy file to get X-Mame FM sound synthesys linked under UNIX
 *
 * this means that -nofm commandline option and dontuse_fm_synth xmamerc
 * entry data has no effect. 
 *
 */

#ifdef UNIX

#define __YM2203_C_

unsigned char No_FM;
unsigned char RegistersYM[264*5]; /* maximum of 5 YM2203 devices */

unsigned int BaseSb	= 0x388 ; /* NOT used under *NIX */
unsigned int DelayReg   = 4; /* delay after OPL register write */
unsigned int DelayData  = 7; /* delay after OPL data write */
unsigned int YMNumber;

void InitYM(void) {
	/* 
	Inits YM in OPL3 mode and 4 ops per channel. 
        Also reset YM2203 registers 
	*/
}

void InitOpl(void) {
	/* must be performed too in osd_exit */
}

void SlotCh(void) {
}

void YM2203(void) {
}

void osd_ym2203_write(int n, int r, int v) {
	if (No_FM) return;
	YMNumber = n;
	RegistersYM[r+264*n] =v ;
	if (r == 0x28) SlotCh();
	return;
}

void osd_ym2203_update(void) {
	if (No_FM) return;
	YM2203();
	return;
}

#endif

