/*
 * Linux Dependent system file 
*/

#ifdef linux

#define __LINUX_C

#include "xmame.h"
#include "sound.h"

#ifdef USE_JOYSTICK
#include <linux/joystick.h>
struct 	 JS_DATA_TYPE joy_data,joy_orig;
int	 joy_fd; /* joystick file descriptor */
#endif

/*
 * Put anything here you need to do when the program is started.
 * Return 0 if initialization was successful, nonzero otherwise.
 */

int sysdep_init ()
{
	/**********  initialize joystick device */
#ifdef USE_JOYSTICK
#ifdef I386_JOYSTICK
    	if (use_joystick) {
		printf ("Linux Joystick interface initialization...\n");
		if ((joy_fd = open ("/dev/js0", O_RDONLY | O_NONBLOCK)) < 0) {
		  printf ("Couldn't open joystick device /dev/js0 \n");
		  printf ("Be sure to joystick module is instaled\n");
		  use_joystick = FALSE;
		}
	else if ( read(joy_fd,&joy_orig,sizeof(struct JS_DATA_TYPE)) < 0) {
	  	 printf ("Cannot read joystic device.sorry\n");
	 	 exit(1);
		}
		/* mask x e y pos to skip "flickering" */
		if (! swapjoyaxis) {
		    joy_orig.x >>=joyfilter;
		    joy_orig.y >>=joyfilter;
		} else {
		    int a = (joy_orig.y >> joyfilter);
		    joy_orig.y = (joy_orig.x >> joyfilter);
		    joy_orig.x = a;
		}

    	}
#endif
#endif
	/********* * initialize sound */
    	if (play_sound) {
	    int linux_sound_init(void);
	    if(linux_sound_init()<0) 
		fprintf(stderr,"Sound device init failure. Sound disabled\n");	
	}
	return (TRUE);
}


/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int linux_sound_init(void) {
	int format = AFMT_U8;	
	int stereo = 0;
	int frag = LOG_2_FRAG + (NUM_FRAGS << 16);
	fprintf(stderr,"Linux Sound Driver initialization... \n");
	if((audio_fd = open("/dev/dsp",O_WRONLY,0)) < 0) {
		perror("/dev/dsp");
		play_sound = 0;
		return -1;
	} 
	if (ioctl(audio_fd,SNDCTL_DSP_SETFMT,&format) < 0) {
		perror("SNDCTL_DSP_SETFMT");
		play_sound = 0;
	} 
	if (ioctl(audio_fd,SNDCTL_DSP_STEREO,&stereo) < 0) {
                perror("SNDCTL_DSP_STEREO");
                play_sound = 0;
        } 
	if (ioctl(audio_fd,SNDCTL_DSP_SPEED,&audio_sample_freq) < 0) {
                perror("SNDCTL_DSP_SPEED");
                play_sound = 0;
        } 
	if (ioctl(audio_fd,SNDCTL_DSP_SETFRAGMENT,&frag) < 0) {
                perror("SNDCTL_DSP_SETFRAGMENT");
                play_sound = 0;
	}

	if(play_sound == 0) { close(audio_fd); return (-1); }

	fprintf(stderr,"Audio Device set to 8bit linear mono %dHz\n",audio_sample_freq);
        return 0;   
}

/*
 * Cleanup routines to be executed when the program is terminated.
 */

void sysdep_exit (void) {
	if (play_sound)	{
                int n;
                /* stop and release voices */
                for (n = 0; n < AUDIO_NUM_VOICES; n++) osd_stop_sample(n);
		close(audio_fd);
        }
#ifdef USE_JOYSTICK
  	if (use_joystick)	close (joy_fd);
#endif
}

#define abs(x) ( ( (x) >= 0 )? (x) : -(x) )
/* inline int abs(int x) {if (x>=0) return (x); return -(x); } */

long sysdep_get_audio_freespace() {
	audio_buf_info info;
	int i=ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&info);
	if (i<0) { perror("SNDCTL_DSP_GETOSPACE"); return -1; }
	return (long)(info.bytes);
}

int sysdep_play_audio( byte *buf, int bufsize) {
	return write(audio_fd,buf,bufsize);
}

#endif
/****** end of Linux dependent code; DO NOT WRITE BELOW THIS LINE *********/
