#include <stdio.h>	/*(perror)*/
#include <sys/mman.h>	/*PROT_READ,MAP_xxx*/
#include <fcntl.h>	/*O_RDONLY*/
#include <sys/stat.h>	/*stat*/
#include <stdlib.h>	/*(atoi)*/
#include <unistd.h>	/*optarg,optind*/
#include "defs.h"	/*->playnote.h (u8)*/
#include "inst.h"	/*->playnote.h (SampleInfo)*/
#include "playnote.h"	/*(playNoteXXX)*/
#include "magic.h"	/*MagicType*/
#include "dacio.h"	/*DacioConfInfo*/
#include "nspmod.h"	/*->play-s3m.h (OptInfo)*/
#include "play-s3m.h"	/*(playS3m)*/
#include "play-mod.h"	/*(playMod)*/
#include "play-mtm.h"	/*(playMtm)*/
#include "mem.h"	/*(memSongFree)*/
#include "nspmod.h_"	/*(main)*/

static u8 dummy;

/* store samples in RAM */
static void
lookOverFile(u8 *p, u32x size)
{
    for (; size > 0; size--,p++) dummy = *p;
}

/* LIT(A) -> "10" */
#define LIT_(s) #s
#define LIT(s) LIT_(s)

static void
help(const char *argv0)
{
    fprintf(stderr,"NSPmod version " LIT(VERSION_MAJOR) "." LIT(VERSION_MINOR) "\n");
    fprintf(stderr,"Usage: %s [options] modfile\n", argv0);
    fprintf(stderr,"Options:\n");
    fprintf(stderr," -c #  play only the channel\n");
    fprintf(stderr," -e    show events\n");
    fprintf(stderr," -f #  output sample rate\n");
    fprintf(stderr," -i    show sample info\n");
    fprintf(stderr," -l #  limit repeating\n");
    fprintf(stderr," -m    force mono\n");
    fprintf(stderr," -o #  oversampling factor\n");
    fprintf(stderr," -r    force repeating\n");
    fprintf(stderr," -s #  start from the ord\n");
    fprintf(stderr," -v #  master volume\n");
}

int
main(int argc, char *argv[])
{
    int fd;
    struct stat statbuf;
    u8 *p;
    DacioConfInfo dci;
    MagicType mt;
    i15x chNum;
    static OptInfo oi;
    int optChar;

    oi.outRate = DEF_OUTRATE;
    oi.ovsFreq = -1;
    /*oi.repLimit = 1;*/
    while ((optChar = getopt(argc, argv, "c:ef:il:mo:rs:v:")) > 0) {
	switch (optChar) {
	case 'c': oi.onlyCh = (i15x)strtol(optarg, NULL, 0) | 0x100; break;
	case 'e': oi.showEvents++; break;
	case 'f': oi.outRate = (u16x)strtol(optarg, NULL, 0); break;
	case 'i': oi.showMsg++; break;
	case 'l': oi.repLimit = (i15x)strtol(optarg, NULL, 0); break;
	case 'm': oi.mono++; break;
	case 'o': oi.ovsFreq = (i15x)strtol(optarg, NULL, 0); break;
	case 'r': oi.forceRep++; break;
	case 's': oi.startOrd = (i15x)strtol(optarg, NULL, 0); break;
	case 'v': oi.masterVol = (i15x)strtol(optarg, NULL, 0); break;
#if 0
	case ':':
	    fprintf(stderr, "Missing argument.\n");
	    help(argv[0]);
	    exit(1);
#endif
	case '?':
	    /*fprintf(stderr, "Unknown option.\n");*/
	    help(argv[0]);
	    exit(1);
	}
    }
    if (optind >= argc) {
	help(argv[0]);
	exit(1);
    }

    fd = open(argv[optind], O_RDONLY);
    if (fd < 0) {
	perror("open");
	return 1;
    }
    if (fstat(fd, &statbuf) < 0) {
	perror("fstat");
	return 1;
    }
#ifndef MAP_FILE
#define MAP_FILE 0
#endif
    p = mmap(0, statbuf.st_size, PROT_READ, MAP_FILE | MAP_SHARED, fd, 0);
    if (p == (void *) -1) {
	perror("mmap");
	return 1;
    }

    if (magic(p, statbuf.st_size, &mt, &chNum)) {
	fprintf(stdout, "Unknown format\n");
	return 1;
    }

    lookOverFile(p, statbuf.st_size);
    dacioInit();
    dci.speed = oi.outRate;
    dci.stereo = !oi.mono;
    dacioConf(&dci);
    if (dci.speed != oi.outRate)
	fprintf(stderr,"Output rate is modified to %dHz\n", dci.speed);
    playNoteInit();
    playNoteSetOutRate(dci.speed);
    playNoteSetMono(!dci.stereo);
    if (oi.ovsFreq < 0) oi.ovsFreq = dci.speed / 1000;

    switch (mt) {
    case MAGIC_S3M:
	playS3m(p, statbuf.st_size, &oi);
	break;
    case MAGIC_MOD:
    case MAGIC_MOD15:
	chNum = 4;
    case MAGIC_MODX:
	playMod(p, statbuf.st_size, mt, chNum, &oi);
	break;
    case MAGIC_MTM:
	playMtm(p, statbuf.st_size, &oi);
	break;
    }

    dacioFlush();
    dacioSync();

    memSongFree();

    return 0;
}
