#include "cthugha.h"
#include "sound.h"
#include "interface.h"
#include "options.h"
#include "display.h"

#include <math.h>

int sound_timer = 0;				/* used for automatic change */
int sound_minnoise = 10;			/* quiet is below this */
int sound_firelevel = 1000;			/* firelevel to change */
int sound_wait_quiet = 500;			/* max. quiet interval (5 sec) 
						   then text is displayed */
int sound_attack = 0;				/* attack level */
int sound_fire = 0;				/* fired now */
int sound_amplitude = 0;

int sound_quiet_change = 150;			/* change after quiet-pause (1.5 sec) */

int sound_wait_min = 500;			/* min time between change (5 sec) */
int sound_wait_random = 1000;			/* extra random wait-time (10 sec) */
int sound_wait = 1000;				/* time till change */

int sound_FFT = 0;				/* use FFT or don't */
int sound_use_fft = 1;				/* allow fft-usage */

int sound_flashlight = 0;
int sound_use_flashlight = 1;

int sound_massage_style = 1;			/* massage style */
int massage_first = CHANGE_RANDOM;		/* massage to start with */

__complex__ float wp[MAX_BUFF_WIDTH];

/*
 * local variables
 */
static int sound_quiet_since = 0;		/* used to determine if
						   quiet msg. should be disp.*/

int init_sound_FFT();


int init_sound_process() {

    init_sound_FFT();
	
    if ( sound_wait_random <= 0)
	sound_wait_random = 1;

    /* set initial wait-time till change */
    sound_wait = sound_wait_min + rand() % sound_wait_random;

    return 0;
}
/*
 * Initalization for FFT 
 */
int init_sound_FFT() {
    int i; 
 
    for(i=0; i < sound_bsize; i++) {
	__real__ wp[i] = cos(2.0*M_PI/(double)sound_bsize*(double)i);
	__imag__ wp[i] = sin(2.0*M_PI/(double)sound_bsize*(double)i);
    }
	
 
    return 0;
}


/*
 * Calculate the noisyness. And from that the time since when the 
 * system is silent and if it is time to change the display 
 * returns: 
 *   -1 silentce-message,
 *    1  it's time to change
 *    0 otherwise
 */

int sound_noise_check() {
    int i;
    int al = 0, ar = 0;			/* noise level */
    static int lastamp = 0;
    static int fire_level = 0;
    int quiet_length;			/* length of the last quietness */

    int noisy = 0;			/* there was some sound */
    long now;

    /* get the amplitude of this sound frame (root mean squared) */
    for (i=sound_bsize,al=ar=0; i!=0; i--) {
	al += sound_data_unproc[i][0] * sound_data_unproc[i][0];
	ar += sound_data_unproc[i][1] * sound_data_unproc[i][1];
    }
    /* sqare root the mean */
    al = sqrt(al/sound_bsize);
    ar = sqrt(ar/sound_bsize);
    
    sound_amplitude = (al+ar)/2;
    
    if (sound_amplitude < lastamp-9)		/* ignore such a small decrease */
	sound_amplitude = lastamp-9;
    
    if (sound_amplitude > lastamp)
	sound_attack += sound_amplitude-lastamp;
    
    /* if the attack is finally over, then fire at the intensity of the attack */
    if (sound_amplitude < lastamp) {
	sound_fire = sound_attack;
	sound_attack = 0;
    } else 
	sound_fire = 0;
    fire_level += sound_fire;

    lastamp = sound_amplitude;
    
    /* check for silence */
    if (sound_amplitude >= sound_minnoise) 
	noisy = 1;

#if 0
    /* compute beats/minute, not working as it should */
    if(sound_fire > 20) {
	static int bt[16];
	static int bn=0;
	int sound_bpm;

	bt[bn] = gettime();

	sound_bpm = bt[bn] - bt[ (bn+1)%16 ];		/* time for 16 beats */
	if(sound_bpm > 0) {
	    sound_bpm = 16*60000/sound_bpm;
	}
	printfv(5, "bpm: %d\n", sound_bpm);

	bn = (bn+1)%16;
    }
#endif
    
    now = gettime();

    /* get time since last sound */
    quiet_length = now - sound_quiet_since;
    if(noisy)
	sound_quiet_since = now;
	
    /* Check for interrupted silence */
    if ( sound_quiet_change)
	if ( noisy && ( quiet_length > sound_quiet_change) ) {
	    return 1;				/* ret: interrupted silence */
	}
	
    /* Check for long quietness */
    if ( sound_wait_quiet ) {				
	if( !noisy && ( quiet_length > sound_wait_quiet) ) {
	    sound_quiet_since = now;		/* start quiet-length again*/
	    return -1;				/* ret: long quiet */
	}
    } 
		
    /* Check for enough fire to change */
    if ( sound_firelevel)
	if ( fire_level > sound_firelevel ) {
	    fire_level = 0;
	    return 1;
	} 

    /* nothing special happend, maybe we waited long enough */
    if ( sound_wait_min)
	if( (now - sound_timer) > sound_wait) {	
	    sound_timer = now;
	    sound_wait = sound_wait_min + rand() % max(1,sound_wait_random);
	    return 1;
	}

    return 0;
}

/* Macros for compatibility with DOS code */
#define stereo sound_data
#define massageStyle sound_massage_style

int massage_audio() {
    int temp,x; 
    int temp2; 
 
    switch (massageStyle) { 
    case 0: 
    default: 
	break; 
    case 1: 
	temp=stereo[0][1]; 
	temp2=stereo[0][0]; 
	for (x=1; x < sound_bsize; x++) { 
	    if ((stereo[x][1]-temp)>10) { 
		stereo[x][1]=temp+10; 
	    } else if ((stereo[x][1]-temp)<-10) { 
		stereo[x][1]=temp-10; 
	    } 
	    if ((stereo[x][0]-temp2)>10) { 
		stereo[x][0]=temp2+10; 
	    } else if ((stereo[x][0]-temp2)<-10) { 
		stereo[x][0]=temp2-10; 
	    } 
	    temp=stereo[x][1]; 
	    temp2=stereo[x][0]; 
	} 
	break; 
    case 2: 
	temp=stereo[0][1]; 
	temp2=stereo[0][0]; 
	for (x=1; x < sound_bsize; x++) { 
	    if ((stereo[x][1]-temp)>3) { 
		stereo[x][1]=temp+3; 
	    } else if ((stereo[x][1]-temp)<-3) { 
		stereo[x][1]=temp-3; 
	    } 
	    if ((stereo[x][0]-temp2)>3) { 
		stereo[x][0]=temp2+3; 
	    } else if ((stereo[x][0]-temp2)<-3) { 
		stereo[x][0]=temp2-3; 
	    } 
	    temp2=stereo[x][0]; 
	    temp=stereo[x][1]; 
	} 
	break; 
    case 3:			/* low pass filter */
	temp=stereo[0][1];
	temp2=stereo[0][0];
	for (x=1; x < sound_bsize; x++) {
	    stereo[x][1] = stereo[x-1][1] + (stereo[x][1] - temp) / 16;
	    stereo[x][0] = stereo[x-1][0] + (stereo[x][0] - temp2) / 16;
	    temp2=stereo[x][0];
	    temp=stereo[x][1];
	}
	break;
    } 
    return 0;
}

int change_massage_style(int to) {
    sound_massage_style = val_change(to, 0, 3, sound_massage_style);
    return 0;
}

/*****************************************************************************/

int flashlight() {
    int channel;
    unsigned char *p, *q;
    static palette Pal;
    static unsigned int slab[256];
    int dir,currentd,lastgot,i,lens,got, lastd=1,temp;
    int lastcapc,nextonec,amt;
    
    if( (sound_flashlight == 0) || (sound_use_flashlight == 0) )
	return 0;

#if 1
    lens=0;
    for (i=0; i < 256; i++) 
	slab[i] = 0;

    lastgot=128;
    lens=0;
    lastd=1;
    lastcapc = 128;
    nextonec = 1;

    
    for (channel=0; channel<2; channel++)
	for (i=0; i < sound_bsize; i++) {
	    got=stereo[i][channel];
	    dir=got-lastgot;
	    
	    if (dir>1)
		currentd=1;
	    else if (dir<-1)
		currentd=-1;
	    else
		currentd=lastd;
	    
	    if (currentd!=lastd) {
		if (lens>255)
		    lens=255;
		lens=lens>>3;
		
		slab[lens]+=(lens>>1);
		
		lens=0;
		
		if (nextonec == 1) {
		    nextonec=0;
		    lastcapc=got;
		} else {
		    nextonec = 1;
		    amt=abs(lastcapc-got);
		    if (amt>127)
			amt=127;
		    slab[amt>>2]++;
		}
	    } else
		lens++;
	    
	    
	    lastd=currentd;
	    lastgot=got;
	}

    p = (unsigned char *)Pal;
    q = (unsigned char *)(palettes.entries[palettes.current].data);

    for (i=0; i < 256; i++) {
	temp=slab[(255-i)>>3];
	
	if (temp>6)
	    temp=6;

	q = (unsigned char *)(palettes.entries[
	    (palettes.current+temp)%palettes.nr_entries].data)+i*3;
	
	*p++ = *q++;
	*p++ = *q++;
	*p++ = *q++;
    }

    cth_setpalette(Pal, 1);
#endif

/* is is experimental */
#if 0
    {
	int i,j,l;
	
	for(i=0; i < 256; i++)
	    for(j=0; j < 256; j++)
		Pal[i][j] = (* (palette*)(palettes.entries[palettes.current].data) )[i][j];
	
	for(l=sound_fire<<3,i=0; (i < 256) && (l > 0); i++, l -= 8)
	    for(j=0; j < 3; j++)
		Pal[i][j] = min( Pal[i][j] + l, 255);
	
	cth_setpalette(Pal, 1);
	cth_setpalette(* (palette*)(palettes.entries[palettes.current].data), 0);
    }
#endif

    return 0;
}

int change_flashlight(int to) {
    sound_flashlight = val_change(to, 0, sound_use_flashlight, sound_flashlight);
    return 0;
}
    


/*
 * compute FFT 
 */
static int r(int k, int n) {
    int r = 0;
    for(; n > 1; n >>= 1) {
        r = (r<<1) | (k&1);
        k >>= 1;
    }
    return r;
}

/*
 * use sound data as input (left -> real, right -> imag)
 */
int FFT() {
    int h, k;
    int p;
    int z, zp;
    __complex__ float c[sound_bsize];
    float a;

    if( !sound_FFT || !sound_use_fft )
	return 0;

    for(k=0; k < sound_bsize; k++) {			/* feed input */
	__real__ c[k] = (float)sound_data_unproc[k][0];
	__imag__ c[k] = (float)sound_data_unproc[k][1];
    }

    /* the algorithm I use here is from:
     *
     * The Design and Analysis of Parallel Algorithms
     * Selim G. Akl
     * Prentice Hall, Englewood Clifs New Jersey 076322; 1989
     * ISBN 0-12-700056-3
     * page 244
     */
    p = sound_bsize / 2;
    z = 1;
    for(h = sound_bsize; h != 0; h >>= 1) {
	
	zp = 0;
	for(k=0; k < sound_bsize; k++) {
	    if( (k & p) == 0) {
		__complex__ float t = c[k] + c[k+p];
		c[k+p] = (c[k] - c[k+p])*wp[zp];
		c[k] = t;
	    }
	    zp = (zp + z) % sound_bsize;
	}
	p >>= 1;
	z *= 2;
    }
    
    a = 2.0 / sqrt(sound_bsize);			/* normalize result, store back */
    for(k=0; k < sound_bsize; k++) {
	sound_data[r(k,sound_bsize)][0] = (__real__ c[k]) * a;
	sound_data[r(k,sound_bsize)][1] = (__imag__ c[k]) * a;
    }

    return 0;
}
 	

int change_FFT(int to) {
    sound_FFT = val_change(to, 0, sound_use_fft, sound_FFT);
    return 0;
}







