/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgCanny.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:32 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Canny"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in,*out1,*gimx,*gimy,*gim;
  int width=0,height=0,x,y;
  int v_x=0,v_y=0,v_width=0,v_height=0,y_end=0;
  register it_float *r0_ptr,*r1_ptr,*r2_ptr,*ptr1;
  double val,u1,u2,aa,bb,cc,dd,ee,ff,gg,hh,ii,gx,gy;
  double min,max;

  IFHELP
    {
      fprintf(stderr,"img%s - Perform Canny edge detection\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  /* Loop for all images */
  do {
    in=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in==NULL)
      ERROR("can't import image file");
    width=in->width;
    height=in->height;
    v_x=in->valid_x+1;
    v_y=in->valid_y+1;
    v_width=in->valid_width-2;
    v_height=in->valid_height-2;
    y_end=v_y+v_height;
	    
    out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");
    gimx=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");
    gimy=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");
    gim=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");
    
    imgInitMinMax(min,max);
    for(y=v_y;y<y_end;y++)
      {
	r0_ptr=im_float_row(in,y-1)+v_x-1;
	r1_ptr=im_float_row(in,y)+v_x-1;
	r2_ptr=im_float_row(in,y+1)+v_x-1;
	for(x=0;x<v_width;x++)
	  {
	    r0_ptr++;
	    bb= *r0_ptr++;
	    r0_ptr--;

	    dd= *r1_ptr++;
	    r1_ptr++;
	    ff= *r1_ptr--;

	    r2_ptr++;
	    hh= *r2_ptr++;
	    r2_ptr--;

	    gx=(ff-dd)/2.0;
	    gy=(bb-hh)/2.0;
	    im_float_value(gimx,x+v_x,y)=gx;
	    im_float_value(gimy,x+v_x,y)=gy;
	    im_float_value(gim,x+v_x,y)=sqrt(gx*gx+gy*gy);
	  }
      }
    for(y=v_y;y<y_end;y++)
      {
	r0_ptr=im_float_row(gim,y-1)+v_x-1;
	r1_ptr=im_float_row(gim,y)+v_x-1;
	r2_ptr=im_float_row(gim,y+1)+v_x-1;
	ptr1=im_float_row(out1,y)+v_x;
	for(x=0;x<v_width;x++)
	  {
	    aa= *r0_ptr++;
	    bb= *r0_ptr++;
	    cc= *r0_ptr--;
	    dd= *r1_ptr++;
	    ee= *r1_ptr++;
	    ff= *r1_ptr--;
	    gg= *r2_ptr++;
	    hh= *r2_ptr++;
	    ii= *r2_ptr--;
	    gx=im_float_value(gimx,x+v_x,y);
	    gy=im_float_value(gimy,x+v_x,y);
	    if(fabs(gy)<0.4142*fabs(gx))
	      {
		u1=dd;
		u2=ff;
	      }
	    else if(fabs(gx)<0.4142*fabs(gy))
	      {
		u1=bb;
		u2=hh;
	      }
	    else if(gx>0.0 && gy>0.0 || gx<0.0 && gy<0.0)
	      {
		u1=cc;
		u2=gg;
	      }
	    else
	      {
		u1=aa;
		u2=ii;
	      }
	    val=0.0;
	    if(ee>u1 &&ee>u2)
	      val=ee;
	    *ptr1++=val;
	    if(val>max) max=val;
	    if(val<min) min=val;
	  }
      }
    i_destroy_image(in);

    out1->min_value=min;
    out1->max_value=max;
    out1->valid_x=v_x;
    out1->valid_y=v_y;
    out1->valid_width=v_width;
    out1->valid_height=v_height;

    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(gimx);
    i_destroy_image(gimy);
    i_destroy_image(gim);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
