/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgMax.c                                                      */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:48 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Max"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1=NULL;
  int width=0,height=0,x,y;
  double val,min,max;
  int count,number;
  it_float *in1_ptr,*out_ptr;
  char *jjj;
  double strtod();

  IFHELP
    {
      fprintf(stderr,"img%s - Find Maximum pixel values over N images\n",
	      PRGNAME);
      fprintf(stderr,"img%s [N]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  if(argc!=1 && argc!=2)
    ERROR("invalid arguments");
  number=0;
  if(argc==2)
    number=(int)strtod(argv[1],&jjj);

  if(number<1 || number>1000)
    number=2;

  /* Loop for all images */
  do {
    for(count=0;count<number;count++)
      {
	in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
	if(in1==NULL)
	  ERROR("can't import image file");
	if(count==0)
	  {
	    width=in1->width;
	    height=in1->height;
	    out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
	    if(out1==NULL)
	      ERROR("out of memory");
	    out1->valid_x=in1->valid_x;
	    out1->valid_y=in1->valid_y;
	    out1->valid_width=in1->valid_width;
	    out1->valid_height=in1->valid_height;
	    for(y=0;y<height;y++)
	      {
		in1_ptr=im_float_row(in1,y);
		out_ptr=im_float_row(out1,y);
		for(x=0;x<width;x++,out_ptr++)
		  *out_ptr= (*in1_ptr++);
	      }
	  }
	else if(width!=in1->width || height!=in1->height)
	  {ERROR("image size mismatch");}
	else
	  for(y=0;y<height;y++)
	    {
	      in1_ptr=im_float_row(in1,y);
	      out_ptr=im_float_row(out1,y);
	      for(x=0;x<width;x++,out_ptr++)
		{
		  val= (*in1_ptr++);
		  if(val>*out_ptr)
		    *out_ptr =val;
		}
	    }
	i_destroy_image(in1);
      }
    imgInitMinMax(min,max);
    for(y=0;y<height;y++)
      {
	out_ptr=im_float_row(out1,y);
	for(x=0;x<width;x++,out_ptr++)
	  {
	    val= *out_ptr;
	    if(val>max)
	      max=val;
	    else if(val<min)
	      min=val;
	  }
      }

    out1->min_value=min;
    out1->max_value=max;
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
