/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgReorder.c                                                  */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:55 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Reorder"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int width,height,x,y,new_y;
  it_float *in1_ptr,*out_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Rearrange floating point image for Fourier viewing\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  /* Loop for all images */
  do {
    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;
    
    out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");

    for(y=0;y<height;y++)
      {
	new_y=(3*height/2-y)%height;
	in1_ptr=im_float_row(in1,y);
	out_ptr=im_float_row(out1,new_y)+width/2;
	for(x=0;x<width/2;x++)
	  *out_ptr++ = *in1_ptr++;
	out_ptr=im_float_row(out1,new_y);
	for(x=0;x<width/2;x++)
	  *out_ptr++ = *in1_ptr++;
      }
    out1->min_value=in1->min_value;
    out1->max_value=in1->max_value;
    out1->valid_x=in1->valid_x;
    out1->valid_y=in1->valid_y;
    out1->valid_width=in1->valid_width;
    out1->valid_height=in1->valid_height;
    i_destroy_image(in1);
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
