/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgSetMinMax.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:56 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "SetMinMax"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in;
  int width,height,x,y;
  double val,min=0.0,max=0.0;
  it_float *ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Set min and max value fields in a Float image\n",
	      PRGNAME);
      fprintf(stderr,"img%s [min max]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  if(argc==2 || argc>3)
    ERROR("invalid arguments");

  if(argc==3)
    {
      min=atof(argv[1]);
      max=atof(argv[2]);
    }

  /* Loop for all images */
  do {
    in=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in==NULL)
      ERROR("can't import image file");
    width=in->width;
    height=in->height;

    if(argc==1)
      {
	imgInitMinMax(min,max);
	for(y=0;y<in->valid_height;y++)
	  {
	    ptr=im_float_row(in,y+in->valid_y)+in->valid_x;
	    for(x=0;x<in->valid_width;x++)
	      {
		val= *ptr++;
		if(val>max)
		  max=val;
		if(val<min)
		  min=val;
	      }	
	  }
      }
    fprintf(stderr,"%s: (min = %g, max = %g)\n",PRGNAME,min,max);
    in->min_value=min;
    in->max_value=max;

    i_write_image_file(stdout,in,IF_BINARY);
    i_destroy_image(in);

  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
