/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgSmooth.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:57 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Smooth"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *f1,*f2;
  double sigma;
  int stat;

  IFHELP
    {
      fprintf(stderr,"img%s - Smooth image with a Gaussian kernel\n",
	      PRGNAME);
      fprintf(stderr,"img%s [sigma]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  sigma is the radius at e^(-0.5)\n");
      exit(0);
    }

  imgStart(PRGNAME);

  /* Get value of sigma from argument line (if any) */
  sigma=1.0;
  if(argc!=1 && argc!=2)
    ERROR("invalid arguments");
  if(argc==2)
    sigma=atof(argv[1]);
  if(sigma<0.1 || sigma>30.0)
    ERROR("smoothing factor out of range");

  /* Loop for all images */
  do {
    f1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(f1==NULL)
      ERROR("can't import image file");

    f2=i_create_image(f1->width,f1->height,IT_FLOAT,IM_FRAGMENT);
    if(f2==NULL)
      ERROR("out of memory");

    stat=i_smooth(f1,f2,sigma);
    if(stat<0)
      ERROR("out of memory");
    if(stat>0)
      ERROR("smoothing kernel too large for image");

    i_write_image_file(stdout,f2,IF_BINARY);
    i_destroy_image(f1);
    i_destroy_image(f2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
