 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon June 301997                              */
 /* ------------------------------------------------------------------   */
 /* Objects describing how to join units.                                */
 /*                                                                      */
 /************************************************************************/

#include "Join.h"

EST_String  SubtypedObject<Join>::type_name(void) const {return "Join";}

#if defined(INCLUDE_LISP)
int  SubtypedObject<Join>::s_lisp_type = tc_festival_join;
#endif

Join::Join(void)
{
}

Join::~Join(void)
{ }

EST_read_status Join::fill_from(FILE *stream, int binary) 
{(void)stream; (void)binary; return misc_read_error;}
EST_write_status Join::write_to(FILE *stream, int binary) 
{(void)stream; (void)binary; return misc_write_error;}

void Join::set_filename(EST_String filename)
{(void)filename;}


int Join::set_property(EST_String property, ValueType value)
{
  return SchemeObject::set_property(property, value);
}

int Join::from_point(void)
{
  return -1;
}

int Join::length(void)
{
  return -1;
}

EST_TVector<int> Join::segment_ends(void)
{
  EST_TVector<int> v(0);
  return v;
}
  
int Join::to_point(void)
{
  return -1;
}

#if defined(INCLUDE_LISP)

void Join::lisp_declare(void)
{
  long gc_kind;
  set_gc_hooks(tc_festival_join,
	       1,
	       NULL,
	       Join::lisp_gc_mark,
	       NULL,
	       Join::lisp_gc_free,
	       Join::lisp_gc_clear_mark,
	       &gc_kind);
  set_print_hooks(tc_festival_join,
		  Join::lisp_print,
		  Join::lisp_print_string
		  );

  init_subr_2("make_join", Join::lisp_make,
 "(make_join TYPE PROPERTIES)\n\
  Make an empty join of the given type and properties.");
}
#endif

#if defined(INSTANTIATE_TEMPLATES)
#include "SubtypedObject.cc"
template class SubtypedObject<Join>;
#endif
