/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*                Heap class for stack decoder                           */
/*                                                                       */
/*=======================================================================*/


#include "Heap.h"
#include <string.h>
#include <stdlib.h>

Heap::Heap(int max_size) : max_heap_size(max_size) {

	heap_size = 0;
	heap_item = new Heap_Item*[max_heap_size+1];  // element 0 is unused

	for(int i=0;i<=max_heap_size;i++)
		heap_item[i] = NULL;

#ifdef DEBUG
	cerr << "Heap constructed" << endl;
#endif

}



Heap::~Heap(){

	for(int i=0;i<=max_heap_size;i++){

		if(heap_item[i] != NULL){
			delete heap_item[i];
			heap_item[i] = NULL;
		}
	}

	if(heap_item != NULL)
		delete heap_item;

#ifdef DEBUG
	cerr << "Heap deleted" << endl;
#endif

}

void
Heap::heapify(int node){

	Heap_Item* temp_heap_item_ptr;
	int largest;

	int left = left_child(node);
	int right = right_child(node);

	if( (left<=heap_size) && ( *(heap_item[left]) > *(heap_item[node]) )  )
		largest=left;
	else
		largest=node;

	if( (right<=heap_size) && ( *(heap_item[right]) > *(heap_item[largest]) )  )
		largest=right;

	if(largest != node){
		temp_heap_item_ptr = heap_item[node];
		heap_item[node] = heap_item[largest];
		heap_item[largest] = temp_heap_item_ptr;
		heapify(largest);
	}

}



Heap_Item*
Heap::extract_max(){

	// need to check for underflow here
	if(heap_size==0){
		cerr << "Heap is empty - can't extract max !" << endl;
		return NULL;
	}


	Heap_Item* max = heap_item[1];
	heap_item[1] = heap_item[heap_size];
	heap_item[heap_size] = NULL;
	heap_size--;
	heapify(1);

#ifdef DEBUG
	cerr << "Heap::extract_max : heap size is now " << heap_size << endl;
#endif

	return max;

}



Heap::insert_error_t
Heap::insert(Heap_Item* new_heap_item_ptr){

	if( full() ){
		cerr << "Heap has filled !" << endl;
		return heap_full;

	}else{
		heap_size++;
		int j = heap_size;
		
		while( (j>1) && ( *new_heap_item_ptr > *(heap_item[parent(j)]) )  ){
			heap_item[j] = heap_item[parent(j)];
			j = parent(j);
		}
		
		heap_item[j] = new_heap_item_ptr;
		
		// must set value of pointer to NULL so it no longer points at the item now in the heap
		// this is because that now item 'belongs to the heap'

		// I don't think this does what is required !
		new_heap_item_ptr = NULL;
		
	}
	
	// success !

#ifdef DEBUG
	cerr << "Heap::insert : successful, heap size is now " << heap_size << endl;
#endif

	return inserted_ok;

}


/*
int
Heap::get_heap_size(){
	return(heap_size);
}
*/






Heap_Item::Heap_Item() : h_eval_fn(0.0), h_length(0){

}


Heap_Item::Heap_Item(float initial_eval_fn) : h_eval_fn(initial_eval_fn), h_length(0){

}


Heap_Item::~Heap_Item(){

}


bool
operator > (Heap_Item& h1,  Heap_Item& h2){

	if(h1.h_eval_fn > h2.h_eval_fn)
		return true;

	return false;

};



ostream&
operator << (ostream& ost, Heap_Item&){

	ost << "Heap_Item";

	return ost;

}
